/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.server;

import com.g0kla.telem.server.STP;
import com.g0kla.telem.server.SortedStpTotalRowList;
import com.g0kla.telem.server.StpTotalRow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.StringTokenizer;

public class LeaderboardTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    SortedStpTotalRowList totals;
    String fileName;

    public LeaderboardTable(String file) throws NumberFormatException, IOException {
        this.fileName = file;
        this.totals = new SortedStpTotalRowList();
        this.load();
    }

    public void add(STP stp) throws IOException {
        StpTotalRow totalRecord = new StpTotalRow(stp);
        StpTotalRow existing = this.totals.findRow(totalRecord);
        if (existing == null) {
            this.totals.add(totalRecord);
        } else {
            existing.update();
        }
        this.totals.sort(null);
        this.save();
    }

    private void save() throws IOException {
        File aFile = new File(this.fileName);
        this.createNewFile(this.fileName);
        BufferedWriter output = new BufferedWriter(new FileWriter(aFile, false));
        try {
            for (StpTotalRow r : this.totals) {
                output.write(String.valueOf(r.toFile()) + "\n");
                ((Writer)output).flush();
            }
        }
        finally {
            ((Writer)output).flush();
            ((Writer)output).close();
        }
    }

    private boolean createNewFile(String log) throws IOException {
        File aFile = new File(log);
        if (!aFile.exists()) {
            aFile.createNewFile();
            return true;
        }
        return false;
    }

    public void load() throws IOException, NumberFormatException {
        File aFile = new File(this.fileName);
        if (this.createNewFile(this.fileName)) {
            BufferedWriter output = new BufferedWriter(new FileWriter(aFile, true));
            ((Writer)output).close();
        }
        try (BufferedReader dis = new BufferedReader(new FileReader(aFile.getPath()));){
            String line;
            while ((line = dis.readLine()) != null) {
                if (line == null) continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                StpTotalRow row = new StpTotalRow(st);
                this.totals.add(row);
            }
        }
    }

    public String toString() {
        String s = "LEADERBOARD TABLE\n";
        for (StpTotalRow r : this.totals) {
            s = String.valueOf(s) + r + "\n";
        }
        return s;
    }
}

