/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.server;

import com.g0kla.telem.server.STPable;
import com.g0kla.telem.server.Sequence;
import com.g0kla.telem.server.StpFileProcessException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class STP
implements Comparable<STP> {
    public static final DateFormat stpDateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss", Locale.ENGLISH);
    private static Sequence sequence;
    public static final String NONE = "NONE";
    public int id;
    public int resets;
    public long uptime;
    public int type;
    public String receiver = "NONE";
    private String frequency = "NONE";
    public String source;
    private String length;
    public String rx_location = "NONE";
    public String receiver_rf = "NONE";
    public String demodulator;
    private Date stpDate;
    public long sequenceNumber = -1L;
    private String measuredTCA = "NONE";
    private String measuredTCAfrequency = "NONE";
    int numberBytesAdded = 0;
    protected int[] bytes;
    static char pattern;
    static char escapeChar;

    static {
        pattern = (char)44;
        escapeChar = (char)126;
    }

    public STP(int id, String callsign, String latitude, String longitude, String altitude, String stationDetails, String software, String recordSource, long sequenceNum, STPable record) {
        this.id = id;
        this.receiver = callsign;
        this.rx_location = String.valueOf(this.formatLatitude(latitude)) + " " + this.formatLongitude(longitude);
        if (this.notNone(altitude)) {
            this.rx_location = String.valueOf(this.rx_location) + " " + altitude;
        }
        this.receiver_rf = stationDetails;
        String os = System.getProperty("os.name").toLowerCase();
        this.demodulator = String.valueOf(software) + " (" + os + ")";
        this.stpDate = Calendar.getInstance().getTime();
        this.source = recordSource;
        this.sequenceNumber = sequenceNum;
        this.bytes = record.getRawBytes();
        this.length = "" + this.bytes.length;
    }

    public STP(int id, Date stpDate, String callsign, String location, String stationDetails, String software, String recordSource, long sequenceNum, int[] data) {
        this.id = id;
        this.receiver = callsign;
        this.rx_location = location;
        this.receiver_rf = stationDetails;
        String os = System.getProperty("os.name").toLowerCase();
        this.demodulator = String.valueOf(software) + " (" + os + ")";
        this.stpDate = stpDate;
        this.source = recordSource;
        this.sequenceNumber = sequenceNum;
        this.bytes = data;
        this.length = "" + this.bytes.length;
    }

    public STP(BufferedReader file) throws IOException {
        this.load(file);
    }

    public STP(int[] data) throws IOException {
        this.parseFromBytes(data);
    }

    public void setFrequency(long freq) {
        this.frequency = String.valueOf(Long.toString(Math.round(freq))) + " Hz";
    }

    public void setTCA(Date tca, long tcaFreq) {
        stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.measuredTCA = stpDateFormat.format(tca);
        this.measuredTCAfrequency = String.valueOf(Long.toString(Math.round(tcaFreq))) + " Hz";
    }

    private boolean notNone(String s) {
        if (s.equalsIgnoreCase(NONE)) {
            return false;
        }
        return !s.equalsIgnoreCase("");
    }

    private String formatLatitude(String lat) {
        String s = "";
        float f = Float.parseFloat(lat);
        s = f >= 0.0f ? "N " + lat : "S " + Math.abs(f);
        return s;
    }

    public String getStpDate() {
        if (this.stpDate == null) {
            return null;
        }
        return stpDateFormat.format(this.stpDate);
    }

    private String formatLongitude(String lon) {
        String s = "";
        float f = Float.parseFloat(lon);
        s = f >= 0.0f ? "E " + lon : "W " + Math.abs(f);
        return s;
    }

    @Override
    public int compareTo(STP f) {
        if (this.sequenceNumber == f.sequenceNumber) {
            return 0;
        }
        if (this.sequenceNumber < f.sequenceNumber) {
            return -1;
        }
        if (this.sequenceNumber > f.sequenceNumber) {
            return 1;
        }
        return 1;
    }

    private String getSTPCoreHeader() {
        stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = stpDateFormat.format(this.stpDate);
        String header = "Sequence: " + this.sequenceNumber + "\r\n";
        header = String.valueOf(header) + "Source: " + this.source + "\r\n";
        header = String.valueOf(header) + "Length: " + this.length + "\r\n";
        header = String.valueOf(header) + "Date: " + date + " UTC\r\n";
        header = String.valueOf(header) + "Receiver: " + this.receiver + "\r\n";
        header = String.valueOf(header) + "Rx-Location: " + this.rx_location + "\r\n";
        if (this.notNone(this.frequency)) {
            header = String.valueOf(header) + "Frequency: " + this.frequency + "\r\n";
        }
        if (this.notNone(this.receiver_rf)) {
            header = String.valueOf(header) + "Receiver-RF: " + this.receiver_rf + "\r\n";
        }
        if (this.notNone(this.demodulator)) {
            header = String.valueOf(header) + "Demodulator: " + this.demodulator + "\r\n";
        }
        return header;
    }

    private String getSTPExtendedHeader() {
        String header = "";
        if (this.notNone(this.measuredTCA)) {
            header = "MeasuredTCA: " + this.measuredTCA + " UTC\r\n";
            header = String.valueOf(header) + "MeasuredTCAFrequency: " + this.measuredTCAfrequency + "\r\n";
        }
        return header;
    }

    private String escapeComma(String s) {
        return s.replace(pattern, escapeChar);
    }

    private String insertComma(String s) {
        return s.replace(escapeChar, pattern);
    }

    public void save(BufferedWriter output) throws IOException {
        output.write(String.valueOf(Long.toString(this.sequenceNumber)) + "," + this.id + "," + this.escapeComma(this.source) + "," + this.escapeComma(this.receiver) + "," + this.escapeComma(this.frequency) + "," + this.escapeComma(this.rx_location) + "," + this.escapeComma(this.receiver_rf) + "," + this.escapeComma(this.demodulator) + "," + this.stpDate.getTime() + "," + this.length + ",");
        int i2 = 0;
        while (i2 < this.bytes.length - 1) {
            output.write(String.valueOf(Integer.toString(this.bytes[i2])) + ",");
            ++i2;
        }
        output.write(String.valueOf(Integer.toString(this.bytes[this.bytes.length - 1])) + "\n");
    }

    public STP(String fileName) throws IOException, StpFileProcessException {
        boolean done = false;
        int p = 0;
        File infile = new File(fileName);
        int[] data = new int[(int)infile.length()];
        try (FileInputStream in = new FileInputStream(fileName);){
            int c;
            while ((c = in.read()) != -1) {
                data[p++] = c;
            }
        }
        in.close();
        this.parseFromBytes(data);
    }

    public void parseFromBytes(int[] data) {
        int c;
        int lineLen = 0;
        boolean done = false;
        boolean readingKey = true;
        String key = "";
        String value = "";
        int[] rawFrame = null;
        int length = 0;
        this.receiver = null;
        this.stpDate = null;
        this.frequency = NONE;
        this.source = null;
        this.rx_location = NONE;
        this.receiver_rf = NONE;
        this.demodulator = null;
        this.sequenceNumber = -1L;
        this.measuredTCA = NONE;
        this.measuredTCAfrequency = NONE;
        boolean firstColon = true;
        int p = 0;
        while (!done && (c = data[p++]) != -1) {
            char ch = (char)c;
            if (c == 58 && firstColon) {
                firstColon = false;
                c = data[p++];
                c = data[p++];
                ch = (char)c;
                readingKey = false;
            }
            if (c == 13 || c == 10) {
                c = data[p++];
                if (length != 0 && lineLen == 1) {
                    rawFrame = new int[length / 8];
                    int i2 = 0;
                    while (i2 < length / 8) {
                        rawFrame[i2] = data[p++];
                        ++i2;
                    }
                    done = true;
                } else {
                    readingKey = true;
                    firstColon = true;
                    if (key.startsWith("Length")) {
                        this.length = value;
                        length = Integer.parseInt(value);
                    }
                    if (key.equalsIgnoreCase("Receiver")) {
                        this.receiver = value;
                    }
                    if (key.equalsIgnoreCase("Frequency")) {
                        this.frequency = value;
                    }
                    if (key.equalsIgnoreCase("Rx-location")) {
                        this.rx_location = value;
                    }
                    if (key.equalsIgnoreCase("Source")) {
                        this.source = value;
                    }
                    if (key.equalsIgnoreCase("Receiver-RF")) {
                        this.receiver_rf = value;
                    }
                    if (key.equalsIgnoreCase("Demodulator")) {
                        this.demodulator = value;
                    }
                    if (key.endsWith("Sequence")) {
                        this.sequenceNumber = Long.parseLong(value);
                    }
                    if (key.equalsIgnoreCase("MeasuredTCA")) {
                        this.measuredTCA = value;
                    }
                    if (key.equalsIgnoreCase("MeasuredTCAfrequency")) {
                        this.measuredTCAfrequency = value;
                    }
                    if (key.startsWith("Date")) {
                        String dt = value.replace(" UTC", "");
                        stpDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                        try {
                            this.stpDate = stpDateFormat.parse(dt);
                        }
                        catch (ParseException e) {
                            this.stpDate = null;
                        }
                        catch (NumberFormatException e) {
                            this.stpDate = null;
                        }
                        catch (Exception e) {
                            this.stpDate = null;
                        }
                    }
                    key = "";
                    value = "";
                    lineLen = 0;
                }
            } else if (readingKey) {
                key = String.valueOf(key) + ch;
            } else {
                value = String.valueOf(value) + ch;
            }
            ++lineLen;
        }
        if (this.stpDate == null) {
            this.stpDate = new Date(0L);
        }
        this.bytes = rawFrame;
    }

    public static String getTableCreateStmt() {
        String s = new String();
        s = String.valueOf(s) + "(stpDate varchar(35), id int, " + "sequenceNumber bigint, " + "length int, " + "source varchar(35)," + "receiver varchar(35)," + "frequency varchar(35)," + "rx_location varchar(35)," + "receiver_rf varchar(52)," + "demodulator varchar(100)," + "measuredTCA varchar(35)," + "measuredTCAfrequency varchar(35)," + "date_time timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,";
        s = String.valueOf(s) + "PRIMARY KEY (stpDate, id, receiver))";
        return s;
    }

    public PreparedStatement getPreparedInsertStmt(Connection con) throws SQLException {
        String dt = "";
        if (this.stpDate != null) {
            dt = stpDateFormat.format(this.stpDate);
        }
        String s = new String();
        if (this.demodulator.length() > 99) {
            this.demodulator = this.demodulator.substring(0, 99);
        }
        if (this.source.length() > 32) {
            this.source = this.source.substring(0, 32);
        }
        if (this.receiver.length() > 32) {
            this.receiver = this.receiver.substring(0, 32);
        }
        if (this.frequency.length() > 32) {
            this.frequency = this.frequency.substring(0, 32);
        }
        if (this.rx_location.length() > 32) {
            this.rx_location = this.rx_location.substring(0, 32);
        }
        if (this.receiver_rf.length() > 50) {
            this.receiver_rf = this.receiver_rf.substring(0, 50);
        }
        if (this.measuredTCA.length() > 32) {
            this.measuredTCA = this.measuredTCA.substring(0, 32);
        }
        if (this.measuredTCAfrequency.length() > 32) {
            this.measuredTCAfrequency = this.measuredTCAfrequency.substring(0, 32);
        }
        s = String.valueOf(s) + "insert into STP_HEADER (stpDate,  id, \n";
        s = String.valueOf(s) + "sequenceNumber,\n";
        s = String.valueOf(s) + "length,\n";
        s = String.valueOf(s) + "source,\n";
        s = String.valueOf(s) + "receiver,\n";
        s = String.valueOf(s) + "frequency,\n";
        s = String.valueOf(s) + "rx_location,\n";
        s = String.valueOf(s) + "receiver_rf,\n";
        s = String.valueOf(s) + "demodulator,\n";
        s = String.valueOf(s) + "measuredTCA,\n";
        s = String.valueOf(s) + "measuredTCAfrequency)\n";
        s = String.valueOf(s) + "values (?, ?," + "?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = con.prepareStatement(s);
        ps.setString(1, dt);
        ps.setInt(2, this.id);
        ps.setLong(3, this.sequenceNumber);
        ps.setString(4, this.length);
        ps.setString(5, this.source);
        ps.setString(6, this.receiver);
        ps.setString(7, this.frequency);
        ps.setString(8, this.rx_location);
        ps.setString(9, this.receiver_rf);
        ps.setString(10, this.demodulator);
        ps.setString(11, this.measuredTCA);
        ps.setString(12, this.measuredTCAfrequency);
        return ps;
    }

    public void load(BufferedReader input) throws IOException {
        String line = input.readLine();
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line, ",");
            this.sequenceNumber = Long.parseLong(st.nextToken());
            this.id = Integer.parseInt(st.nextToken());
            this.source = this.insertComma(st.nextToken());
            this.receiver = this.insertComma(st.nextToken());
            this.frequency = this.insertComma(st.nextToken());
            this.rx_location = this.insertComma(st.nextToken());
            this.receiver_rf = this.insertComma(st.nextToken());
            this.demodulator = this.insertComma(st.nextToken());
            this.stpDate = new Date(Long.parseLong(st.nextToken()));
            this.length = st.nextToken();
            int len = Integer.parseInt(this.length);
            this.bytes = new int[len];
            int i2 = 0;
            while (i2 < len) {
                this.bytes[i2] = Integer.parseInt(st.nextToken());
                ++i2;
            }
        }
    }

    public int[] getServerBytes() {
        int b;
        String header = this.getSTPCoreHeader();
        header = String.valueOf(header) + this.getSTPExtendedHeader();
        header = String.valueOf(header) + "\r\n";
        byte[] headerBytes = header.getBytes();
        int j = 0;
        int[] buffer = new int[headerBytes.length + this.bytes.length];
        Object[] objectArray = headerBytes;
        int n = headerBytes.length;
        int n2 = 0;
        while (n2 < n) {
            b = objectArray[n2];
            buffer[j++] = b;
            ++n2;
        }
        objectArray = this.bytes;
        n = this.bytes.length;
        n2 = 0;
        while (n2 < n) {
            b = objectArray[n2];
            buffer[j++] = b;
            ++n2;
        }
        return buffer;
    }

    public String toString() {
        String s = "";
        s = this.getSTPCoreHeader();
        s = String.valueOf(s) + this.getSTPExtendedHeader();
        s = String.valueOf(s) + "\n";
        return s;
    }
}

