/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.server;

import com.g0kla.telem.segDb.DataTable;
import com.g0kla.telem.server.STP;
import com.g0kla.telem.server.TlmServer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class STPQueue
implements Runnable {
    ConcurrentLinkedQueue<STP> rawRecords;
    protected boolean updatedQueue = false;
    protected TlmServer server;
    protected boolean running = false;
    String fileName;

    public STPQueue(String file, String server, int port) throws IOException {
        this.server = new TlmServer(server, port, true);
        this.fileName = file;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        this.rawRecords = new ConcurrentLinkedQueue();
        STPQueue sTPQueue = this;
        synchronized (sTPQueue) {
            this.load(this.fileName);
        }
    }

    public boolean add(STP f) throws IOException {
        this.save(f, this.fileName);
        return this.rawRecords.add(f);
    }

    public void delete() throws SecurityException, IOException {
        DataTable.remove(this.fileName);
        this.init();
    }

    protected void load(String log) throws IOException {
        File aFile = new File(log);
        if (!aFile.exists()) {
            aFile.createNewFile();
        }
        FileInputStream dis = new FileInputStream(log);
        BufferedReader reader = new BufferedReader(new InputStreamReader(dis));
        while (reader.ready()) {
            STP record = new STP(reader);
            this.rawRecords.add(record);
        }
        this.updatedQueue = true;
        dis.close();
    }

    public int getSize() {
        return this.rawRecords.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(STP frame, String log) throws IOException {
        STPQueue sTPQueue = this;
        synchronized (sTPQueue) {
            File aFile = new File(log);
            if (!aFile.exists()) {
                aFile.createNewFile();
            }
            FileOutputStream dis = new FileOutputStream(log, true);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dis));
            try {
                frame.save(writer);
            }
            finally {
                writer.flush();
                writer.close();
            }
            writer.close();
            dis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteAndSave(ConcurrentLinkedQueue<STP> frames, String log) throws IOException {
        STPQueue sTPQueue = this;
        synchronized (sTPQueue) {
            frames.poll();
            File aFile = new File(log);
            if (!aFile.exists()) {
                aFile.createNewFile();
            }
            FileOutputStream dis = new FileOutputStream(log, false);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dis));
            try {
                for (STP f : frames) {
                    f.save(writer);
                }
            }
            finally {
                writer.flush();
                writer.close();
            }
        }
    }

    protected boolean sendFrame() throws IOException {
        boolean success = false;
        if (this.rawRecords.peek() != null) {
            int[] buffer = this.rawRecords.peek().getServerBytes();
            this.server.sendToServer(buffer, 0);
            success = true;
        }
        if (success) {
            try {
                this.deleteAndSave(this.rawRecords, this.fileName);
            }
            catch (IOException e) {
                throw new IOException("Could not remove raw frames from the queue file:\n" + this.fileName + "\n" + " The frame will be sent again.  If this error repeats you may need to remove the queue file manually");
            }
        }
        return success;
    }

    public void stopProcessing() {
        this.running = false;
    }
}

