/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.server;

import com.g0kla.telem.server.STP;
import java.util.Date;
import java.util.StringTokenizer;

public class StpTotalRow
implements Comparable<StpTotalRow> {
    public String receiver;
    public String layoutName;
    public int total;
    public Date lastUpdated;

    public StpTotalRow(STP stp) {
        this.receiver = stp.receiver;
        this.layoutName = stp.source;
        this.total = 1;
        this.lastUpdated = new Date();
    }

    public StpTotalRow(StringTokenizer st) {
        long updated = Long.valueOf(st.nextToken());
        this.lastUpdated = new Date(updated);
        this.receiver = st.nextToken();
        this.layoutName = st.nextToken();
        this.total = Integer.valueOf(st.nextToken());
    }

    public void update() {
        ++this.total;
        this.lastUpdated = new Date();
    }

    @Override
    public int compareTo(StpTotalRow p) {
        if (this.total == p.total) {
            return 0;
        }
        if (this.total < p.total) {
            return 1;
        }
        if (this.total > p.total) {
            return -1;
        }
        return 0;
    }

    public String toFile() {
        String s = "";
        s = String.valueOf(s) + this.lastUpdated.getTime() + ",";
        s = String.valueOf(s) + this.receiver + ",";
        s = String.valueOf(s) + this.layoutName + ",";
        s = String.valueOf(s) + this.total;
        return s;
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + this.receiver + " ";
        s = String.valueOf(s) + this.layoutName + ":  ";
        s = String.valueOf(s) + this.total + " Last Record: ";
        s = String.valueOf(s) + this.lastUpdated;
        return s;
    }
}

