/*
 * Decompiled with CFR 0.152.
 */
package com.g0kla.telem.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class TlmServer {
    public static final int TCP = 0;
    public static final int UDP = 1;
    public static final int FTP_PORT = 22;
    public static final boolean KEEP_OPEN = false;
    public static final boolean AUTO_CLOSE = true;
    String hostName;
    int portNumber;
    boolean autoClose = true;
    Socket socket = null;
    OutputStream out = null;

    public TlmServer(String hostName, int portNumber, boolean autoClose) {
        this.hostName = hostName;
        this.portNumber = portNumber;
        this.autoClose = autoClose;
    }

    public String getHostname() {
        return this.hostName;
    }

    public int getPort() {
        return this.portNumber;
    }

    public void setHostName(String hostName) {
        if (this.hostName != hostName) {
            this.close();
        }
        this.hostName = hostName;
    }

    public void setPort(int port) {
        if (this.portNumber != port) {
            this.close();
        }
        this.portNumber = port;
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.out = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    public void sendToServer(int[] data, int protocol) throws UnknownHostException, IOException {
        byte[] buffer = new byte[data.length];
        int i2 = 0;
        while (i2 < data.length) {
            buffer[i2] = (byte)data[i2];
            ++i2;
        }
        if (protocol == 0) {
            if (this.autoClose || this.socket == null) {
                this.socket = new Socket(this.hostName, this.portNumber);
                this.out = this.socket.getOutputStream();
            }
            this.out.write(buffer);
            if (this.autoClose) {
                this.close();
            }
        } else {
            DatagramSocket socket = new DatagramSocket();
            InetAddress address = InetAddress.getByName(this.hostName);
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, address, this.portNumber);
            socket.send(packet);
            socket.close();
        }
    }
}

