/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Config;
import gui.MainWindow;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JOptionPane;

public class Log {
    static PrintWriter output = null;
    public static final DateFormat fileDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final DateFormat logDateName = new SimpleDateFormat("yyyyMMdd");
    public static String logFile = "PacSatGround";
    public static Thread.UncaughtExceptionHandler uncaughtExHandler;
    public static boolean showGuiDialogs;

    static {
        showGuiDialogs = true;
    }

    public static void init(String logFile) {
        Log.logFile = Log.rollLog(logFile);
        if (Config.getBoolean("logging")) {
            try {
                Config.get("logfile_dir").equalsIgnoreCase("");
                File aFile = new File(Log.logFile);
                if (Config.getBoolean("echo_to_stdout")) {
                    System.out.println("Creating: " + Log.logFile);
                }
                if (!aFile.exists()) {
                    aFile.createNewFile();
                }
                output = new PrintWriter(new FileWriter(aFile, true));
            }
            catch (IOException e) {
                System.err.println("FATAL ERROR: Cannot write log file: " + logFile + "\n" + "Perhaps the disk is full or the directory is not writable:\n" + Config.get("logfile_dir"));
                e.printStackTrace();
                Log.errorDialog("FATAL ERROR", "Cannot write log file: " + logFile + "\n" + "Perhaps the disk is full or the directory is not writable:\n" + Config.get("logfile_dir") + "\n\n" + "Try creating this directory if it does not exist:\n" + Config.get("logfile_dir") + "\n\n" + "You can reset PacSat Ground by deleting the settings file (might want to back it up first):\n" + Config.homeDir + File.separator + "PacSatGround.properties");
                System.exit(1);
            }
        }
        uncaughtExHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                ex.printStackTrace(Log.getWriter());
                String stacktrace = Log.makeShortTrace(ex.getStackTrace());
                Log.errorDialog("SERIOUS ERROR", "Uncaught exception.  You probablly need to restart:\n" + ex + "\n" + stacktrace);
                if (!showGuiDialogs) {
                    Log.alert("Uncaught exception.  Need to clear the ALERT and restart the server:\n" + stacktrace);
                }
            }
        };
    }

    public static String makeShortTrace(StackTraceElement[] elements) {
        String stacktrace = "";
        int limit = 8;
        int i2 = 0;
        while (i2 < limit && i2 < elements.length) {
            stacktrace = String.valueOf(stacktrace) + elements[i2] + "\n";
            ++i2;
        }
        if (elements.length > limit) {
            stacktrace = String.valueOf(stacktrace) + " ... " + (elements.length - limit) + " items not shown .... ";
        }
        return stacktrace;
    }

    public static String rollLog(String logFile) {
        Date today = Calendar.getInstance().getTime();
        logDateName.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = logDateName.format(today);
        return String.valueOf(logFile) + reportDate + ".log";
    }

    public static void alert(String message) {
        try {
            Log.println("ALERT: " + message);
            logFile = String.valueOf(logFile) + ".ALERT";
            File aFile = new File(logFile);
            if (!aFile.exists()) {
                aFile.createNewFile();
            }
            PrintWriter out = new PrintWriter(new FileWriter(aFile, true));
            out.write(String.valueOf(Log.fileDateStamp()) + message + System.getProperty("line.separator"));
            out.flush();
            out.close();
            System.exit(9);
        }
        catch (Exception e) {
            System.err.println("FATAL ERROR: Cannot write log file: FoxTelemDecoder.log\nPerhaps the disk is full or the directory is not writable:\n" + Config.get("logfile_dir"));
            e.printStackTrace();
            Log.errorDialog("FATAL ERROR", "Cannot write log file: FoxTelemDecoder.log\nPerhaps the disk is full or the directory is not writable:\n" + Config.get("logfile_dir") + "\n\n" + "You can reset FoxTelem by deleting the settings file (might want to back it up first):\n" + Config.homeDir + File.separator + "FoxTelem.properties");
            System.exit(1);
        }
    }

    public static boolean getLogging() {
        return Config.getBoolean("logging");
    }

    public static void setLogging(boolean on) {
        Config.set("logging", on);
    }

    public static PrintWriter getWriter() {
        if (output != null) {
            return output;
        }
        return new PrintWriter(System.err);
    }

    public static void print(String s) {
        if (Config.getBoolean("logging")) {
            if (output == null) {
                Log.init(logFile);
            }
            output.write(s);
            Log.flush();
        }
        System.out.print(s);
    }

    public static void println(String s) {
        if (Config.getBoolean("logging")) {
            if (output == null) {
                Log.init("PacSatGround");
            }
            output.write(String.valueOf(Log.fileDateStamp()) + s + System.getProperty("line.separator"));
            Log.flush();
        }
        System.out.println(s);
    }

    public static void errorDialog(String title, String message) {
        Log.dialog(title, message, 0);
    }

    public static void infoDialog(String title, String message) {
        Log.dialog(title, message, 1);
    }

    public static void dialog(String title, String message, int type) {
        try {
            if (showGuiDialogs) {
                JOptionPane.showMessageDialog(MainWindow.frame, message.toString(), title, type);
            } else {
                Log.println(String.valueOf(title) + " " + message.toString());
            }
        }
        catch (Exception e) {
            System.err.println("FATAL ERROR: Cannot show dialog: " + title + "\n" + message + "\n");
            System.exit(1);
        }
    }

    public static int optionYNdialog(String title, String message) {
        if (!showGuiDialogs) {
            return 1;
        }
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(MainWindow.frame, message.toString(), title, 0, 3, null, options, options[1]);
        return n;
    }

    public static String fileDateStamp() {
        Date today = Calendar.getInstance().getTime();
        fileDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String reportDate = String.valueOf(fileDateFormat.format(today)) + ": ";
        return reportDate;
    }

    public static void flush() {
        if (Config.getBoolean("logging") && output != null) {
            output.flush();
        }
    }

    public static void close() {
        if (Config.getBoolean("logging") && output != null) {
            output.close();
        }
    }
}

