/*
 * Decompiled with CFR 0.152.
 */
package common;

import ax25.DataLinkStateMachine;
import com.g0kla.telem.data.ConversionTable;
import com.g0kla.telem.segDb.SatTelemStore;
import com.g0kla.telem.segDb.Spacecraft;
import common.CommandParams;
import common.Config;
import common.ConfigFile;
import common.LayoutLoadException;
import common.Log;
import fileStore.Directory;
import fileStore.Outbox;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import passControl.DownlinkStateMachine;
import passControl.UplinkStateMachine;

public class SpacecraftSettings
extends ConfigFile
implements Comparable<SpacecraftSettings> {
    public String name;
    public Directory directory;
    public Outbox outbox;
    public SatTelemStore db;
    public Spacecraft spacecraft;
    public ArrayList<CommandParams> commandParams;
    public ArrayList<ArrayList<String>> commandLists;
    public ArrayList<String> commandListNames;
    public Thread downlinkThread;
    public Thread uplinkThread;
    public UplinkStateMachine uplink;
    public DownlinkStateMachine downlink;
    public Thread layer2Thread;
    public DataLinkStateMachine layer2data;
    public byte[] key;
    public static String SPACECRAFT_DIR = "spacecraft";
    public static String SOURCE = "usaf.fs-3.pacsat.tlm";
    public static final String MIR_SAT_1 = "Mir-Sat-1";
    public static final int ERROR_IDX = -1;
    public static final int MAX_DIR_AGE = 99;
    public static final int MAX_DIR_TABLE_ENTRIES = 9999;
    public static final String BROADCAST_CALLSIGN = "broadcastCallsign";
    public static final String BBS_CALLSIGN = "bbsCallsign";
    public static final String DIGI_CALLSIGN = "digiCallsign";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String SEQUENCE_NUM = "sequence_num";
    public static final String DIR_AGE = "DIR_AGE";
    public static final String REQ_DIRECTORY = "request_directory";
    public static final String FILL_DIRECTORY_HOLES = "fill_directory_holes";
    public static final String REQ_FILES = "request_files";
    public static final String UPLOAD_FILES = "upload_files";
    public static final String TELEM_LAYOUT_FILE = "telemLayoutFile";
    public static final String TLMI_LAYOUT = "TLMI_LAYOUT";
    public static final String TLM1_LAYOUT = "TLM1_LAYOUT";
    public static final String TLM2_LAYOUT = "TLM2_LAYOUT";
    public static final String WOD_LAYOUT = "WOD_LAYOUT";
    public static final String FULL_WOD_LAYOUT = "FULL_WOD_LAYOUT";
    public static final String TLM16_LAYOUT = "TLM16_LAYOUT";
    public static final String TELEM_SERVER = "telem_server";
    public static final String NUMBER_DIR_TABLE_ENTRIES = "number_dir_table_entries";
    public static final String SHOW_SYSTEM_ON_DIR_TAB = "show_system_files_on_dir_tab";
    public static final String SHOW_USER_FILES = "show_user_files";
    public static final String SUPPORTS_FILE_UPLOAD = "supports_file_upload";
    public static final String SUPPORTS_PB_STATUS = "supports_pb_status";
    public static final String NORAD_ID = "norad_id";
    public static final String WEB_SITE_URL = "web_site_url";
    public static final String PSF_HEADER_CHECK_SUMS = "psf_header_check_sums";
    public static final String IS_COMMAND_STATION = "is_command_station";
    public static final String SECRET_KEY = "secret_key";
    public static final String COMMANDS_FILE = "commandsFile";

    public SpacecraftSettings(String fileName) throws LayoutLoadException, IOException {
        super(fileName);
        this.init();
        this.name = this.get(NAME);
        if (this.name == null) {
            throw new LayoutLoadException("Spacecraft file is corrput and can not be loaded.  Try replacing\n it with the original file from the download installation. File: " + fileName);
        }
        if (this.getBoolean(IS_COMMAND_STATION)) {
            this.loadCommands();
        }
        this.load_key();
        this.initDirectory();
        this.outbox = new Outbox(this, this.name);
        this.initStateMachines();
    }

    public ArrayList<String> getList(String name) {
        int i2 = 0;
        while (i2 < this.commandListNames.size()) {
            if (this.commandListNames.get(i2).equalsIgnoreCase(name)) {
                return this.commandLists.get(i2);
            }
            ++i2;
        }
        return null;
    }

    public ArrayList<String> getParamsByNamespace(int nameSpace) {
        ArrayList<String> names = new ArrayList<String>();
        for (CommandParams param : this.commandParams) {
            if (param.nameSpace != nameSpace) continue;
            names.add(param.name);
        }
        return names;
    }

    public CommandParams getParam(int nameSpace, String p) {
        for (CommandParams param : this.commandParams) {
            if (param.nameSpace != nameSpace || !param.name.equalsIgnoreCase(p)) continue;
            return param;
        }
        return null;
    }

    public void loadCommands() {
        this.commandParams = new ArrayList();
        this.commandListNames = new ArrayList();
        this.commandLists = new ArrayList();
        int listNum = 0;
        String fileName = "spacecraft" + File.separator + this.get(COMMANDS_FILE);
        Log.println("Loading Commands from: " + fileName);
        try {
            String line;
            BufferedReader dis = new BufferedReader(new FileReader(fileName));
            while ((line = dis.readLine()) != null) {
                if (line == null) continue;
                String[] items = line.split("\\s*,\\s*");
                try {
                    if (items[0].equalsIgnoreCase("LIST")) {
                        this.commandListNames.add(items[1]);
                        this.commandLists.add(new ArrayList());
                        int i2 = 2;
                        while (i2 < items.length) {
                            this.commandLists.get(listNum).add(items[i2]);
                            ++i2;
                        }
                        ++listNum;
                        continue;
                    }
                    CommandParams commandParam = new CommandParams(items);
                    this.commandParams.add(commandParam);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dis.close();
        }
        catch (FileNotFoundException n) {
            Log.errorDialog("ERROR", "Commands file not found.  Missing: " + fileName);
            this.set(IS_COMMAND_STATION, false);
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "Reading from commands file: " + fileName);
            this.set(IS_COMMAND_STATION, false);
        }
    }

    public void initDirectory() {
        this.directory = new Directory(this.name, this);
        ScheduledExecutorService ses = Executors.newScheduledThreadPool(2);
        ses.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("Dir Saver");
                SpacecraftSettings.this.directory.saveIfNeeded();
            }
        }, 300L, 300L, TimeUnit.SECONDS);
    }

    public void initSegDb(Spacecraft spacecraft) throws com.g0kla.telem.data.LayoutLoadException, IOException {
        ConversionTable ct = new ConversionTable(String.valueOf(Config.currentDir) + File.separator + "spacecraft" + File.separator + spacecraft.conversionCoefficientsFileName);
        int i2 = 0;
        while (i2 < spacecraft.layout.length) {
            spacecraft.layout[i2].setConversionTable(ct);
            ++i2;
        }
        this.db = new SatTelemStore(spacecraft.satId, String.valueOf(Config.get("logfile_dir")) + File.separator + this.name + File.separator + "TLMDB", spacecraft.layout);
    }

    @Override
    void initParams() {
        this.set(SEQUENCE_NUM, 0);
        this.set(REQ_DIRECTORY, true);
        this.set(FILL_DIRECTORY_HOLES, true);
        this.set(REQ_FILES, true);
        this.set(UPLOAD_FILES, true);
        this.set(NUMBER_DIR_TABLE_ENTRIES, 200);
        this.set(TELEM_LAYOUT_FILE, "FS-3.dat");
        this.set(IS_COMMAND_STATION, false);
        this.set(SECRET_KEY, "");
    }

    public int getNextSequenceNum() {
        int seq = this.getInt(SEQUENCE_NUM);
        if (++seq > 99) {
            seq = 0;
        }
        this.set(SEQUENCE_NUM, seq);
        this.save();
        return seq;
    }

    public boolean hasCallsign(String call) {
        String broadcastCall;
        if ((call = call.toUpperCase()).startsWith(broadcastCall = this.get(BROADCAST_CALLSIGN))) {
            return true;
        }
        String bbsCall = this.get(BBS_CALLSIGN);
        if (call.startsWith(bbsCall)) {
            return true;
        }
        String digiCall = this.get(DIGI_CALLSIGN);
        return call.startsWith(digiCall);
    }

    private void initStateMachines() {
        if (this.downlink != null) {
            this.downlink.stopRunning();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.downlink = new DownlinkStateMachine(this);
        this.downlinkThread = new Thread(this.downlink);
        this.downlinkThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.downlinkThread.setName("Downlink " + this.name);
        this.downlinkThread.start();
        if (this.uplink != null) {
            this.uplink.stopRunning();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.uplink = new UplinkStateMachine(this);
        this.uplinkThread = new Thread(this.uplink);
        this.uplinkThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.uplinkThread.setName("Uplink " + this.name);
        this.uplinkThread.start();
        this.initLayer2();
    }

    public void initLayer2() {
        if (this.layer2data != null) {
            this.layer2data.stopRunning();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.layer2data = new DataLinkStateMachine(this);
        this.layer2Thread = new Thread(this.layer2data);
        this.layer2Thread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.layer2Thread.setName("Layer2data " + this.name);
        this.layer2Thread.start();
    }

    public void load_key() {
        File file = new File(this.get(SECRET_KEY));
        this.key = new byte[32];
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(file));
            ((DataInputStream)dis).readFully(this.key);
            dis.close();
        }
        catch (FileNotFoundException e) {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            e.printStackTrace(Log.getWriter());
        }
        catch (IOException e) {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            e.printStackTrace(Log.getWriter());
        }
    }

    public void close() {
        this.downlink.stopRunning();
        this.uplink.stopRunning();
        this.layer2data.stopRunning();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(SpacecraftSettings s2) {
        return this.name.compareToIgnoreCase(s2.name);
    }
}

