/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import common.SpacecraftSettings;
import fileStore.DirSelectionCriteria;
import fileStore.PacSatField;
import fileStore.PacSatFileHeader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class DirSelectionEquation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PRIORITY = 2;
    public static final int ALWAYS = 0;
    public static final int CURRENT_DAY = 1;
    public static final int DAY_1_OLD = 2;
    public static final int DAY_2_OLD = 3;
    public static final int DAY_3_OLD = 4;
    public static final int DAY_4_OLD = 5;
    public static final int DAY_5_OLD = 6;
    public static final int DAY_10_OLD = 7;
    public static final int DAY_30_OLD = 8;
    public static final String[] DATES_RESTRICTIONS = new String[]{"Any date", "Current Day", "1 day or older", "2 days or older", "3 days or older", "4 days or older", "5 days or older", "10 days or older", "30 days or older"};
    ArrayList<DirSelectionCriteria> selectionCriteria = new ArrayList();
    String dirFolder;
    int priority = 2;
    int dateRestriction = 0;

    public DirSelectionEquation(SpacecraftSettings spacecraftSettings, int priority, int dateRestriction) {
        this.priority = priority;
        this.dateRestriction = dateRestriction;
    }

    public void add(DirSelectionCriteria criteria) {
        this.selectionCriteria.add(criteria);
    }

    public String getValue(int row) {
        if (row < this.selectionCriteria.size()) {
            return this.selectionCriteria.get((int)row).value;
        }
        return "";
    }

    public String getField(int row) {
        if (row < this.selectionCriteria.size()) {
            return this.selectionCriteria.get(row).getField();
        }
        return "";
    }

    public int getOperation(int row) {
        if (row < this.selectionCriteria.size()) {
            return this.selectionCriteria.get((int)row).operation;
        }
        return 0;
    }

    public int getOpType(int row) {
        if (row < this.selectionCriteria.size()) {
            return this.selectionCriteria.get((int)row).opType;
        }
        return 0;
    }

    public void setPriority(int pri) {
        this.priority = pri;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDateRestriction() {
        return this.dateRestriction;
    }

    public String getHashKey() {
        String s = "";
        for (DirSelectionCriteria crit : this.selectionCriteria) {
            s = String.valueOf(s) + crit.getHashKey() + "|";
        }
        s = String.valueOf(s) + this.dateRestriction;
        return s;
    }

    public boolean matchesPFH(PacSatFileHeader pfh) {
        if (this.dateRestriction != 0) {
            PacSatField field = pfh.getFieldById(18);
            Date uploadTime = field.getDateValue();
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(uploadTime);
            Date now = new Date();
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(now);
            if (this.dateRestriction == 1) {
                boolean sameDay;
                int d1 = cal1.get(6);
                int d2 = cal2.get(6);
                int y1 = cal1.get(1);
                int y2 = cal2.get(1);
                boolean bl = sameDay = d1 == d2 && y1 == y2;
                if (!sameDay) {
                    return false;
                }
            } else {
                long diff;
                long days;
                int days_old = this.dateRestriction - 1;
                if (this.dateRestriction == 7) {
                    days_old = 10;
                }
                if (this.dateRestriction == 8) {
                    days_old = 30;
                }
                if ((days = (diff = now.getTime() - uploadTime.getTime()) / 86400000L) <= (long)days_old) {
                    return false;
                }
            }
        }
        for (DirSelectionCriteria equation : this.selectionCriteria) {
            int key = equation.getPfhFieldKey();
            PacSatField field = pfh.getFieldById(key);
            if (field == null) {
                return false;
            }
            if (equation.matches(field)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "";
        s = this.priority == 9 ? String.valueOf(s) + "N|" : String.valueOf(s) + this.priority + "|";
        int j = 0;
        for (DirSelectionCriteria crit : this.selectionCriteria) {
            if (j > 0) {
                s = String.valueOf(s) + " AND ";
            }
            s = String.valueOf(s) + crit;
            ++j;
        }
        s = String.valueOf(s) + " |" + DATES_RESTRICTIONS[this.dateRestriction];
        return s;
    }
}

