/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import ax25.KissFrame;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.DirHole;
import fileStore.DirSelectionEquation;
import fileStore.MalformedPfhException;
import fileStore.PacSatField;
import fileStore.PacSatFile;
import fileStore.PacSatFileHeader;
import fileStore.SortedArrayList;
import fileStore.SortedPfhArrayList;
import fileStore.telem.LogFileTlm;
import fileStore.telem.LogFileWE;
import gui.DirEquationTableModel;
import gui.MainWindow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import pacSat.frames.BroadcastDirFrame;
import pacSat.frames.BroadcastFileFrame;

public class Directory {
    List<PacSatFileHeader> files;
    public static final String DIR_FILE_NAME = "directory.db";
    public static final int PRI_NONE = 0;
    public static final int PRI_NEVER = 9;
    public String dirFolder = "directory";
    String satname;
    HashMap<String, DirSelectionEquation> selectionList;
    SpacecraftSettings spacecraftSettings;
    boolean needsSaving = false;

    public Directory(String satname, SpacecraftSettings spacecraftSettings) {
        this.satname = satname;
        this.dirFolder = String.valueOf(Config.get("logfile_dir")) + File.separator + satname;
        this.spacecraftSettings = spacecraftSettings;
        this.files = Collections.synchronizedList(new SortedPfhArrayList());
        this.selectionList = new HashMap();
        File dir = new File(this.dirFolder);
        if (!dir.exists() && !Directory.makeDir(this.dirFolder)) {
            System.exit(1);
        }
        try {
            this.load();
        }
        catch (ClassNotFoundException e) {
            Log.errorDialog("ERROR", "Could not load the directory from disk, file is corrupt: " + e.getMessage());
        }
        catch (IOException e) {
            Log.infoDialog("New Directory", "Could not load the directory from disk, making new directory in: \n" + this.dirFolder + "\n" + e.getMessage());
        }
        try {
            this.loadDirSelections();
        }
        catch (ClassNotFoundException e) {
            Log.errorDialog("ERROR", "Could not load the directory select equations from disk, file is corrupt: " + e.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean hasHoles() {
        if (this.files.size() < 1) {
            return false;
        }
        return this.getHolesList().size() > 1;
    }

    public int getAge() {
        SortedArrayList<DirHole> holes = this.getHolesList();
        if (this.files.size() < 1) {
            return 0;
        }
        if (holes.size() < 1) {
            return 0;
        }
        DirHole oldestHole = (DirHole)holes.get(holes.size() - 1);
        Date now = new Date();
        long first = oldestHole.getFirst();
        Date firstDate = new Date(first * 1000L);
        long diff = now.getTime() - firstDate.getTime();
        long diffDays = (int)(diff / 86400000L);
        return (int)diffDays;
    }

    public SortedArrayList<DirHole> getHolesList() {
        SortedArrayList<DirHole> holes = this.updateHoles();
        SortedArrayList<DirHole> agedHoles = this.ageHoleList(holes);
        return agedHoles;
    }

    public String getHolFileName() {
        return String.valueOf(this.dirFolder) + File.separator + DIR_FILE_NAME + ".hol";
    }

    public String getDirSelectionsFileName() {
        return String.valueOf(this.dirFolder) + File.separator + DIR_FILE_NAME + ".equ";
    }

    private SortedArrayList<DirHole> initEmptyHolesList() {
        SortedArrayList<DirHole> holes = new SortedArrayList<DirHole>();
        int[] toBy = new int[]{255, 255, 255, 127};
        long to = KissFrame.getLongFromBytes(toBy);
        Date toDate = new Date(to * 1000L);
        Date frmDate = this.agedDirDate();
        DirHole hole = new DirHole(frmDate, toDate);
        holes.add(hole);
        return holes;
    }

    private Date agedDirDate() {
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        int lookback = this.spacecraftSettings.getInt("DIR_AGE");
        cal.add(5, -1 * lookback);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedArrayList<DirHole> updateHoles() {
        if (this.files == null || this.files.size() == 0) {
            return this.initEmptyHolesList();
        }
        PacSatFileHeader prev = null;
        SortedArrayList<DirHole> holes = new SortedArrayList<DirHole>();
        List<PacSatFileHeader> list = this.files;
        synchronized (list) {
            for (PacSatFileHeader current : this.files) {
                DirHole hole;
                if (prev == null) {
                    prev = current;
                    hole = new DirHole(0L, current.timeOld - 1L);
                    holes.add(hole);
                    continue;
                }
                if (prev.timeNew + 1L < current.timeOld) {
                    hole = new DirHole(prev.timeNew + 1L, current.timeOld - 1L);
                    holes.add(hole);
                }
                prev = current;
            }
        }
        int[] toBy = new int[]{255, 255, 255, 127};
        long to = KissFrame.getLongFromBytes(toBy);
        long from = prev.timeNew + 1L;
        DirHole hole = new DirHole(from, to);
        holes.add(hole);
        return holes;
    }

    SortedArrayList<DirHole> ageHoleList(SortedArrayList<DirHole> holes) {
        SortedArrayList<DirHole> newHoles = new SortedArrayList<DirHole>();
        Date age = this.agedDirDate();
        Date now = new Date();
        boolean moreHoles = true;
        Iterator iterator = holes.iterator();
        while (iterator.hasNext() && moreHoles) {
            DirHole hole = (DirHole)iterator.next();
            long last = hole.getLast();
            Date lastDate = new Date(last * 1000L);
            long diff = now.getTime() - lastDate.getTime();
            long days = diff / 86400000L;
            if (days > (long)this.spacecraftSettings.getInt("DIR_AGE")) {
                moreHoles = false;
                hole = newHoles.size() == 0 ? new DirHole(hole.getFirstDate(), age) : null;
            }
            if (hole == null) continue;
            long first = hole.getFirst();
            Date firstDate = new Date(first * 1000L);
            long firstDiff = now.getTime() - firstDate.getTime();
            long firstDays = firstDiff / 86400000L;
            if (firstDays > (long)this.spacecraftSettings.getInt("DIR_AGE")) {
                hole = new DirHole(age, hole.getLastDate());
            }
            newHoles.add(hole);
        }
        return newHoles;
    }

    private void saveDirSelections() throws IOException {
        FileOutputStream fileOut = null;
        ObjectOutputStream objectOut = null;
        try {
            fileOut = new FileOutputStream(this.getDirSelectionsFileName());
            objectOut = new ObjectOutputStream(fileOut);
            objectOut.writeObject(this.selectionList);
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.close();
                }
                catch (Exception exception) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void loadDirSelections() throws IOException, ClassNotFoundException {
        ObjectInputStream objectIn = null;
        FileInputStream streamIn = null;
        try {
            streamIn = new FileInputStream(this.getDirSelectionsFileName());
            objectIn = new ObjectInputStream(streamIn);
            this.selectionList = (HashMap)objectIn.readObject();
        }
        finally {
            if (objectIn != null) {
                try {
                    objectIn.close();
                }
                catch (Exception exception) {}
            }
            if (streamIn != null) {
                try {
                    streamIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void add(DirSelectionEquation equation) throws IOException {
        this.selectionList.put(equation.getHashKey(), equation);
        this.saveDirSelections();
    }

    public void deleteEquations() throws IOException {
        Directory.remove(this.getDirSelectionsFileName());
        this.selectionList = new HashMap();
    }

    public String getEquationsString() {
        String s = "";
        for (String key : this.selectionList.keySet()) {
            s = String.valueOf(s) + this.selectionList.get(key) + "\n";
        }
        return s;
    }

    public DirSelectionEquation getEquation(String key) {
        return this.selectionList.get(key);
    }

    public void deleteEquation(String key) {
        this.selectionList.remove(key);
        try {
            this.saveDirSelections();
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "Could not save the Directory Equations File: " + e.getMessage());
        }
    }

    public String[][] getEquationsData() {
        String[][] data = new String[this.selectionList.size()][2];
        if (this.selectionList.size() == 0) {
            return DirEquationTableModel.BLANK;
        }
        int k = 0;
        for (String key : this.selectionList.keySet()) {
            data[k][0] = key;
            data[k++][1] = "" + this.selectionList.get(key);
        }
        return data;
    }

    public DirSelectionEquation hasMatchingEquation(PacSatFileHeader pfh) {
        for (String key : this.selectionList.keySet()) {
            DirSelectionEquation eq = this.selectionList.get(key);
            if (!eq.matchesPFH(pfh)) continue;
            return eq;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastHeaderDate() {
        Date lastDate = null;
        List<PacSatFileHeader> list = this.files;
        synchronized (list) {
            if (this.files.size() < 1) {
                return new Date(1L);
            }
            int i2 = this.files.size() - 1;
            while (i2 >= 0) {
                lastDate = this.files.get(this.files.size() - 1).getDate(18);
                if (lastDate != null) break;
                --i2;
            }
        }
        if (lastDate == null) {
            return new Date(1L);
        }
        return lastDate;
    }

    public boolean needFile() {
        long fileId = this.getMostUrgentFile();
        return fileId != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMostUrgentFile() {
        if (this.files.size() < 1) {
            return 0L;
        }
        PacSatFileHeader fileToDownload = null;
        List<PacSatFileHeader> list = this.files;
        synchronized (list) {
            int i2 = this.files.size() - 1;
            while (i2 >= 0) {
                PacSatFileHeader pfh = this.files.get(i2);
                if (pfh.getState() != 4 && pfh.getState() != 3 && pfh.getState() != 2 && pfh.userDownLoadPriority > 0 && pfh.userDownLoadPriority < 9) {
                    if (fileToDownload == null) {
                        fileToDownload = pfh;
                    } else if (pfh.userDownLoadPriority < fileToDownload.userDownLoadPriority) {
                        fileToDownload = pfh;
                    }
                }
                --i2;
            }
        }
        if (fileToDownload == null) {
            return 0L;
        }
        return fileToDownload.getFileId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacSatFileHeader getPfhById(long id) {
        List<PacSatFileHeader> list = this.files;
        synchronized (list) {
            for (PacSatFileHeader pfh : this.files) {
                if (pfh.getFileId() != id) continue;
                return pfh;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(BroadcastDirFrame dir) throws IOException {
        PacSatFileHeader existingPfh = this.getPfhById(dir.fileId);
        if (dir.hasEndOfFile() && dir.getOffset() == 0L) {
            PacSatFileHeader pfh = dir.pfh;
            if (pfh == null) return false;
            List<PacSatFileHeader> list = this.files;
            synchronized (list) {
                if (!((SortedPfhArrayList)this.files).addOrReplace(pfh)) return false;
                this.needsSaving = true;
                PacSatFile psf = new PacSatFile(this.spacecraftSettings, this.dirFolder, pfh.getFileId());
                psf.addFrame(this.spacecraftSettings, dir);
                return true;
            }
        }
        PacSatFile psf = new PacSatFile(this.spacecraftSettings, this.dirFolder, dir.fileId);
        psf.addFrame(this.spacecraftSettings, dir);
        RandomAccessFile fileOnDisk = new RandomAccessFile(psf.getFileName(), "r");
        try {
            PacSatFileHeader pfh = new PacSatFileHeader(fileOnDisk);
            if (pfh == null) return false;
            pfh.timeNew = dir.getLast();
            pfh.timeOld = dir.getFirst();
            List<PacSatFileHeader> list = this.files;
            synchronized (list) {
                if (!((SortedPfhArrayList)this.files).addOrReplace(pfh)) return false;
                this.needsSaving = true;
                if (existingPfh == null) return true;
                PacSatFile psf2 = new PacSatFile(this.spacecraftSettings, this.dirFolder, pfh.getFileId());
                psf2.addFrame(this.spacecraftSettings, dir);
                return true;
            }
        }
        catch (MalformedPfhException malformedPfhException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(BroadcastFileFrame bf) throws IOException, MalformedPfhException, LayoutLoadException, NumberFormatException, DataLoadException {
        PacSatFile psf;
        PacSatFileHeader pfh;
        block13: {
            pfh = this.getPfhById(bf.fileId);
            if (pfh != null && (pfh.state == 3 || pfh.state == 2)) {
                pfh.userDownLoadPriority = 0;
                return false;
            }
            if (this.spacecraftSettings.name.equalsIgnoreCase("Mir-Sat-1") && bf.mayContainPFH()) {
                System.err.println("Has PFH");
                int[] newData = new int[bf.data.length + 1];
                newData[0] = 170;
                int i2 = 0;
                while (i2 < bf.data.length) {
                    newData[i2 + 1] = bf.data[i2];
                    ++i2;
                }
                try {
                    PacSatFileHeader newpfh = new PacSatFileHeader(bf.fileId, 0L, 0L, newData);
                    if (newpfh == null) break block13;
                    List<PacSatFileHeader> list = this.files;
                    synchronized (list) {
                        if (((SortedPfhArrayList)this.files).addOrReplace(newpfh)) {
                            this.needsSaving = true;
                        }
                    }
                }
                catch (MalformedPfhException malformedPfhException) {
                    // empty catch block
                }
            }
        }
        if ((psf = new PacSatFile(this.spacecraftSettings, this.dirFolder, bf.fileId)).addFrame(this.spacecraftSettings, bf)) {
            if (pfh.state != 3) {
                pfh.setState(2);
                pfh.userDownLoadPriority = 0;
            }
            this.postFileProcessing(pfh, psf);
        } else if (pfh != null) {
            pfh.setState(1);
        }
        return true;
    }

    public void postFileProcessing(PacSatFileHeader pfh, PacSatFile psf) throws IOException, MalformedPfhException, LayoutLoadException, NumberFormatException, DataLoadException {
        if (pfh.getType() == 3) {
            File file = psf.extractSystemFile(this.spacecraftSettings.directory.dirFolder);
            if (file != null) {
                LogFileWE we = new LogFileWE(this.spacecraftSettings, file.getPath());
                if (we.records != null) {
                    for (DataRecord d : we.records) {
                        this.spacecraftSettings.db.add(d);
                    }
                }
            }
        } else if (pfh.getType() == 203 || pfh.getType() == 240) {
            int compressedBy = 0;
            PacSatField compressionType = pfh.getFieldById(25);
            if (compressionType != null) {
                compressedBy = (int)pfh.getFieldById(25).getLongValue();
            }
            if (compressedBy == 2) {
                File destDir = psf.decompress(this.spacecraftSettings.directory.dirFolder);
                if (destDir != null) {
                    File[] files = destDir.listFiles();
                    boolean i2 = false;
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        LogFileTlm we = new LogFileTlm(pfh.getFieldString(20).toUpperCase(), this.spacecraftSettings, f.getPath());
                        if (we.records != null) {
                            for (DataRecord d : we.records) {
                                this.spacecraftSettings.db.add(d);
                            }
                        }
                        ++n2;
                    }
                }
            } else {
                File file = psf.extractSystemFileByUserFilename(this.spacecraftSettings.directory.dirFolder);
                if (file != null) {
                    LogFileTlm we = new LogFileTlm(pfh.getFieldString(20).toUpperCase(), this.spacecraftSettings, file.getPath());
                    if (we.records != null) {
                        for (DataRecord d : we.records) {
                            this.spacecraftSettings.db.add(d);
                        }
                    }
                }
            }
        } else if (pfh.getType() == 211) {
            System.err.println("Extract");
            File file = psf.extractSystemFile(this.spacecraftSettings.directory.dirFolder);
        }
    }

    public void setPriority(long id, int pri) {
        PacSatFileHeader pfh = this.getPfhById(id);
        if (pfh != null) {
            pfh.userDownLoadPriority = pri;
            if (pri < 0) {
                pfh.state = 4;
            }
        }
    }

    public void setShowFiles(boolean show) {
        this.spacecraftSettings.set("show_user_files", show);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getTableData() {
        boolean changedPriorities = false;
        String[][] filtered = new String[this.files.size()][15];
        String[][] data = null;
        int i2 = 0;
        List<PacSatFileHeader> list = this.files;
        synchronized (list) {
            for (PacSatFileHeader pfh : this.files) {
                DirSelectionEquation equ;
                if (pfh.userDownLoadPriority != 9 && pfh.state != 2 && pfh.state != 3 && (equ = this.hasMatchingEquation(pfh)) != null) {
                    pfh.userDownLoadPriority = equ.priority;
                    changedPriorities = true;
                }
                PacSatFile psf = new PacSatFile(this.spacecraftSettings, this.dirFolder, pfh.getFileId());
                String[] header = pfh.getTableFields();
                String toCall = header[3];
                boolean added = false;
                if (toCall != null) {
                    if (this.spacecraftSettings.getBoolean("show_user_files")) {
                        if (!toCall.equalsIgnoreCase("")) {
                            filtered[i2++] = header;
                            added = true;
                        }
                    } else {
                        filtered[i2++] = header;
                        added = true;
                    }
                }
                if (!added) continue;
                long fileSize = pfh.getFieldById(4).getLongValue();
                long holesLength = psf.getHolesSize(this.spacecraftSettings);
                float percent = 1.0f;
                if (holesLength > 0L && holesLength <= fileSize) {
                    percent = (float)holesLength / (float)fileSize;
                } else if (pfh.state == 0) {
                    percent = 0.0f;
                }
                String p = String.format("%2.0f", Float.valueOf(percent * 100.0f));
                int h = psf.getNumOfHoles();
                filtered[i2 - 1][9] = " " + h + "/" + p + "%";
            }
        }
        data = new String[i2][];
        int j1 = 0;
        while (j1 < i2) {
            data[i2 - j1 - 1] = filtered[j1];
            ++j1;
        }
        if (changedPriorities) {
            this.needsSaving = true;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileOutputStream fileOut = null;
        ObjectOutputStream objectOut = null;
        try {
            List<PacSatFileHeader> list = this.files;
            synchronized (list) {
                fileOut = new FileOutputStream(String.valueOf(this.dirFolder) + File.separator + DIR_FILE_NAME);
                objectOut = new ObjectOutputStream(fileOut);
                objectOut.writeObject(this.files);
                this.needsSaving = false;
            }
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.close();
                }
                catch (Exception exception) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void saveIfNeeded() {
        if (this.needsSaving) {
            try {
                this.save();
                Log.println("Directory was saved in the background");
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void load() throws IOException, ClassNotFoundException {
        var1_1 = this.files;
        synchronized (var1_1) {
            block30: {
                this.files = new SortedPfhArrayList();
                objectIn = null;
                streamIn = null;
                try {
                    try {
                        streamIn = new FileInputStream(String.valueOf(this.dirFolder) + File.separator + "directory.db");
                        objectIn = new ObjectInputStream(streamIn);
                        tmpFiles = (SortedPfhArrayList)objectIn.readObject();
                        for (PacSatFileHeader pfh : tmpFiles) {
                            if (this.files.add(pfh)) continue;
                            Log.println("ERROR: Duplicate PFH.  Ignored on load: " + pfh);
                        }
                        break block30;
                    }
                    catch (ClassCastException e1) {
                        Log.println("ClassFormatError:  Trying to convert old deirectory format");
                        if (objectIn != null) {
                            try {
                                objectIn.close();
                            }
                            catch (Exception pfh) {
                                // empty catch block
                            }
                        }
                        if (streamIn != null) {
                            try {
                                streamIn.close();
                            }
                            catch (Exception pfh) {
                                // empty catch block
                            }
                        }
                        streamIn = new FileInputStream(String.valueOf(this.dirFolder) + File.separator + "directory.db");
                        objectIn = new ObjectInputStream(streamIn);
                        tmpFiles = (SortedArrayList)objectIn.readObject();
                        ** for (pfh : tmpFiles)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (this.files.add(pfh)) continue;
                        Log.println("ERROR: Duplicate PFH.  Ignored on load: " + pfh);
                        continue;
lbl38:
                        // 1 sources

                    }
                }
                finally {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (Exception var9_17) {}
                    }
                    if (streamIn != null) {
                        try {
                            streamIn.close();
                        }
                        catch (Exception var9_18) {}
                    }
                }
            }
        }
    }

    public static boolean makeDir(String dir) {
        File aFile = new File(dir);
        if (!aFile.isDirectory()) {
            Log.println("Making new database: " + dir);
            aFile.mkdir();
            if (!aFile.isDirectory()) {
                Log.errorDialog("ERROR", "ERROR can't create the directory.  Check the path is writable:\n " + aFile.getAbsolutePath() + "\n");
                return false;
            }
            return true;
        }
        return false;
    }

    public static void remove(String f) throws IOException {
        block3: {
            try {
                File file = new File(f);
                if (!file.exists()) break block3;
                if (file.delete()) {
                    Log.println(String.valueOf(file.getName()) + " is deleted!");
                    break block3;
                }
                Log.println("Delete operation failed for: " + file.getName());
                throw new IOException("Could not delete file " + file.getName() + " Check the file system and remove it manually.");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MainWindow.frame, ex.toString(), "Error Deleting File", 0);
            }
        }
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public void archiveDir(String archiveDir) {
        SortedPfhArrayList dirFiles = new SortedPfhArrayList();
        String archiveDirFolder = String.valueOf(Config.get("archive_dir")) + File.separator + this.satname;
        File dir = new File(archiveDirFolder);
        if (!dir.exists() && !Directory.makeDir(archiveDirFolder)) {
            return;
        }
        boolean error = false;
        boolean atLeastOneArchived = false;
        int keepNumber = this.spacecraftSettings.getInt("number_dir_table_entries");
        try {
            int i2 = this.files.size() - keepNumber - 1;
            while (i2 >= 0) {
                File f3;
                PacSatFileHeader pfh = this.files.get(i2);
                String id = pfh.getFileName();
                File f = new File(String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + id + ".act");
                if (f.exists()) {
                    File f2 = new File(String.valueOf(archiveDirFolder) + File.separator + id + ".act");
                    Directory.copyFile(f, f2);
                    if (f2.exists()) {
                        Directory.remove(f.getAbsolutePath());
                    }
                }
                if ((f3 = new File(String.valueOf(this.spacecraftSettings.directory.dirFolder) + File.separator + id + ".act.hol")).exists()) {
                    File f4 = new File(String.valueOf(archiveDirFolder) + File.separator + id + ".act.hol");
                    Directory.copyFile(f3, f4);
                    if (f4.exists()) {
                        Directory.remove(f3.getAbsolutePath());
                    }
                }
                if (!dirFiles.add(pfh)) {
                    JOptionPane.showMessageDialog(MainWindow.frame, "File: " + pfh.getFileName(), "Error Copying PacSatFileHeader to archive", 0);
                    error = true;
                    break;
                }
                atLeastOneArchived = true;
                --i2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            error = true;
        }
        if (atLeastOneArchived && !error) {
            FileOutputStream fileOut = null;
            ObjectOutputStream objectOut = null;
            try {
                try {
                    fileOut = new FileOutputStream(String.valueOf(Config.get("archive_dir")) + File.separator + this.satname + File.separator + DIR_FILE_NAME);
                    objectOut = new ObjectOutputStream(fileOut);
                    objectOut.writeObject(dirFiles);
                    Log.println("Saved archive to disk");
                    int i3 = this.files.size() - keepNumber - 1;
                    while (i3 >= 0) {
                        this.files.remove(i3);
                        --i3;
                    }
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(MainWindow.frame, "File: " + Config.get("archive_dir") + File.separator + this.satname + File.separator + DIR_FILE_NAME, "Error writing to archive.  File not found.", 0);
                    e.printStackTrace(Log.getWriter());
                    if (objectOut != null) {
                        try {
                            objectOut.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fileOut != null) {
                        try {
                            fileOut.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException e) {
                    block41: {
                        JOptionPane.showMessageDialog(MainWindow.frame, "File: " + Config.get("archive_dir") + File.separator + this.satname + File.separator + DIR_FILE_NAME, "IO error writing to archive.", 0);
                        e.printStackTrace(Log.getWriter());
                        if (objectOut == null) break block41;
                        try {
                            objectOut.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fileOut != null) {
                        try {
                            fileOut.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            finally {
                if (objectOut != null) {
                    try {
                        objectOut.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

