/*
 * Decompiled with CFR 0.152.
 */
package fileStore;

import ax25.KissFrame;
import common.Log;
import fileStore.PacSatFileHeader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;

public class XcamImg {
    public static final int TYPE_THUMB = 4;
    public static final int TYPE_FULL = 0;
    public static final int PACKET_HEADER_LEN = 9;
    public static final int PACKET_DATA_LEN = 249;
    public static final int PACKET_CRC_LEN = 2;
    public static final int PACKET_LEN = 260;
    byte[] bytes;
    byte[] processedBytes;
    int type = 4;
    BufferedImage image;
    int imageType = 10;
    int width = 120;
    int height = 100;

    public XcamImg(byte[] bytes) {
        this.bytes = bytes;
        this.processFile();
        try {
            if (this.type == 4) {
                this.makeGrayScaleImage();
            } else {
                this.make2x2BinnedImage();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public XcamImg(String filename) throws IOException {
        this.load(filename);
        this.processFile();
        try {
            if (this.type == 4) {
                this.makeGrayScaleImage();
            } else {
                this.make2x2BinnedImage();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void processFile() {
        if (this.bytes.length % 260 != 0) {
            Log.println("Error: Hmm, wrong length for image packet?");
        }
        int processedLength = this.bytes.length / 260;
        this.processedBytes = new byte[processedLength * 249];
        int i2 = 0;
        int frameNum = 0;
        while (i2 < this.bytes.length) {
            byte[] line = new byte[258];
            int h = 0;
            h = 0;
            while (h < 9) {
                line[h] = this.bytes[h];
                ++h;
            }
            h = 9;
            int[] by = new int[]{this.bytes[i2], this.bytes[i2 + 1], this.bytes[i2 + 2], this.bytes[i2 + 3]};
            long fileInfo = KissFrame.getLongFromBytes(by);
            int[] by2 = new int[]{this.bytes[i2 += 4], this.bytes[i2 + 1], this.bytes[i2 + 2], this.bytes[i2 + 3]};
            int num = (int)KissFrame.getLongFromBytes(by2);
            this.type = this.bytes[i2 += 4];
            if (this.type == 4 && processedLength != 49) {
                throw new IllegalArgumentException("Wrong length for thumbnail type file.  Packet number: " + processedLength);
            }
            ++i2;
            int j = 0;
            while (j < 249) {
                line[h + j] = this.bytes[i2];
                this.processedBytes[frameNum * 249 + j] = this.bytes[i2++];
                ++j;
            }
            int[] by3 = new int[]{this.bytes[i2], this.bytes[i2 + 1]};
            short crc = (short)KissFrame.getIntFromBytes(by3);
            short actCrc = PacSatFileHeader.checksum(line);
            i2 += 2;
            ++frameNum;
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public BufferedImage getFlippedImage() {
        return XcamImg.createFlipped(this.image, this.imageType);
    }

    public BufferedImage getRotatedImage() {
        return XcamImg.createRotated(this.image, this.imageType);
    }

    public void makeGrayScaleImage() {
        this.width = 120;
        this.height = 100;
        this.imageType = 10;
        if (this.type == 0) {
            this.width = 1280;
            this.height = 1024;
        }
        this.image = new BufferedImage(this.width, this.height, this.imageType);
        byte[] array = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        int i2 = 0;
        while (i2 < array.length) {
            array[i2] = this.processedBytes[i2];
            ++i2;
        }
    }

    public void makeImage() {
        this.width = 1280;
        this.height = 1024;
        this.imageType = 1;
        this.image = new BufferedImage(this.width, this.height, this.imageType);
        int[] oriImageAsIntArray = new int[this.image.getWidth() * this.image.getHeight()];
        this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), oriImageAsIntArray, 0, this.image.getWidth());
        int i2 = 0;
        while (i2 < oriImageAsIntArray.length) {
            oriImageAsIntArray[i2] = this.processedBytes[i2] & 0xFF;
            ++i2;
        }
        this.image.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), oriImageAsIntArray, 0, this.image.getWidth());
    }

    public void make2x2BinnedImage() {
        int processedWidth = 1280;
        this.width = 640;
        this.height = 512;
        this.imageType = 1;
        this.image = new BufferedImage(this.width, this.height, this.imageType);
        int[] imageAsIntArray = new int[this.image.getWidth() * this.image.getHeight()];
        this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), imageAsIntArray, 0, this.image.getWidth());
        int h = 0;
        while (h < this.height) {
            int w = 0;
            while (w < this.width) {
                int b = this.processedBytes[2 * h * processedWidth + 2 * w] & 0xFF;
                int gb = this.processedBytes[2 * h * processedWidth + 2 * w + 1] & 0xFF;
                int gr = this.processedBytes[(2 * h + 1) * processedWidth + 2 * w] & 0xFF;
                int g = (gb + gr) / 2;
                int r = this.processedBytes[(2 * h + 1) * processedWidth + 2 * w + 1] & 0xFF;
                imageAsIntArray[h * this.width + w] = (r << 16) + (g << 8) + b;
                ++w;
            }
            ++h;
        }
        this.image.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), imageAsIntArray, 0, this.image.getWidth());
    }

    private static BufferedImage createRotated(BufferedImage image, int imageType) {
        AffineTransform at = AffineTransform.getRotateInstance(Math.PI, (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        return XcamImg.createTransformed(image, at, imageType);
    }

    private static BufferedImage createFlipped(BufferedImage image, int imageType) {
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -image.getHeight()));
        return XcamImg.createTransformed(image, at, imageType);
    }

    private static BufferedImage createTransformed(BufferedImage image, AffineTransform at, int imageType) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), imageType);
        Graphics2D g = newImage.createGraphics();
        g.transform(at);
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return newImage;
    }

    public void export(String filename) throws IOException {
        FileOutputStream saveFile = null;
        try {
            saveFile = new FileOutputStream(filename);
            saveFile.write(this.processedBytes);
        }
        finally {
            try {
                if (saveFile != null) {
                    saveFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void saveAsPng(String filename) throws IOException {
        File outputfile = new File(filename);
        ImageIO.write((RenderedImage)this.image, "png", outputfile);
    }

    private void load(String filename) throws IOException {
        RandomAccessFile fileOnDisk = null;
        try {
            fileOnDisk = new RandomAccessFile(filename, "r");
            this.bytes = new byte[(int)fileOnDisk.length()];
            fileOnDisk.read(this.bytes);
        }
        finally {
            try {
                if (fileOnDisk != null) {
                    fileOnDisk.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

