/*
 * Decompiled with CFR 0.152.
 */
package fileStore.telem;

import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatField;
import fileStore.PacSatFile;
import fileStore.telem.AlogSession;
import fileStore.telem.RecordAL1;
import fileStore.telem.RecordAL2;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class LogFileAL
extends PacSatFile {
    public static final int ALOG_FTL0_STARTUP = 1;
    public static final int ALOG_FTL0_SHUTDOWN = 2;
    public static final int ALOG_START_SESSION = 3;
    public static final int ALOG_CLOSE_SESSION = 4;
    public static final int ALOG_DISCONNECT = 5;
    public static final int ALOG_USER_REFUSED = 6;
    public static final int ALOG_BCAST_START = 7;
    public static final int ALOG_BCAST_STOP = 8;
    public static final int ALOG_DISKSPACE = 9;
    public static final int ALOG_FILE_DELETE = 10;
    public static final int ALOG_FILE_DOWNLOAD = 11;
    public static final int ALOG_FILE_UPLOAD = 12;
    public static final int ALOG_BBS_SHUT = 13;
    public static final int ALOG_BBS_OPEN = 14;
    public static final int ALOG_DIR = 15;
    public static final int ALOG_SELECT = 16;
    public static final int ALOG_FILE_REMOVED = 17;
    public static final int ALOG_FILE_NOT_REMOVED = 18;
    public static final int ALOG_END_DOWNLOAD = 19;
    public static final int ALOG_END_UPLOAD = 20;
    public static final int ALOG_END_DIR = 21;
    public static final int ALOG_SELECT_DONE = 22;
    public static final int ALOG_ERROR = 23;
    public static final int ALOG_EVENT = 24;
    public static final int ALOG_EVENT_WITH_VARS = 25;
    public static final int ALOG_EVENT_WITH_CALL = 26;
    public static final int ALOG_EVENT_WITH_CALL_AND_VARS = 27;
    public static final int MAX_SESSION = 20;
    int sidx = 0;
    AlogSession[] session;
    public String content;
    String[] ftl0_errors = new String[]{"", "ERROR:PG command bug", "ERROR:cannot continue", "ERROR:PACSAT err", "ERROR:No such file", "ERROR:Selection empty", "ERROR:Mandatory PFH err", "ERROR:PHF err", "ERROR:Bad selection", "ERROR:File locked", "ERROR:No such destination", "ERROR:File partial.", "ERROR:File complete.", "ERROR:PACSAT file system full", "ERROR:PFH err", "ERROR:PFH checksum failure", "ERROR:body checksum failure"};
    public static final int FTC_FRMR_REM = 1;
    public static final int FTC_FRMR_LOCAL = 2;
    public static final int FTC_DISC_LOCAL = 3;
    public static final int FTC_DISC_REM = 4;
    public static final int FTC_TIMEOUT = 5;
    public static final int FTC_RECONNECT = 6;
    public static final int FTC_QUIT = 7;
    String[] close_reasons = new String[]{"Undefined error", "user FRMR", "server FRMR", "server disconnect", "user disconnect", "FTL0 timeout", "reconnection", "quit"};
    public static final long DC_TIMEOUT = 1L;
    public static final long DC_IN_ULOK = 2L;
    public static final long DC_IN_DLOK = 3L;
    public static final long DC_IN_DLEND = 4L;
    public static final long DC_IN_ULRX = 5L;
    public static final long DC_UNKNOWN_PKT = 6L;
    public static final long DC_PKT_TOO_BIG = 7L;
    String[] disc_reasons = new String[]{"Undefined error", "Inactivity timeout", "Unexpected input (uplink command)", "Unexpected input (downlink command)", "Unexpected input (downlink end)", "Unexpected input (uplink data)", "FTL0 packet type unknown.", "FTL0 command packet too long."};
    String[] log_errors = new String[]{"Undefined error", "Removing PID File", "Could not store WOD", "Sending Packet", "Setting Time", "Max Radio Retries", "Max TNC Retries", "SSTV Failure", "FS Failure", "Direwolf Failure", "PTT Failure", "TNC Failure", "Crew Interface Fail"};
    public static final int ALOG_FTYPE = 12;
    int[] data;
    RecordAL1 alog_1f;
    RecordAL2 alog_2f;

    public LogFileAL(SpacecraftSettings spacecraftSettings, String dir, long id) throws LayoutLoadException, IOException {
        super(spacecraftSettings, dir, id);
        this.data = this.getData();
        this.session = new AlogSession[20];
        this.content = this.parseFile();
    }

    public LogFileAL(SpacecraftSettings spacecraftSettings, String fileName) throws MalformedPfhException, IOException, LayoutLoadException {
        super(spacecraftSettings, fileName);
        this.data = this.getData();
        this.session = new AlogSession[20];
        this.content = this.parseFile();
    }

    public LogFileAL(SpacecraftSettings spacecraftSettings, int[] bytes) throws MalformedPfhException, IOException, LayoutLoadException {
        super(spacecraftSettings, bytes);
        this.data = bytes;
        this.session = new AlogSession[20];
        this.content = this.parseFile();
    }

    private String parseFile() throws LayoutLoadException, IOException {
        String s = "";
        s = String.valueOf(s) + "Activity Log. " + " Length: " + this.data.length + " bytes\n\n";
        s = String.valueOf(s) + "Time\t\tActivity           Call      \tRx          Data\n";
        int i2 = 0;
        int len = 999;
        while (i2 < this.data.length && len > 0) {
            long timeStamp = 0L;
            int event = DataRecord.getByteValue(i2, this.data);
            len = DataRecord.getByteValue(i2 + 1, this.data);
            if (len == 0 || len > 40) {
                s = String.valueOf(s) + "File is damaged, can not be parsed";
                break;
            }
            int[] dataSet1 = Arrays.copyOfRange(this.data, i2, 33 + i2);
            int[] dataSet2 = Arrays.copyOfRange(this.data, i2, 40 + i2);
            this.alog_1f = new RecordAL1(0, 0, timeStamp, 0, dataSet1, true);
            this.alog_2f = new RecordAL2(0, 0, timeStamp, 0, dataSet2, true);
            i2 += len;
            switch (event) {
                case 1: {
                    s = String.valueOf(s) + this.alog_1f;
                    break;
                }
                case 2: {
                    s = String.valueOf(s) + this.alog_1f;
                    break;
                }
                case 13: {
                    this.pcalla();
                    break;
                }
                case 14: {
                    this.pcalla();
                    break;
                }
                case 7: {
                    s = String.valueOf(s) + this.pcalla();
                    String err_str = "";
                    int var3 = this.alog_2f.getRawValue("var3");
                    if (var3 != 0) {
                        err_str = this.search_for_string(this.ftl0_errors, var3);
                    }
                    long id = this.alog_2f.getRawValue("var1");
                    long dur = this.alog_2f.getRawValue("var2");
                    long pkt_len = this.alog_2f.getRawValue("var4");
                    s = String.valueOf(s) + "        File:" + Long.toHexString(id) + " " + dur + "s broadcast, " + "with Pkt Len:" + pkt_len + " " + err_str;
                    break;
                }
                case 8: {
                    s = String.valueOf(s) + this.pcalla();
                    String err_str = "";
                    int var3 = this.alog_2f.getRawValue("var3");
                    if (var3 != 0) {
                        err_str = this.search_for_string(this.ftl0_errors, var3);
                    }
                    long id = this.alog_2f.getRawValue("var1");
                    s = String.valueOf(s) + "    File:" + Long.toHexString(id) + " " + err_str;
                    break;
                }
                case 9: {
                    s = String.valueOf(s) + this.alog_1f;
                    int var1 = this.alog_1f.getRawValue("var1");
                    int var2 = this.alog_1f.getRawValue("var2");
                    s = String.valueOf(s) + "                     " + var1 * 1008 + " bytes \\ " + var2 + " dirs";
                    break;
                }
                case 10: {
                    this.pcalla();
                    String err_str = "";
                    int var3 = this.alog_1f.getRawValue("var3");
                    if (var3 != 0) {
                        err_str = this.search_for_string(this.ftl0_errors, var3);
                    }
                    long id = this.alog_1f.getRawValue("var1");
                    s = String.valueOf(s) + "    File:" + Long.toHexString(id) + " " + err_str;
                    break;
                }
                case 6: {
                    s = String.valueOf(s) + this.alog_1f + " BBS was full";
                    break;
                }
                case 3: {
                    s = String.valueOf(s) + this.pcallsession();
                    int serial_no = this.alog_1f.getRawValue("serial_no");
                    s = String.valueOf(s) + " SESSION: " + serial_no;
                    break;
                }
                case 4: {
                    s = String.valueOf(s) + this.pcall();
                    int serial_no = this.alog_1f.getRawValue("serial_no");
                    s = String.valueOf(s) + " SESSION: " + serial_no;
                    s = String.valueOf(s) + this.search_for_string(this.close_reasons, this.alog_1f.getRawValue("var1"));
                    int bytes = this.alog_1f.getRawValue("var2");
                    if (bytes > 0) {
                        s = String.valueOf(s) + " --Incomplete D/L @ " + bytes + " bytes";
                    }
                    if ((bytes = this.alog_1f.getRawValue("var3")) <= 0) break;
                    s = String.valueOf(s) + " --Incomplete U/L @ " + bytes + " bytes";
                    break;
                }
                case 5: {
                    s = String.valueOf(s) + this.pcall();
                    s = String.valueOf(s) + " " + this.search_for_string(this.disc_reasons, this.alog_1f.getRawValue("var1"));
                    break;
                }
                case 11: {
                    s = String.valueOf(s) + this.pcall();
                    int var3 = this.alog_1f.getRawValue("var3");
                    String err_str = "";
                    if (var3 != 0) {
                        err_str = this.search_for_string(this.ftl0_errors, var3);
                    }
                    long id = this.alog_1f.getRawValue("var1");
                    s = String.valueOf(s) + "        File:" + Long.toHexString(id) + " " + err_str + " ";
                    if (this.alog_1f.getRawValue("var4") <= 0) break;
                    s = String.valueOf(s) + "(selected)";
                    break;
                }
                case 19: {
                    s = String.valueOf(s) + this.pcall();
                    s = String.valueOf(s) + "        " + this.alog_1f.getRawValue("var1") + " bytes";
                    int var2 = this.alog_1f.getRawValue("var2");
                    if (var2 == 12) {
                        s = String.valueOf(s) + "Ack'd";
                        break;
                    }
                    s = String.valueOf(s) + "Nak'd";
                    break;
                }
                case 12: {
                    s = String.valueOf(s) + this.pcall();
                    int var3 = this.alog_1f.getRawValue("var3");
                    String err_str = "";
                    if (var3 != 0) {
                        err_str = this.search_for_string(this.ftl0_errors, var3);
                    }
                    long id = this.alog_1f.getRawValue("var1");
                    s = String.valueOf(s) + "        File:" + Long.toHexString(id) + " Offset:" + this.alog_1f.getRawValue("var2") + " Length:" + this.alog_1f.getRawValue("var4") + " " + err_str;
                    break;
                }
                case 20: {
                    s = String.valueOf(s) + this.pcall();
                    s = String.valueOf(s) + "        " + this.alog_1f.getRawValue("var3") + " bytes " + (this.alog_1f.getRawValue("tstamp") - this.alog_1f.getRawValue("var3")) + " seconds cksum";
                    int var2 = this.alog_1f.getRawValue("var2");
                    if (var2 <= 0) break;
                    s = String.valueOf(s) + "Nak'd";
                    break;
                }
                case 15: {
                    long id;
                    s = String.valueOf(s) + this.pcall();
                    int var3 = this.alog_1f.getRawValue("var3");
                    String err_str = "";
                    if (var3 != 0) {
                        err_str = this.search_for_string(this.ftl0_errors, var3);
                    }
                    if ((id = (long)this.alog_1f.getRawValue("var1")) != -1L && id != 0L) {
                        s = String.valueOf(s) + "        File:" + Long.toHexString(id) + " " + err_str;
                        break;
                    }
                    s = String.valueOf(s) + "        from selection.";
                    break;
                }
                case 21: {
                    s = String.valueOf(s) + this.pcall();
                    s = String.valueOf(s) + "        " + this.alog_1f.getRawValue("var1") + " bytes";
                    break;
                }
                case 17: {
                    s = String.valueOf(s) + this.alog_1f;
                    long id = this.alog_1f.getRawValue("var1");
                    long dt = this.alog_1f.getRawValue("var4");
                    Date date = new Date(dt * 1000L);
                    s = String.valueOf(s) + "        File:" + Long.toHexString(id) + " (exp: (" + Long.toHexString(dt) + ") " + PacSatField.getDateStringSecs(date);
                    break;
                }
                case 16: {
                    s = String.valueOf(s) + this.pcall();
                    break;
                }
                case 22: {
                    s = String.valueOf(s) + this.pcall();
                    s = String.valueOf(s) + " Len of select Equ:" + this.alog_1f.getRawValue("var1") + " oldest file:" + this.alog_1f.getRawValue("var2") + " newest file:" + this.alog_1f.getRawValue("var3") + " num selected:" + this.alog_1f.getRawValue("var4");
                    break;
                }
                case 23: {
                    s = String.valueOf(s) + this.alog_1f.getTimeStamp() + "\t" + this.alog_1f.getEventString();
                    s = String.valueOf(s) + " " + this.search_for_string(this.log_errors, this.alog_1f.getRawValue("serial_no"));
                    break;
                }
                case 24: {
                    s = String.valueOf(s) + this.alog_1f.getTimeStamp() + "\t" + this.alog_1f.getEventString();
                    s = String.valueOf(s) + " " + this.alog_1f.getRawValue("serial_no");
                    break;
                }
                case 25: {
                    s = String.valueOf(s) + this.alog_1f;
                    int var1 = this.alog_1f.getRawValue("var1");
                    int var2 = this.alog_1f.getRawValue("var2");
                    int var3 = this.alog_1f.getRawValue("var3");
                    long var4 = this.alog_1f.getRawValue("var4");
                    long var5 = this.alog_1f.getRawValue("var5");
                    long var6 = this.alog_1f.getRawValue("var6");
                    s = String.valueOf(s) + " " + var1 + ", " + var2 + ", " + var3 + ", " + var4 + ", " + var5 + ", " + var6;
                }
                case 26: {
                    s = String.valueOf(s) + this.pcalla();
                    break;
                }
                case 27: {
                    s = String.valueOf(s) + this.pcalla();
                    int var1 = this.alog_2f.getRawValue("var1");
                    int var2 = this.alog_2f.getRawValue("var2");
                    int var3 = this.alog_2f.getRawValue("var3");
                    long var4 = this.alog_2f.getRawValue("var4");
                    long var5 = this.alog_2f.getRawValue("var5");
                    long var6 = this.alog_2f.getRawValue("var6");
                    s = String.valueOf(s) + " " + var1 + ", " + var2 + ", " + var3 + ", " + var4 + ", " + var5 + ", " + var6;
                    break;
                }
                default: {
                    s = String.valueOf(s) + this.alog_1f;
                }
            }
            s = String.valueOf(s) + "\n";
        }
        return s;
    }

    private String pcallsession() {
        String s = "";
        String c = this.alog_2f.getCallString();
        String ss = this.alog_2f.getSsid();
        int n = this.alog_2f.getRawValue("serial_no");
        this.session[this.sidx] = new AlogSession(c, ss, n);
        this.sidx = (this.sidx + 1) % 20;
        s = String.valueOf(s) + this.pcalla();
        return s;
    }

    private String pcalla() {
        String s = "";
        s = String.valueOf(s) + this.alog_1f.getTimeStamp() + "\t" + this.alog_1f.getEventString() + " ";
        s = String.valueOf(s) + this.alog_2f.getCallString() + "-" + this.alog_2f.getSsid() + "\t" + this.alog_2f.getRxChan();
        return s;
    }

    private String pcall() {
        String s = "";
        int serial = this.alog_1f.getRawValue("serial_no");
        int i2 = 0;
        while (i2 < 20) {
            if (this.session[i2].session == serial) break;
            ++i2;
        }
        s = String.valueOf(s) + this.alog_1f;
        s = i2 < 20 ? String.valueOf(s) + this.session[i2].call + "-" + this.session[i2].ssid : String.valueOf(s) + "******-**    ";
        return s;
    }

    private String search_for_string(String[] strings, int var3) {
        String err_str = "";
        err_str = var3 > 0 && var3 < strings.length ? " " + strings[var3] : " " + var3;
        if (err_str == null) {
            err_str = "";
        }
        return err_str;
    }

    private RecordAL2 getAlogStruct(int[] data, int offset) {
        int len = DataRecord.getIntValue(offset, data);
        return null;
    }

    public String toString() {
        return this.content;
    }
}

