/*
 * Decompiled with CFR 0.152.
 */
package fileStore.telem;

import com.g0kla.telem.data.BitArrayLayout;
import com.g0kla.telem.data.BitDataRecord;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.Log;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import fileStore.PacSatField;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class LogFileTlm {
    String fileName;
    String layoutName;
    public ArrayList<DataRecord> records;
    int[] data;
    SpacecraftSettings spacecraftSettings;

    public LogFileTlm(String layoutName, SpacecraftSettings spacecraftSettings, String fileName) throws MalformedPfhException, IOException, LayoutLoadException {
        this.spacecraftSettings = spacecraftSettings;
        this.fileName = fileName;
        this.layoutName = layoutName;
        this.data = this.loadData();
        this.parseFile();
    }

    public LogFileTlm(String layoutName, SpacecraftSettings spacecraftSettings, int[] bytes) throws MalformedPfhException, IOException, LayoutLoadException {
        this.spacecraftSettings = spacecraftSettings;
        this.layoutName = layoutName;
        this.data = bytes;
        this.parseFile();
    }

    int[] loadData() {
        File f = new File(this.fileName);
        int[] b = new int[(int)f.length()];
        RandomAccessFile fileOnDisk = null;
        int p = 0;
        try {
            try {
                fileOnDisk = new RandomAccessFile(this.fileName, "r");
                boolean readingBytes = true;
                while (readingBytes) {
                    try {
                        b[p++] = fileOnDisk.readUnsignedByte();
                    }
                    catch (EOFException e) {
                        readingBytes = false;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Log.errorDialog("ERROR", "File: " + this.fileName + "\nseems to have too many data bytes or the data is corrupt");
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (fileOnDisk != null) {
                        fileOnDisk.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (fileOnDisk != null) {
                    fileOnDisk.close();
                }
            }
            catch (IOException iOException) {}
        }
        return b;
    }

    private void parseFile() throws LayoutLoadException, IOException {
        int i2 = 0;
        int r = 0;
        BitArrayLayout lay = (BitArrayLayout)this.spacecraftSettings.spacecraft.getLayoutByName(this.layoutName);
        if (lay == null) {
            return;
        }
        int len = lay.getMaxNumberOfBytes();
        this.records = new ArrayList();
        int type = 2;
        try {
            while (i2 < this.data.length) {
                int[] dataSet = Arrays.copyOfRange(this.data, i2, len + i2);
                long timestamp = DataRecord.getLongValue(i2, this.data);
                int reset = 0;
                if (this.spacecraftSettings.spacecraft.useResetUptime) {
                    reset = DataRecord.getIntValue(i2 + 4, this.data);
                }
                BitDataRecord we = new BitDataRecord(lay, this.spacecraftSettings.spacecraft.satId, reset, timestamp, type, dataSet, true);
                this.records.add(we);
                i2 += len;
                ++r;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.errorDialog("ERROR", "File: " + this.fileName + "\nseems to have too many data bytes or the data is corrupt");
        }
    }

    public String toString() {
        String s = "";
        boolean i2 = false;
        for (DataRecord d : this.records) {
            s = String.valueOf(s) + PacSatField.getDateStringSecs(new Date(d.uptime * 1000L)) + ", ";
            s = String.valueOf(s) + d.toString() + "\n";
        }
        return s;
    }
}

