/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.DirSelectionCriteria;
import fileStore.DirSelectionEquation;
import gui.SpacecraftFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DirEquationFrame
extends JDialog
implements ActionListener,
ItemListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    public static final String DIRSELECTION_WINDOW_X = "DIRSELECTION_window_x";
    public static final String DIRSELECTION_WINDOW_Y = "DIRSELECTION_window_y";
    public static final String DIRSELECTION_WINDOW_WIDTH = "DIRSELECTION_window_width";
    public static final String DIRSELECTION_WINDOW_HEIGHT = "DIRSELECTION_window_height";
    private final JPanel contentPanel = new JPanel();
    JButton btnCancel;
    JButton btnSave;
    JButton btnAnd;
    public static final int MAX_ROWS = 4;
    private int numOfRows = 3;
    JPanel selectionRows;
    JPanel[] row = new JPanel[this.numOfRows];
    private JComboBox[] cbField = new JComboBox[this.numOfRows];
    private JComboBox[] cbOp = new JComboBox[this.numOfRows];
    private JTextField[] txtValue = new JTextField[this.numOfRows];
    String[] priorities = new String[]{"1", "2", "3", "4", "N"};
    private JComboBox cbPriority = new JComboBox<String>(this.priorities);
    private JComboBox cbDateRestriction = new JComboBox<String>(DirSelectionEquation.DATES_RESTRICTIONS);
    int[] opType = new int[this.numOfRows];
    SpacecraftFrame caller;
    DirSelectionEquation equation;
    SpacecraftSettings spacecraftSettings;

    public DirEquationFrame(SpacecraftSettings spacecraftSettings, JFrame owner, boolean modal, SpacecraftFrame caller) {
        super((Frame)owner, modal);
        this.spacecraftSettings = spacecraftSettings;
        this.caller = caller;
        this.makeDialog();
        this.addFields(null);
    }

    public DirEquationFrame(SpacecraftSettings spacecraftSettings, JFrame owner, boolean modal, SpacecraftFrame caller, DirSelectionEquation equation) {
        super((Frame)owner, modal);
        this.spacecraftSettings = spacecraftSettings;
        this.caller = caller;
        this.equation = equation;
        this.makeDialog();
        this.addFields(equation);
    }

    private void makeDialog() {
        this.setTitle("Directory Selection Equation");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.addButtons();
    }

    private void addFields(DirSelectionEquation equation) {
        this.selectionRows = new JPanel();
        this.selectionRows.setLayout(new BoxLayout(this.selectionRows, 1));
        this.getContentPane().add((Component)this.selectionRows, "Center");
        JPanel north = new JPanel();
        this.btnAnd = new JButton("Add");
        this.btnAnd.addActionListener(this);
        north.setLayout(new FlowLayout(2));
        JLabel lblDates = new JLabel("Apply when file upload date is:");
        north.add(lblDates);
        int dateRes = 0;
        if (equation != null) {
            dateRes = equation.getDateRestriction();
        }
        this.cbDateRestriction.setSelectedIndex(dateRes);
        north.add(this.cbDateRestriction);
        JLabel lblPriority = new JLabel("Priority");
        north.add(lblPriority);
        if (equation != null) {
            int pri = equation.getPriority();
            if (pri == 9) {
                this.cbPriority.setSelectedItem("N");
            } else {
                this.cbPriority.setSelectedItem("" + pri);
            }
        } else {
            this.cbPriority.setSelectedItem("2");
        }
        north.add(this.cbPriority);
        this.getContentPane().add((Component)north, "North");
        this.generateRows(equation);
    }

    private void generateRows(DirSelectionEquation equation) {
        this.selectionRows.removeAll();
        this.row = new JPanel[this.numOfRows];
        this.cbField = new JComboBox[this.numOfRows];
        this.cbOp = new JComboBox[this.numOfRows];
        this.txtValue = new JTextField[this.numOfRows];
        this.opType = new int[this.numOfRows];
        JLabel[] lblAnd = new JLabel[this.numOfRows - 1];
        JPanel[] panAnd = new JPanel[this.numOfRows - 1];
        if (this.numOfRows > 4) {
            this.numOfRows = 4;
        }
        int i2 = 0;
        while (i2 < this.numOfRows) {
            this.addSelectionRow(this.selectionRows, i2, equation);
            if (i2 < this.numOfRows - 1) {
                lblAnd[i2] = new JLabel("AND");
                panAnd[i2] = new JPanel();
                this.selectionRows.add(panAnd[i2]);
                panAnd[i2].setLayout(new FlowLayout(0));
                panAnd[i2].add(lblAnd[i2]);
            }
            ++i2;
        }
        this.repaint();
    }

    private JPanel addSelectionRow(JPanel parent, int rowNum, DirSelectionEquation equation) {
        this.row[rowNum] = new JPanel();
        this.cbOp[rowNum] = new JComboBox<String>(DirSelectionCriteria.STRING_OPS);
        if (equation != null) {
            this.opType[rowNum] = equation.getOpType(rowNum);
        }
        this.row[rowNum].setLayout(new FlowLayout(0));
        JLabel lbl = new JLabel("Select: ");
        this.cbField[rowNum] = new JComboBox<String>(DirSelectionCriteria.FIELDS);
        if (equation != null) {
            this.cbField[rowNum].setSelectedItem(equation.getField(rowNum));
        }
        this.populateOperation(rowNum);
        if (equation != null) {
            this.cbOp[rowNum].setSelectedIndex(equation.getOperation(rowNum));
        }
        this.txtValue[rowNum] = new JTextField();
        if (equation != null) {
            this.txtValue[rowNum].setText(equation.getValue(rowNum));
        }
        this.txtValue[rowNum].setColumns(10);
        this.cbField[rowNum].addItemListener(this);
        this.cbOp[rowNum].addItemListener(this);
        this.cbField[rowNum].setToolTipText("PacSat File Header field");
        lbl.setToolTipText("Choose selection criteria to automatically download directory entries");
        this.row[rowNum].add(lbl);
        this.row[rowNum].add(this.cbField[rowNum]);
        this.row[rowNum].add(this.cbOp[rowNum]);
        this.row[rowNum].add(this.txtValue[rowNum]);
        parent.add(this.row[rowNum]);
        return this.row[rowNum];
    }

    private void populateOperation(int i2) {
        this.opType[i2] = DirSelectionCriteria.getOpTypeByField((String)this.cbField[i2].getSelectedItem());
        String[] labels = this.opType[i2] == 1 ? DirSelectionCriteria.NUMERIC_OPS : DirSelectionCriteria.STRING_OPS;
        this.cbOp[i2].removeAllItems();
        this.cbOp[i2].setModel(new DefaultComboBoxModel<String>(labels));
    }

    private void addButtons() {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JLabel footer = new JLabel("Clear the text to remove a criteria");
        footer.setBorder(new EmptyBorder(5, 5, 5, 50));
        buttonPane.add(footer);
        this.btnSave = new JButton("Save");
        this.btnSave.setActionCommand("Save");
        buttonPane.add(this.btnSave);
        this.btnSave.addActionListener(this);
        this.getRootPane().setDefaultButton(this.btnSave);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setActionCommand("Cancel");
        buttonPane.add(this.btnCancel);
        this.btnCancel.addActionListener(this);
    }

    public void saveProperties() {
        Config.set(DIRSELECTION_WINDOW_HEIGHT, this.getHeight());
        Config.set(DIRSELECTION_WINDOW_WIDTH, this.getWidth());
        Config.set(DIRSELECTION_WINDOW_X, this.getX());
        Config.set(DIRSELECTION_WINDOW_Y, this.getY());
        Config.save();
    }

    public void loadProperties() {
        if (Config.getInt(DIRSELECTION_WINDOW_X) == 0) {
            Config.set(DIRSELECTION_WINDOW_X, 100);
            Config.set(DIRSELECTION_WINDOW_Y, 100);
            Config.set(DIRSELECTION_WINDOW_HEIGHT, 300);
            Config.set(DIRSELECTION_WINDOW_WIDTH, 600);
        }
        this.setBounds(Config.getInt(DIRSELECTION_WINDOW_X), Config.getInt(DIRSELECTION_WINDOW_Y), Config.getInt(DIRSELECTION_WINDOW_WIDTH), Config.getInt(DIRSELECTION_WINDOW_HEIGHT));
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.saveProperties();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCancel) {
            this.dispose();
        }
        if (e.getSource() == this.btnAnd) {
            ++this.numOfRows;
            if (this.numOfRows > 4) {
                this.numOfRows = 4;
            } else {
                this.generateRows(null);
            }
        }
        if (e.getSource() == this.btnSave) {
            int pri;
            boolean added;
            block17: {
                added = false;
                pri = 2;
                String selectedPri = (String)this.cbPriority.getSelectedItem();
                try {
                    pri = Integer.parseInt(selectedPri);
                }
                catch (NumberFormatException e1) {
                    if (!selectedPri.equalsIgnoreCase("N")) break block17;
                    pri = 9;
                }
            }
            DirSelectionEquation equation = new DirSelectionEquation(this.spacecraftSettings, pri, this.cbDateRestriction.getSelectedIndex());
            int i2 = 0;
            while (i2 < this.numOfRows) {
                if (this.cbField[i2] != null && !this.txtValue[i2].getText().equalsIgnoreCase("")) {
                    try {
                        if (this.opType[i2] == 1) {
                            int n = Integer.parseInt(this.txtValue[i2].getText());
                        }
                        DirSelectionCriteria select = new DirSelectionCriteria(((String)this.cbField[i2].getSelectedItem()).toUpperCase(), this.opType[i2], this.cbOp[i2].getSelectedIndex(), this.txtValue[i2].getText().toUpperCase());
                        if (i2 > 0) {
                            Log.print(" AND ");
                        }
                        Log.print("Select: " + select);
                        equation.add(select);
                        added = true;
                    }
                    catch (NumberFormatException n1) {
                        Log.errorDialog("ERROR", (String)this.cbField[i2].getSelectedItem() + ": must be numeric, criteria ignored");
                    }
                }
                ++i2;
            }
            if (added) {
                try {
                    Log.println("");
                    if (this.equation != null) {
                        this.spacecraftSettings.directory.deleteEquation(this.equation.getHashKey());
                    }
                    this.spacecraftSettings.directory.add(equation);
                    this.caller.updateDirEquations();
                }
                catch (IOException e1) {
                    Log.errorDialog("ERROR", "Could not save the Directory Selection Equation\n" + e1);
                }
            }
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int i2 = 0;
        while (i2 < this.numOfRows) {
            if (this.cbField[i2] != null && e.getSource() == this.cbField[i2]) {
                this.populateOperation(i2);
            }
            ++i2;
        }
    }
}

