/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.DesktopApi;
import common.Log;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class HelpAbout
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private final String AMSAT = "https://www.amsat.org";
    private final String FOX = "https://www.amsat.org/?page_id=1113";
    public static final String MANUAL = "pacsat_ground_manual.pdf";
    public static final String LEADERBOARD = "https://www.amsat.org/tlm/";
    public static final String SOFTWARE = "https://www.g0kla.com/pacsat";
    JButton btnClose;

    public HelpAbout(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setDefaultCloseOperation(2);
        this.setBounds(MainWindow.frame.getBounds().x + 25, MainWindow.frame.getBounds().y + 25, 650, 400);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel northPanel = new JPanel();
        panel.add((Component)northPanel, "North");
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        JPanel northApanel = new JPanel();
        JPanel northBpanel = new JPanel();
        northPanel.add(northApanel);
        northPanel.add(northBpanel);
        northApanel.setLayout(new BoxLayout(northApanel, 1));
        JPanel eastPanel = new JPanel();
        panel.add((Component)eastPanel, "East");
        eastPanel.setLayout(new BoxLayout(eastPanel, 1));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        JPanel southPanel = new JPanel();
        panel.add((Component)southPanel, "South");
        JLabel lblAmsatFoxaTelemetry = new JLabel("<html><h2>AMSAT PacSat Ground Station</h2></html>");
        lblAmsatFoxaTelemetry.setForeground(Color.BLUE);
        northApanel.add(lblAmsatFoxaTelemetry);
        this.addLine("Version " + Config.VERSION, northApanel);
        this.addUrl("Written by ", "www.g0kla.com", "<b>Chris Thompson</b>", " VE2TCP / G0KLA / AC2CZ", northApanel);
        this.addUrl("You can browse ", MANUAL, "the manual", " for help", northApanel);
        this.addUrl("Please consider ", "https://www.amsat.org", "donating", " to this and future AMSAT missions", northApanel);
        this.addLine(" ", northApanel);
        this.addUrl("\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the ", "http://www.gnu.org/licenses/gpl-3.0.en.html", "<b>GNU General Public License</b>", " for more details. ", northApanel);
        this.addLine(" ", northApanel);
        this.addLine("This software also includes:", northApanel);
        this.addUrl("- Java ", "https://github.com/java-native/jssc", "<b>JSSC</b> Serial Library", ", released under LGPL", northApanel);
        this.addUrl("", "https://github.com/thrau/jarchivelib", "<b>JArchiveLib</b>", ", released under Apache License and based on Apache Commons Compress", northApanel);
        JScrollPane scrollPane = new JScrollPane(centerPanel, 22, 31);
        panel.add((Component)scrollPane, "Center");
        BufferedImage wPic = null;
        try {
            wPic = ImageIO.read(this.getClass().getResource("/images/AMSAT50_sm.png"));
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
        if (wPic != null) {
            JLabel wIcon = new JLabel(new ImageIcon(wPic));
            northBpanel.add(wIcon);
        }
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(this);
        southPanel.add(this.btnClose);
    }

    private void addUrl(String pre, final String url, String text, String post, JPanel panel) {
        JLabel website = new JLabel();
        website.setForeground(Color.BLACK);
        panel.add(website);
        website.setText("<html>" + pre + "<a href=\"\">" + text + "</a>" + post + "</html>");
        website.setCursor(new Cursor(12));
        website.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    DesktopApi.browse(new URI(url));
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void addLine(String text, JPanel panel) {
        JLabel lblVersion = new JLabel(text);
        lblVersion.setForeground(Color.BLACK);
        panel.add(lblVersion);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnClose) {
            this.dispose();
        }
    }
}

