/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.apple.eawt.Application;
import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.gui.ProgressPanel;
import com.g0kla.telem.segDb.DataTable;
import common.Config;
import common.DesktopApi;
import common.Log;
import common.SpacecraftSettings;
import fileStore.Directory;
import gui.EditorFrame;
import gui.HelpAbout;
import gui.SettingsFrame;
import gui.SpacecraftFrame;
import gui.SpacecraftTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import macos.MacAboutHandler;
import macos.MacPreferencesHandler;
import macos.MacQuitHandler;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import pacSat.FrameDecoder;
import pacSat.SerialTncDecoder;
import pacSat.TcpTncDecoder;
import pacSat.TncDecoder;

public class MainWindow
extends JFrame
implements ActionListener,
WindowListener {
    public static final String MAINWINDOW_X = "mainwindow_x";
    public static final String MAINWINDOW_Y = "mainwindow_y";
    public static final String MAINWINDOW_WIDTH = "mainwindow_width";
    public static final String MAINWINDOW_HEIGHT = "mainwindow_height";
    public static final String WINDOW_FC_WIDTH = "mainwindow_width";
    public static final String WINDOW_FC_HEIGHT = "mainwindow_height";
    public static final String WINDOW_CURRENT_DIR = "mainwindow_current_dir";
    public static final String EDITOR_CURRENT_DIR = "editor_current_dir";
    public static final String WINDOW_SPLIT_PANE_HEIGHT = "window_split_pane_height";
    public static final int DEFAULT_DIVIDER_LOCATION = 450;
    static Application macApplication;
    public static JFrame frame;
    JFileChooser fc = null;
    FileDialog fd = null;
    JLabel lblVersion;
    JLabel lblTotalTelem;
    JLabel lblTotalFrames;
    static JLabel lblLogFileDir;
    static JTextArea logTextArea;
    public static Hashtable<String, SpacecraftTab> spacecraftTabs;
    JTabbedPane spacecraftTabbedPanel;
    static int splitPaneHeight;
    public static TncDecoder tncDecoder;
    Thread tncDecoderThread;
    FrameDecoder frameDecoder;
    Thread frameDecoderThread;
    JLabel lblComPort;
    JLabel lblServerQueue;
    static JMenuItem mntmGetServerData;
    static JMenuItem mntmExit;
    static JMenuItem mntmLoadKissFile;
    static JMenuItem mntmLoadAX25File;
    static JMenuItem mntmArchiveDir;
    static JMenuItem mntmSettings;
    static JMenuItem mntmManual;
    static JMenuItem mntmLeaderboard;
    static JMenuItem mntmWebsite;
    static JMenuItem mntmAbout;
    static JMenuItem[] mntmSat;
    static JMenuItem mntmAddSat;
    static JMenuItem mntmRemoveSat;
    static JMenuItem mntmReqDir;
    Timer timer;
    static int fontSize;
    public static Font sysFont;

    static {
        splitPaneHeight = 450;
    }

    public MainWindow() {
        frame = this;
        spacecraftTabs = new Hashtable();
        this.initialize();
        if (Config.isMacOs()) {
            macApplication = Application.getApplication();
            macApplication.setAboutHandler(new MacAboutHandler());
            macApplication.setPreferencesHandler(new MacPreferencesHandler());
            macApplication.setQuitHandler(new MacQuitHandler(this));
        }
        for (SpacecraftSettings spacecraftSettings : Config.spacecraftSettings) {
            String[][] data = spacecraftSettings.directory.getTableData();
            if (data.length > 0) {
                MainWindow.setDirectoryData(spacecraftSettings.name, data);
            }
            if (spacecraftSettings.outbox.getTableData() == null) continue;
            MainWindow.setOutboxData(spacecraftSettings.name, spacecraftSettings.outbox.getTableData());
        }
        this.initDecoder();
        int speed = 1000;
        int pause = 1000;
        this.timer = new Timer(speed, this);
        this.timer.setInitialDelay(pause);
        this.timer.start();
    }

    private void initialize() {
        if (Config.getInt(MAINWINDOW_X) == 0) {
            Config.set(MAINWINDOW_X, 100);
            Config.set(MAINWINDOW_Y, 100);
            Config.set("mainwindow_width", 850);
            Config.set("mainwindow_height", 800);
        }
        this.setBounds(Config.getInt(MAINWINDOW_X), Config.getInt(MAINWINDOW_Y), Config.getInt("mainwindow_width"), Config.getInt("mainwindow_height"));
        this.setDefaultCloseOperation(0);
        this.setTitle("AMSAT PacSat Ground Station");
        fontSize = Config.getInt("font_size");
        this.initMenu();
        this.makeBottomPanel();
        this.makeCenterPanel();
        this.fd = new FileDialog((Frame)frame, "Select Kiss file", 0);
        this.fd.setFile("*.kss");
        this.fc = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Kiss", "kss", "Raw", "raw");
        this.fc.setFileFilter(filter);
        Action details = this.fc.getActionMap().get("viewTypeDetails");
        if (Config.isWindowsOs()) {
            details.actionPerformed(null);
        }
        this.addWindowListener(this);
    }

    public static void setDownlinkStatus(String satName, String txt) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            if (txt.equalsIgnoreCase("PB Avail")) {
                tab.lblDownlinkStatus.setForeground(Color.blue);
            } else if (txt.equalsIgnoreCase("ON PB")) {
                tab.lblDownlinkStatus.setForeground(Config.AMSAT_RED);
            } else {
                tab.lblDownlinkStatus.setForeground(Color.BLACK);
            }
            tab.lblDownlinkStatus.setText("DL: " + txt);
        }
    }

    public static void setLoggedin(String satName, String txt) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            tab.lblPGLogin.setText(txt);
        }
    }

    public static void setUplinkStatus(String satName, String txt) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            if (txt.equalsIgnoreCase("Open")) {
                tab.lblUplinkStatus.setForeground(Color.blue);
            } else if (txt.equalsIgnoreCase("Cmd Ok") || txt.equalsIgnoreCase("Waiting") || txt.equalsIgnoreCase("Data") || txt.equalsIgnoreCase("Data End")) {
                tab.lblUplinkStatus.setForeground(Config.AMSAT_RED);
            } else {
                tab.lblUplinkStatus.setForeground(Color.BLACK);
            }
            tab.lblUplinkStatus.setText("UL: " + txt);
        }
    }

    public static void setLayer2Status(String satName, String txt) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            tab.lblLayer2Status.setText("LAYER2: " + txt);
        }
    }

    public static void setDirectoryData(String satName, String[][] data) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            tab.setDirectoryData(data);
        }
    }

    public static void setOutboxData(String satName, String[][] data) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            tab.outbox.setDirectoryData(data);
        }
    }

    public static void setPBStatus(String satName, String pb) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            tab.lblPBStatus.setText(pb);
        }
    }

    public static void setPGStatus(String satName, String pg) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            tab.lblPGStatus.setText(pg);
        }
    }

    public void append(String s) {
        if (logTextArea != null) {
            logTextArea.append(s);
            if (Config.getBoolean("keep_caret_at_end_of_log")) {
                try {
                    logTextArea.setCaretPosition(logTextArea.getText().length());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void initDecoder() {
        if (this.frameDecoder != null) {
            this.frameDecoder.close();
        }
        this.frameDecoder = new FrameDecoder(this);
        this.frameDecoderThread = new Thread(this.frameDecoder);
        this.frameDecoderThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.frameDecoderThread.setName("Frame Decoder");
        this.frameDecoderThread.start();
        if (tncDecoder != null) {
            tncDecoder.close();
        }
        if (Config.getBoolean("kiss_tcp_interface")) {
            String hostname = Config.get("tnc_tcp_hostname");
            if (hostname == null) {
                return;
            }
            int port = Config.getInt("tnc_tcp_port");
            if (port == 0) {
                return;
            }
            tncDecoder = new TcpTncDecoder(hostname, port, this.frameDecoder, this);
        } else {
            String com = Config.get("COM_PORT");
            if (com == null) {
                return;
            }
            tncDecoder = new SerialTncDecoder(com, Config.getInt("TNC_BAUD_RATE"), Config.getInt("TNC_DATA_BITS"), Config.getInt("TNC_STOP_BITS"), Config.getInt("TNC_PARITY"), this.frameDecoder, this);
        }
        for (SpacecraftSettings spacecraftSettings : Config.spacecraftSettings) {
            spacecraftSettings.downlink.setTncDecoder(tncDecoder, this);
            spacecraftSettings.uplink.setTncDecoder(tncDecoder, this);
            spacecraftSettings.layer2data.setTncDecoder(tncDecoder, this);
        }
        this.tncDecoderThread = new Thread(tncDecoder);
        this.tncDecoderThread.setUncaughtExceptionHandler(Log.uncaughtExHandler);
        this.tncDecoderThread.setName("Tnc Decoder");
        this.tncDecoderThread.start();
    }

    private void makeCenterPanel() {
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)centerPanel, "Center");
        splitPaneHeight = Config.getInt(WINDOW_SPLIT_PANE_HEIGHT);
        this.spacecraftTabbedPanel = new JTabbedPane(1);
        this.spacecraftTabbedPanel.setTabLayoutPolicy(1);
        this.spacecraftTabbedPanel.setFont(sysFont);
        for (SpacecraftSettings satSettings : Config.spacecraftSettings) {
            SpacecraftTab center = new SpacecraftTab(satSettings);
            spacecraftTabs.put(satSettings.name, center);
            this.spacecraftTabbedPanel.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=15 marginheight=5>" + satSettings.name + "</body></html>", center);
        }
        centerPanel.add((Component)this.spacecraftTabbedPanel, "Center");
    }

    public void refreshTabs(SpacecraftSettings spacecraftSettings) {
        SpacecraftTab tab = spacecraftTabs.get(spacecraftSettings.name);
        if (tab != null) {
            tab.removeTabs();
            tab.addDirTabs();
            tab.addTelemTabs(spacecraftSettings);
            spacecraftSettings.directory.setShowFiles(spacecraftSettings.getBoolean("show_user_files"));
        }
    }

    private void makeBottomPanel() {
        JPanel bottomPanel = new JPanel();
        this.getContentPane().add((Component)bottomPanel, "South");
        bottomPanel.setLayout(new BorderLayout());
        JPanel statusPanel = this.makeStatusPanel();
        bottomPanel.add((Component)statusPanel, "South");
    }

    private JPanel makeStatusPanel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        JPanel rightBottom = new JPanel();
        rightBottom.setLayout(new BoxLayout(rightBottom, 0));
        this.lblVersion = new JLabel("Version " + Config.VERSION);
        Font bf = new Font(sysFont.getFontName(), sysFont.getStyle(), (int)((double)sysFont.getSize() * 0.9));
        this.lblVersion.setFont(bf);
        this.lblVersion.setBorder(new EmptyBorder(2, 10, 2, 10));
        statusPanel.add((Component)this.lblVersion, "West");
        lblLogFileDir = new JLabel();
        this.updateLogfileDir();
        lblLogFileDir.setFont(bf);
        lblLogFileDir.setBorder(new EmptyBorder(2, 10, 2, 10));
        JPanel rightStatusPanel = new JPanel();
        rightStatusPanel.setLayout(new FlowLayout(2));
        statusPanel.add((Component)rightStatusPanel, "East");
        JLabel bar2 = new JLabel("|");
        rightStatusPanel.add(bar2);
        this.lblComPort = Config.getBoolean("kiss_tcp_interface") ? new JLabel(String.valueOf(Config.get("tnc_tcp_hostname")) + ":" + Config.get("tnc_tcp_port")) : new JLabel(Config.get("COM_PORT"));
        this.lblComPort.setBorder(new EmptyBorder(2, 5, 2, 5));
        this.lblComPort.setToolTipText("TNC Connection");
        this.lblComPort.setFont(bf);
        rightStatusPanel.add(this.lblComPort);
        JLabel bar3 = new JLabel("|");
        rightStatusPanel.add(bar3);
        JLabel lblTotal = new JLabel("Telem: ");
        lblTotal.setFont(bf);
        rightStatusPanel.add(lblTotal);
        lblTotal.setToolTipText("Total number of telemetry records decoded and stored");
        lblTotal.setBorder(new EmptyBorder(2, 5, 2, 0));
        this.lblTotalTelem = new JLabel("0");
        this.lblTotalTelem.setToolTipText("Total number of telemetry records decoded and stored");
        this.lblTotalTelem.setFont(bf);
        rightStatusPanel.add(this.lblTotalTelem);
        this.lblTotalTelem.setBorder(new EmptyBorder(2, 0, 2, 5));
        JLabel bar1 = new JLabel("/");
        rightStatusPanel.add(bar1);
        this.lblServerQueue = new JLabel("-");
        this.lblServerQueue.setBorder(new EmptyBorder(2, 5, 2, 10));
        this.lblServerQueue.setToolTipText("Telemetry records to be sent to the AMSAT telemetry server");
        this.lblServerQueue.setFont(bf);
        rightStatusPanel.add(this.lblServerQueue);
        statusPanel.add((Component)lblLogFileDir, "Center");
        return statusPanel;
    }

    public void updateLogfileDir() {
        if (Config.get("logfile_dir").equals("")) {
            lblLogFileDir.setText("Logs: Current Directory");
        } else {
            lblLogFileDir.setText("Logs: " + Config.get("logfile_dir"));
        }
    }

    public static void setFileUploading(String satName, long id, long offset, long length) {
        SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab != null) {
            String p = "0";
            if (length != 0L) {
                p = String.format("%.1f", Float.valueOf((float)(100L * offset) / (float)length));
            }
            tab.lblFileUploading.setText("File: " + Long.toHexString(id) + " " + p + "%");
            if (id == 0L) {
                tab.lblFileUploading.setForeground(Color.BLACK);
            } else if (offset == length) {
                tab.lblFileUploading.setForeground(Color.BLUE);
            } else {
                tab.lblFileUploading.setForeground(Config.AMSAT_RED);
            }
        }
    }

    private void initMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        Font f = mnFile.getFont();
        if (fontSize == 0) {
            fontSize = f.getSize();
            Config.set("font_size", fontSize);
        }
        sysFont = new Font(f.getFontName(), f.getStyle(), fontSize);
        mnFile.setFont(sysFont);
        menuBar.add(mnFile);
        mnFile.addSeparator();
        mntmLoadKissFile = new JMenuItem("Load Kiss File");
        mntmLoadKissFile.setFont(sysFont);
        mnFile.setFont(sysFont);
        mnFile.add(mntmLoadKissFile);
        mntmLoadKissFile.addActionListener(this);
        mntmLoadAX25File = new JMenuItem("Load AX25 Frame");
        mntmLoadAX25File.setFont(sysFont);
        mnFile.setFont(sysFont);
        mnFile.add(mntmLoadAX25File);
        mntmLoadAX25File.addActionListener(this);
        if (!Config.isMacOs()) {
            mntmSettings = new JMenuItem("Settings");
            mntmSettings.setFont(sysFont);
            mnFile.add(mntmSettings);
            mntmSettings.addActionListener(this);
            mnFile.addSeparator();
        }
        mntmGetServerData = new JMenuItem("Fetch Server Data");
        mntmGetServerData.setFont(sysFont);
        mnFile.add(mntmGetServerData);
        mntmGetServerData.addActionListener(this);
        mntmArchiveDir = new JMenuItem("Archive the Directory");
        mntmArchiveDir.setFont(sysFont);
        mnFile.add(mntmArchiveDir);
        mntmArchiveDir.addActionListener(this);
        mntmExit = new JMenuItem("Exit");
        mntmExit.setFont(sysFont);
        mnFile.add(mntmExit);
        mntmExit.addActionListener(this);
        JMenu mnSats = new JMenu("Spacecraft");
        mnSats.setFont(sysFont);
        menuBar.add(mnSats);
        mntmAddSat = new JMenuItem("Add");
        mntmAddSat.setFont(sysFont);
        mnSats.add(mntmAddSat);
        mntmAddSat.addActionListener(this);
        mntmRemoveSat = new JMenuItem("Remove");
        mntmRemoveSat.setFont(sysFont);
        mnSats.add(mntmRemoveSat);
        mntmRemoveSat.addActionListener(this);
        mnSats.addSeparator();
        mntmSat = new JMenuItem[Config.spacecraftSettings.size()];
        int i2 = 0;
        for (SpacecraftSettings spacecraftSettings : Config.spacecraftSettings) {
            MainWindow.mntmSat[i2] = new JMenuItem(spacecraftSettings.name);
            mntmSat[i2].setFont(sysFont);
            mnSats.add(mntmSat[i2]);
            mntmSat[i2].addActionListener(this);
            ++i2;
        }
        JMenu mnHelp = new JMenu("Help");
        mnHelp.setFont(sysFont);
        menuBar.add(mnHelp);
        mntmManual = new JMenuItem("Open Manual");
        mntmManual.setFont(sysFont);
        mnHelp.add(mntmManual);
        mntmManual.addActionListener(this);
        mntmLeaderboard = new JMenuItem("View Telemetry Leaderboard");
        mntmLeaderboard.setFont(sysFont);
        mnHelp.add(mntmLeaderboard);
        mntmLeaderboard.addActionListener(this);
        mntmWebsite = new JMenuItem("PacSat Website");
        mntmWebsite.setFont(sysFont);
        mnHelp.add(mntmWebsite);
        mntmWebsite.addActionListener(this);
        if (!Config.isMacOs()) {
            mntmAbout = new JMenuItem("About");
            mntmAbout.setFont(sysFont);
            mnHelp.add(mntmAbout);
            mntmAbout.addActionListener(this);
        }
    }

    public void shutdownWindow() {
        if (this.frameDecoder != null) {
            this.frameDecoder.close();
        }
        if (tncDecoder != null) {
            tncDecoder.close();
        }
        try {
            for (SpacecraftSettings spacecraftSettings : Config.spacecraftSettings) {
                spacecraftSettings.directory.save();
            }
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "Could not save the directory\n" + e.getMessage());
        }
        Log.println("Window Closed");
        Log.close();
        this.dispose();
        this.saveProperties();
        System.exit(0);
    }

    public void saveProperties() {
        Config.set("mainwindow_height", this.getHeight());
        Config.set("mainwindow_width", this.getWidth());
        Config.set(MAINWINDOW_X, this.getX());
        Config.set(MAINWINDOW_Y, this.getY());
        Config.save();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.shutdownWindow();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.shutdownWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    static void newMessage(SpacecraftSettings sat) {
        if (sat == null) {
            return;
        }
        EditorFrame editor = null;
        editor = new EditorFrame(sat);
        editor.setVisible(true);
    }

    private void archiveDir(SpacecraftSettings spacecraftSettings) {
        String archiveDir = Config.get("archive_dir");
        if (archiveDir.equalsIgnoreCase("")) {
            Log.errorDialog("Invalid archive directory", "Can not archive " + spacecraftSettings.name + " into the same folder as the current data\n" + "Go to the File > Settings window and set a valid Archive folder.");
            return;
        }
        File archiveFile = new File(String.valueOf(archiveDir) + File.separator + spacecraftSettings.name + File.separator + "directory.db");
        if (archiveFile.exists()) {
            Log.errorDialog("Archive directory already exists for " + spacecraftSettings.name, "This would overwrite the data in archive:  " + archiveDir + "\n" + "Go to the File > Settings window and choose a new archive folder, or delete this data on disk before archiving.");
            return;
        }
        String message = "Move Headers and Files for " + spacecraftSettings.name + " to Archive Folder?\n" + "This will move your headers and files to the archive folder:  " + archiveDir + "\nIt will keep " + spacecraftSettings.get("number_dir_table_entries") + " headers and their files\n" + "To archive more (or less) headers, adjust the number on the Spacecraft settings window\n\n" + "To access the archive later change the log file folder on the File > Settings window, or \n" + "run another copy of PacSatGround and pass in the archive folder path on the command line\n" + "(In either case it is probablly best to enable 'Inhibit Transmitter' while browsing the archive)";
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(frame, message, "Do you want to continue?", 0, 0, null, options, options[1]);
        if (n == 1) {
            return;
        }
        ProgressPanel refreshProgress = new ProgressPanel(this, "Archiving to " + archiveDir, false);
        refreshProgress.setVisible(true);
        spacecraftSettings.directory.archiveDir(archiveDir);
        MainWindow.setDirectoryData(spacecraftSettings.name, spacecraftSettings.directory.getTableData());
        refreshProgress.updateProgress(100);
    }

    private void replaceServerData(SpacecraftSettings spacecraftSettings) {
        if (Config.get("logfile_dir").equalsIgnoreCase("")) {
            Log.errorDialog("CAN'T EXTRACT SERVER DATA INTO CURRENT DIRECTORY", "You can not replace the log files in the current directory.  Pick another directory from the settings menu\n");
            return;
        }
        String message = "Do you want to download " + spacecraftSettings.name + " data to REPLACE your existing data?\n" + "THIS WILL OVERWRITE YOUR EXISTING LOG FILES. DO NOT DOWNLOAD INTO THE SAME LOG FILE DIR YOU USE FOR LIVE RECEPTION.\n" + "The volume of server data will slow the program down and cause issues with live operation." + "*** Switch to a new directory if you have live data stored ***\n" + "To import into into a different set of log files select NO, then choose a new log file directory from the settings menu";
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(frame, message, "Do you want to continue?", 0, 0, null, options, options[1]);
        if (n == 1) {
            return;
        }
        String dir = spacecraftSettings.spacecraft.name;
        if (dir != null) {
            this.downloadServerData(spacecraftSettings, dir);
        }
        ProgressPanel refreshProgress = new ProgressPanel(this, "refreshing tabs ...", false);
        refreshProgress.setVisible(true);
        try {
            spacecraftSettings.initSegDb(spacecraftSettings.spacecraft);
        }
        catch (LayoutLoadException e) {
            Log.errorDialog("ERROR", "Could not reload the Telemetry Layouts: " + e.getMessage());
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "Could not reload the Telemetry Data: " + e.getMessage());
        }
        spacecraftSettings.initDirectory();
        this.refreshTabs(spacecraftSettings);
        MainWindow.setDirectoryData(spacecraftSettings.name, spacecraftSettings.directory.getTableData());
        MainWindow.setOutboxData(spacecraftSettings.name, spacecraftSettings.outbox.getTableData());
        refreshProgress.updateProgress(100);
    }

    private void downloadServerData(SpacecraftSettings spacecraftSettings, String dir) {
        String file = "TLMDB.tar.gz";
        file = String.valueOf(Config.get("logfile_dir")) + File.separator + spacecraftSettings.name + File.separator + file;
        ProgressPanel fileProgress = new ProgressPanel(this, "Downloading " + dir + " data, please wait ...", false);
        fileProgress.setVisible(true);
        String urlString = String.valueOf(spacecraftSettings.get("web_site_url")) + "/" + dir + "/TLMDB.tar.gz";
        try {
            URL website = new URL(urlString);
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(file);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
        }
        catch (FileNotFoundException e) {
            Log.errorDialog("ERROR", "Reading the server data for: " + file + "\n" + e.getMessage());
            e.printStackTrace(Log.getWriter());
            fileProgress.updateProgress(100);
            return;
        }
        catch (MalformedURLException e) {
            Log.errorDialog("ERROR", "ERROR can't access the server data at: " + urlString);
            e.printStackTrace(Log.getWriter());
            fileProgress.updateProgress(100);
            return;
        }
        catch (IOException e) {
            Log.errorDialog("ERROR", "ERROR reading/writing the server data from server: " + file + "\n+" + e.getMessage());
            e.printStackTrace(Log.getWriter());
            fileProgress.updateProgress(100);
            return;
        }
        fileProgress.updateProgress(100);
        File archive = new File(file);
        if (archive.length() != 0L) {
            ProgressPanel decompressProgress = new ProgressPanel(this, "decompressing " + dir + " data ...", false);
            decompressProgress.setVisible(true);
            File destination = new File(String.valueOf(Config.get("logfile_dir")) + File.separator + spacecraftSettings.name);
            Archiver archiver = ArchiverFactory.createArchiver("tar", "gz");
            try {
                archiver.extract(archive, destination);
            }
            catch (IOException e) {
                Log.errorDialog("ERROR", "ERROR could not uncompress the server data\n+" + e.getMessage());
                e.printStackTrace(Log.getWriter());
                decompressProgress.updateProgress(100);
                return;
            }
            catch (IllegalArgumentException e) {
                Log.errorDialog("ERROR", "ERROR could not uncompress the server data\n+" + e.getMessage());
                e.printStackTrace(Log.getWriter());
                decompressProgress.updateProgress(100);
                return;
            }
            decompressProgress.updateProgress(100);
        }
    }

    public void setFrames(final int amount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.lblTotalFrames.setText("" + amount);
            }
        });
    }

    public void setEfficiency(String satName, final int sent, final int received) {
        final SpacecraftTab tab = spacecraftTabs.get(satName);
        if (tab == null) {
            return;
        }
        if (sent == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                double eff = (double)(100 * received) / (double)sent;
                tab.lblEfficiency.setText("Sent: " + sent + " / Rec: " + received + " / Eff: " + String.format("%.1f", eff) + "%");
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.timer && Config.stpQueue != null) {
            int num = Config.stpQueue.getSize();
            this.lblServerQueue.setText("" + num);
            int total = 0;
            for (SpacecraftSettings spacecraftSettings : Config.spacecraftSettings) {
                if (spacecraftSettings.db == null) continue;
                total += spacecraftSettings.db.getNumberOfFrames();
            }
            this.lblTotalTelem.setText("" + total);
        }
        if (e.getSource() == mntmLoadKissFile) {
            this.loadFile(false);
        }
        if (e.getSource() == mntmLoadAX25File) {
            this.loadFile(true);
        }
        if (e.getSource() == mntmGetServerData) {
            SpacecraftSettings spacecraftSettings = Config.getSatSettingsByName("FalconSat-3");
            if (spacecraftSettings == null) {
                return;
            }
            this.replaceServerData(spacecraftSettings);
        }
        if (e.getSource() == mntmArchiveDir) {
            for (SpacecraftSettings spacecraftSettings : Config.spacecraftSettings) {
                this.archiveDir(spacecraftSettings);
            }
        }
        if (e.getSource() == mntmExit) {
            this.windowClosed(null);
        }
        if (e.getSource() == mntmSettings) {
            SettingsFrame f = new SettingsFrame(this, true);
            f.setVisible(true);
        }
        if (e.getSource() == mntmAddSat) {
            this.addSpacecraft(false);
        }
        if (e.getSource() == mntmRemoveSat) {
            this.addSpacecraft(true);
        }
        int i2 = 0;
        while (i2 < mntmSat.length) {
            if (e.getSource() == mntmSat[i2]) {
                SpacecraftSettings spacecraftSettings;
                String n = mntmSat[i2].getText();
                spacecraftSettings = Config.getSatSettingsByName(n);
                SpacecraftFrame f = new SpacecraftFrame(spacecraftSettings, this, true);
                f.setVisible(true);
            }
            ++i2;
        }
        if (e.getSource() == mntmManual) {
            try {
                DesktopApi.browse(new URI("pacsat_ground_manual.pdf"));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == mntmLeaderboard) {
            try {
                DesktopApi.browse(new URI("https://www.amsat.org/tlm/"));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == mntmWebsite) {
            try {
                DesktopApi.browse(new URI("https://www.g0kla.com/pacsat"));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
        if (e.getSource() == mntmAbout) {
            HelpAbout help = new HelpAbout(this, true);
            help.setVisible(true);
        }
    }

    public boolean loadFile(boolean singleAX25) {
        File file = null;
        File dir = null;
        String d = Config.get(WINDOW_CURRENT_DIR);
        if (d == null) {
            dir = new File(".");
        } else if (d != "") {
            dir = new File(Config.get(WINDOW_CURRENT_DIR));
        }
        if (Config.getBoolean("use_native_file_chooser")) {
            if (singleAX25) {
                this.fd.setFile("*.*");
            } else {
                this.fd.setFile("*.kss");
            }
            if (dir != null) {
                this.fd.setDirectory(dir.getAbsolutePath());
            }
            this.fd.setVisible(true);
            String filename = this.fd.getFile();
            String dirname = this.fd.getDirectory();
            if (filename == null) {
                Log.println("You cancelled the choice");
            } else {
                Log.println("File: " + filename);
                Log.println("DIR: " + dirname);
                file = new File(String.valueOf(dirname) + filename);
            }
        } else {
            if (Config.getInt("mainwindow_width") == 0) {
                Config.set("mainwindow_width", 600);
                Config.set("mainwindow_height", 600);
            }
            this.fc.setPreferredSize(new Dimension(Config.getInt("mainwindow_width"), Config.getInt("mainwindow_height")));
            if (dir != null) {
                this.fc.setCurrentDirectory(dir);
            }
            int returnVal = this.fc.showOpenDialog(this);
            Config.set("mainwindow_height", this.fc.getHeight());
            Config.set("mainwindow_width", this.fc.getWidth());
            if (returnVal == 0) {
                file = this.fc.getSelectedFile();
            }
        }
        if (file != null) {
            Config.set(WINDOW_CURRENT_DIR, file.getParent());
            try {
                if (singleAX25) {
                    this.frameDecoder.decodeAX25Frame(file.getAbsolutePath(), this);
                } else {
                    this.frameDecoder.decode(file.getAbsolutePath(), this);
                }
            }
            catch (IOException e) {
                Log.errorDialog("ERROR PROCESSING BYTE FILE", "" + e);
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void addSpacecraft(boolean remove) {
        File file = null;
        File destinationDir = null;
        File dir = null;
        if (remove) {
            dir = new File(String.valueOf(Config.get("logfile_dir")) + File.separator + "spacecraft");
        } else {
            dir = new File(String.valueOf(Config.currentDir) + File.separator + "spacecraft");
            String dirFolder = String.valueOf(Config.get("logfile_dir")) + File.separator + "spacecraft";
            destinationDir = new File(dirFolder);
            if (!destinationDir.exists() && !Directory.makeDir(dirFolder)) {
                Log.errorDialog("ERROR making folder", "\nCould not make the spacecraft folder\n" + dirFolder);
                return;
            }
        }
        if (Config.getBoolean("use_native_file_chooser") && !Config.isLinuxOs()) {
            if (remove) {
                this.fd.setFile("*.properties");
                this.fd.setTitle("Select spacecraft PROPERTIES file to remove");
            } else {
                this.fd.setFile("*.properties");
                this.fd.setTitle("Select spacecraft PROPERTIES file to install");
            }
            if (dir != null) {
                this.fd.setDirectory(dir.getAbsolutePath());
            }
            this.fd.setVisible(true);
            String filename = this.fd.getFile();
            String dirname = this.fd.getDirectory();
            if (filename == null) {
                Log.println("You cancelled the choice");
                file = null;
            } else {
                Log.println("File: " + filename);
                Log.println("DIR: " + dirname);
                file = new File(String.valueOf(dirname) + filename);
            }
        } else {
            FileNameExtensionFilter filter;
            if (Config.getInt("mainwindow_width") == 0) {
                Config.set("mainwindow_width", 600);
                Config.set("mainwindow_height", 600);
            }
            this.fc.setPreferredSize(new Dimension(Config.getInt("mainwindow_width"), Config.getInt("mainwindow_height")));
            if (remove) {
                this.fc.setDialogTitle("Select spacecraft DAT file to remove");
                filter = new FileNameExtensionFilter("Spacecraft files", "properties");
                this.fc.setFileFilter(filter);
                this.fc.setApproveButtonText("Remove");
            } else {
                this.fc.setDialogTitle("Select spacecraft PROPERTIES file to install");
                filter = new FileNameExtensionFilter("Spacecraft files", "properties");
                this.fc.setFileFilter(filter);
                this.fc.setApproveButtonText("Add");
            }
            if (dir != null) {
                this.fc.setCurrentDirectory(dir);
            }
            int returnVal = this.fc.showOpenDialog(this);
            Config.set("mainwindow_height", this.fc.getHeight());
            Config.set("mainwindow_width", this.fc.getWidth());
            if (returnVal == 0) {
                file = this.fc.getSelectedFile();
                Log.println("File: " + file.getName());
                Log.println("DIR: " + file.getPath());
            } else {
                file = null;
            }
        }
        Config.save();
        if (file != null) {
            boolean refresh = false;
            if (remove) {
                int n = Log.optionYNdialog("Delete the spacecraft config file?", String.valueOf(file.getName()) + "\n\nYou will be able to install the spacecraft again if you want. Local files\n" + "downloaded will not be removed.  Remove for now?\n\n");
                if (n == 1) {
                    refresh = false;
                } else {
                    try {
                        DataTable.remove(file.getAbsolutePath());
                        refresh = true;
                    }
                    catch (IOException e) {
                        Log.errorDialog("ERROR removing File", "\nCould not remove the spacecraft file\n" + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                    }
                }
            } else {
                String targetName = file.getName().replace(".MASTER", ".dat");
                File targetFile = new File(String.valueOf(destinationDir.getPath()) + File.separator + targetName);
                boolean copy = true;
                Log.println("Installing " + file.getAbsolutePath() + " as " + targetFile.getAbsolutePath());
                if (targetFile.exists()) {
                    int n = Log.optionYNdialog("Overwrite Existing spacecraft config file?", String.valueOf(targetFile.getName()) + "\n\nThis spacecraft is already installed.  Overwrite it and reset to default settings?\n\n");
                    if (n == 1) {
                        copy = false;
                    } else {
                        copy = true;
                        try {
                            DataTable.remove(targetFile.getAbsolutePath());
                            refresh = true;
                        }
                        catch (IOException e) {
                            Log.errorDialog("ERROR removing existing File", "\nCould not overwrite the existing spacecraft file\n" + e.getMessage());
                            e.printStackTrace(Log.getWriter());
                            copy = false;
                        }
                    }
                }
                if (copy) {
                    try {
                        Config.copyFile(file, targetFile);
                        refresh = true;
                    }
                    catch (IOException e) {
                        Log.errorDialog("ERROR Copy File", "Could not copy the spacecraft file\n" + e.getMessage());
                        e.printStackTrace(Log.getWriter());
                    }
                }
            }
            if (refresh) {
                Log.infoDialog("RESTART", "You need to exit and restart to see the spacecraft you installed or removed");
            }
        }
    }
}

