/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.g0kla.telem.data.LayoutLoadException;
import com.g0kla.telem.server.Location;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.Directory;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pacSat.SerialTncDecoder;

public class SettingsFrame
extends JDialog
implements ActionListener,
ItemListener,
FocusListener,
WindowListener,
DocumentListener {
    public static final int MAX_CALLSIGN_LEN = 6;
    public static final int MAX_STATION_LEN = 50;
    public static final String NONE = "NONE";
    public static final String SETTINGS_WINDOW_X = "settings_window_x";
    public static final String SETTINGS_WINDOW_Y = "settings_window_y";
    public static final String SETTINGS_WINDOW_WIDTH = "settings_window_width";
    public static final String SETTINGS_WINDOW_HEIGHT = "settings_window_height";
    private JPanel contentPane;
    private JPanel customByteButtons;
    private JPanel panelBytes;
    private JPanel panelBytes2;
    private JTextField txtLogFileDirectory;
    private JTextField txtArchiveDirectory;
    private JTextField txtLatitude;
    private JTextField txtLongitude;
    private JTextField txtMaidenhead;
    private JTextField txtStation;
    private JTextField txtAltitude;
    private JTextField txtCallsign;
    private JTextField txtTxDelay;
    private JTextField txtHostname;
    private JTextField txtTcpPort;
    private JTextField txtFontSize;
    private JTextArea txtTextAtStart;
    private JTextArea txtBytesAtStart;
    private JTextArea txtTextAtEnd;
    private JTextArea txtBytesAtEnd;
    private JLabel lblTextAtStart;
    private JLabel lblTextAtEnd;
    JRadioButton rbTcpTncInterface;
    JRadioButton rbSerialTncInterface;
    JRadioButton rbTextEdit;
    JRadioButton rbBytesEdit;
    private JCheckBox cbDebugLayer2;
    private JCheckBox cbDebugLayer3;
    private JCheckBox cbLogKiss;
    private JCheckBox cbLogging;
    private JCheckBox cbDebugTx;
    private JCheckBox cbDebugDownlink;
    private JCheckBox cbDebugTelem;
    private JCheckBox cbTxInhibit;
    private JCheckBox cbUploadToServer;
    private JCheckBox cbToggleKiss;
    private JCheckBox cbShowDirTimes;
    private JCheckBox cbSendCustomBytes;
    private JCheckBox cbShowSystemFilesInDir;
    private JCheckBox cbKeepCaretAtEndOfLog;
    private JComboBox cbTncComPort;
    private JComboBox cbTncBaudRate;
    private JComboBox cbTncDataBits;
    private JComboBox cbTncStopBits;
    private JComboBox cbTncParity;
    boolean useUDP;
    boolean tcp;
    private JPanel serverPanel;
    JPanel leftcolumnpanelSerial;
    JPanel leftcolumnpanelTCP;
    JButton btnSave;
    JButton btnCancel;
    JButton btnBrowse;
    JButton btnBrowseArchive;

    public SettingsFrame(JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setTitle("Settings");
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel southpanel = new JPanel();
        this.contentPane.add((Component)southpanel, "South");
        southpanel.setLayout(new FlowLayout(1, 5, 5));
        this.btnSave = new JButton("Save");
        this.btnSave.addActionListener(this);
        southpanel.add(this.btnSave);
        this.getRootPane().setDefaultButton(this.btnSave);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        southpanel.add(this.btnCancel);
        JPanel northpanel = new JPanel();
        this.contentPane.add((Component)northpanel, "North");
        northpanel.setLayout(new BorderLayout());
        JPanel northpanel1 = new JPanel();
        northpanel.add((Component)northpanel1, "North");
        JPanel northpanelA = new JPanel();
        JPanel northpanelB = new JPanel();
        northpanel1.setLayout(new BorderLayout());
        northpanel1.add((Component)northpanelA, "North");
        northpanel1.add((Component)northpanelB, "South");
        northpanelA.setLayout(new BorderLayout());
        northpanelB.setLayout(new BorderLayout());
        JLabel lblHomeDir = new JLabel("Home directory     ");
        lblHomeDir.setToolTipText("This is the directory that contains the settings file");
        lblHomeDir.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanelA.add((Component)lblHomeDir, "West");
        JLabel lblHomeDir2 = new JLabel(Config.homeDir);
        northpanelA.add((Component)lblHomeDir2, "Center");
        JPanel northpanel2 = new JPanel();
        northpanel.add((Component)northpanel2, "South");
        JPanel northpanel2A = new JPanel();
        JPanel northpanel2B = new JPanel();
        northpanel2.setLayout(new BorderLayout());
        northpanel2.add((Component)northpanel2A, "North");
        northpanel2.add((Component)northpanel2B, "South");
        northpanel2A.setLayout(new BorderLayout());
        northpanel2B.setLayout(new BorderLayout());
        JLabel lblLogFilesDir = new JLabel("Log files directory");
        lblLogFilesDir.setToolTipText("This sets the directory that the downloaded telemetry data is stored in");
        lblLogFilesDir.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanel2A.add((Component)lblLogFilesDir, "West");
        this.txtLogFileDirectory = new JTextField(Config.get("logfile_dir"));
        northpanel2A.add((Component)this.txtLogFileDirectory, "Center");
        this.txtLogFileDirectory.setColumns(30);
        this.txtLogFileDirectory.addActionListener(this);
        this.btnBrowse = new JButton("Browse");
        this.btnBrowse.addActionListener(this);
        northpanel2A.add((Component)this.btnBrowse, "East");
        if (Config.logDirFromPassedParam) {
            this.txtLogFileDirectory.setEnabled(false);
            this.btnBrowse.setVisible(false);
            JLabel lblPassedParam = new JLabel("  (Fixed at Startup)");
            northpanel2A.add((Component)lblPassedParam, "East");
        }
        JLabel lblArchiveDir = new JLabel("Archive directory");
        lblArchiveDir.setToolTipText("This sets the folder where the directory will be arvhived to once it is too large");
        lblArchiveDir.setBorder(new EmptyBorder(5, 2, 5, 5));
        northpanel2B.add((Component)lblArchiveDir, "West");
        this.txtArchiveDirectory = new JTextField(Config.get("archive_dir"));
        northpanel2B.add((Component)this.txtArchiveDirectory, "Center");
        this.txtArchiveDirectory.setColumns(30);
        this.txtArchiveDirectory.addActionListener(this);
        this.btnBrowseArchive = new JButton("Browse");
        this.btnBrowseArchive.addActionListener(this);
        northpanel2B.add((Component)this.btnBrowseArchive, "East");
        TitledBorder eastTitle1 = this.title("Files and Directories");
        northpanel.setBorder(eastTitle1);
        JPanel centerpanel = new JPanel();
        this.contentPane.add((Component)centerpanel, "Center");
        centerpanel.setLayout(new BoxLayout(centerpanel, 0));
        JPanel leftcolumnpanel = new JPanel();
        centerpanel.add(leftcolumnpanel);
        leftcolumnpanel.setLayout(new BoxLayout(leftcolumnpanel, 1));
        this.serverPanel = this.addColumn(leftcolumnpanel, 6);
        TitledBorder eastTitle2 = this.title("Ground Station Params");
        this.serverPanel.setBorder(eastTitle2);
        this.txtCallsign = this.addSettingsRow(this.serverPanel, 15, "Groundstation Name", "Ground station name is the unique identifier that you will use to store data on the telemetry server", Config.get("callsign"));
        this.txtLatitude = this.addSettingsRow(this.serverPanel, 10, "Lat (S is -ve)", "Latitude / Longitude or Locator need to be specified if you supply decoded data to the server", Config.get("latitude"));
        this.txtLongitude = this.addSettingsRow(this.serverPanel, 10, "Long (W is -ve)", "Latitude / Longitude or Locator need to be specified if you supply decoded data to the server", Config.get("longitude"));
        JPanel locatorPanel = new JPanel();
        JLabel lblLoc = new JLabel("Lat Long gives Locator: ");
        this.txtMaidenhead = new JTextField(Config.get("maidenhead_loc"));
        this.txtMaidenhead.addActionListener(this);
        this.txtMaidenhead.addFocusListener(this);
        this.txtMaidenhead.setColumns(10);
        this.serverPanel.add(locatorPanel);
        locatorPanel.add(lblLoc);
        locatorPanel.add(this.txtMaidenhead);
        this.txtAltitude = this.addSettingsRow(this.serverPanel, 15, "Altitude (m)", "Altitude will be supplied to the server along with your data if you specify it", Config.get("altitude"));
        this.txtStation = this.addSettingsRow(this.serverPanel, 15, "RF-Receiver Description", "RF-Receiver can be specified to give us an idea of the types of stations that are in operation", Config.get("station_details"));
        this.serverPanel.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        JPanel leftcolumnpanel3 = this.addColumn(leftcolumnpanel, 6);
        TitledBorder tncTitle = this.title("TNC");
        leftcolumnpanel3.setBorder(tncTitle);
        JPanel buttons = new JPanel();
        leftcolumnpanel3.add(buttons);
        JLabel lblInterface = new JLabel("Interface: ");
        buttons.add(lblInterface);
        this.rbTcpTncInterface = new JRadioButton("TCP");
        this.rbSerialTncInterface = new JRadioButton("Serial");
        this.rbTcpTncInterface.addActionListener(this);
        this.rbSerialTncInterface.addActionListener(this);
        buttons.add(this.rbSerialTncInterface);
        buttons.add(this.rbTcpTncInterface);
        ButtonGroup groupInterface = new ButtonGroup();
        groupInterface.add(this.rbSerialTncInterface);
        groupInterface.add(this.rbTcpTncInterface);
        this.leftcolumnpanelTCP = new JPanel();
        this.leftcolumnpanelTCP.setLayout(new BoxLayout(this.leftcolumnpanelTCP, 1));
        this.leftcolumnpanelSerial = new JPanel();
        this.leftcolumnpanelSerial.setLayout(new BoxLayout(this.leftcolumnpanelSerial, 1));
        leftcolumnpanel3.add(this.leftcolumnpanelTCP);
        leftcolumnpanel3.add(this.leftcolumnpanelSerial);
        this.txtHostname = this.addSettingsRow(this.leftcolumnpanelTCP, 15, "TCP Hostname", "Hostname where the TNC program is running", Config.get("tnc_tcp_hostname"));
        this.txtTcpPort = this.addSettingsRow(this.leftcolumnpanelTCP, 15, "TCP Port", "TCP Port that the TNC program is listening on for KISS data", Config.get("tnc_tcp_port"));
        String[] ports = SerialTncDecoder.getSerialPorts();
        if (ports == null) {
            ports = new String[]{NONE};
        }
        this.cbTncComPort = this.addComboBoxRow(this.leftcolumnpanelSerial, "Com Port", "The Serial Port (virtual or otherwise) that your TNC is on", ports);
        this.setSelection(this.cbTncComPort, ports, Config.get("COM_PORT"));
        this.cbTncBaudRate = this.addComboBoxRow(this.leftcolumnpanelSerial, "Baud Rate", "The baud rate for the serial port. This is not the baud rate for communication to the spacecraft.  Just the rate for connection to the TNC.", SerialTncDecoder.getAvailableBaudRates());
        this.setSelection(this.cbTncBaudRate, SerialTncDecoder.getAvailableBaudRates(), Config.get("TNC_BAUD_RATE"));
        this.cbToggleKiss = this.addCheckBoxRow(this.leftcolumnpanelSerial, "Toggle TNC in/out of KISS Mode", "Toggle TNC in/out of KISS mode at start/top.  Uncheck to leave in Kiss mode.", Config.getBoolean("toggle_kiss"));
        this.cbSendCustomBytes = this.addCheckBoxRow(this.leftcolumnpanelSerial, "Send TNC custom bytes at startup", "Send user defined bytes to toggle TNC in/out of KISS mode at start/top.", Config.getBoolean("send_user_defined_tnc_bytes"));
        this.customByteButtons = new JPanel();
        this.leftcolumnpanelSerial.add(this.customByteButtons);
        JLabel lblEdit = new JLabel("Edit: ");
        this.customByteButtons.add(lblEdit);
        this.rbTextEdit = new JRadioButton("Text");
        this.rbBytesEdit = new JRadioButton("Bytes");
        this.rbTextEdit.addActionListener(this);
        this.rbBytesEdit.addActionListener(this);
        this.customByteButtons.add(this.rbTextEdit);
        this.customByteButtons.add(this.rbBytesEdit);
        ButtonGroup groupInterface2 = new ButtonGroup();
        groupInterface2.add(this.rbTextEdit);
        groupInterface2.add(this.rbBytesEdit);
        if (Config.getBoolean("edit_kiss_bytes")) {
            this.rbBytesEdit.setSelected(true);
            this.rbTextEdit.setSelected(false);
        } else {
            this.rbBytesEdit.setSelected(false);
            this.rbTextEdit.setSelected(true);
        }
        this.panelBytes = new JPanel();
        this.leftcolumnpanelSerial.add(this.panelBytes);
        this.panelBytes.setLayout(new BorderLayout(5, 5));
        this.panelBytes.add((Component)new JLabel("Send these bytes to TNC at startup"), "North");
        this.txtTextAtStart = new JTextArea(SettingsFrame.byteToString(Config.get("kiss_bytes_at_start")));
        this.panelBytes.add((Component)this.txtTextAtStart, "West");
        this.txtTextAtStart.setToolTipText("Send this text when TNC toggled into KISS Mode");
        this.txtTextAtStart.setLineWrap(true);
        this.txtTextAtStart.setWrapStyleWord(true);
        this.txtTextAtStart.addFocusListener(this);
        this.txtBytesAtStart = new JTextArea(Config.get("kiss_bytes_at_start"));
        this.panelBytes.add((Component)this.txtBytesAtStart, "Center");
        this.txtBytesAtStart.setLineWrap(true);
        this.txtBytesAtStart.setWrapStyleWord(true);
        this.txtBytesAtStart.setToolTipText("Send these bytes when TNC toggled into KISS Mode");
        this.txtBytesAtStart.addFocusListener(this);
        this.panelBytes2 = new JPanel();
        this.leftcolumnpanelSerial.add(this.panelBytes2);
        this.panelBytes2.setLayout(new BorderLayout(5, 5));
        this.panelBytes2.add((Component)new JLabel("Send these bytes to TNC at exit"), "North");
        this.txtTextAtEnd = new JTextArea(SettingsFrame.byteToString(Config.get("kiss_bytes_at_end")));
        this.panelBytes2.add((Component)this.txtTextAtEnd, "West");
        this.txtTextAtEnd.setToolTipText("Send this text to TNC when program ends");
        this.txtTextAtEnd.setLineWrap(true);
        this.txtTextAtEnd.setWrapStyleWord(true);
        this.txtTextAtEnd.addFocusListener(this);
        this.txtBytesAtEnd = new JTextArea(Config.get("kiss_bytes_at_end"));
        this.panelBytes2.add((Component)this.txtBytesAtEnd, "Center");
        this.txtBytesAtEnd.setLineWrap(true);
        this.txtBytesAtEnd.setWrapStyleWord(true);
        this.txtBytesAtEnd.setToolTipText("Send these bytes to TNC when program ends");
        this.txtBytesAtEnd.addFocusListener(this);
        this.setBytesEditable(Config.getBoolean("edit_kiss_bytes"));
        this.txtTxDelay = this.addSettingsRow(leftcolumnpanel3, 5, "TX Delay", "Delay between keying the radio and sending data. Implemented by the TNC.", "" + Config.getInt("TNC_TX_DELAY"));
        this.tcp = Config.getBoolean("kiss_tcp_interface");
        this.showTncSettings();
        leftcolumnpanel3.add(new Box.Filler(new Dimension(200, 10), new Dimension(150, 400), new Dimension(500, 500)));
        JPanel rightcolumnpanel = new JPanel();
        centerpanel.add(rightcolumnpanel);
        rightcolumnpanel.setLayout(new BoxLayout(rightcolumnpanel, 1));
        JPanel rightcolumnpanel0 = this.addColumn(rightcolumnpanel, 3);
        rightcolumnpanel0.setLayout(new BoxLayout(rightcolumnpanel0, 1));
        TitledBorder eastTitle4 = this.title("Options");
        rightcolumnpanel0.setBorder(eastTitle4);
        this.cbUploadToServer = this.addCheckBoxRow(rightcolumnpanel0, "Send Server Telemetry", "Select this if you want to send your collected data to the Server telemetry server", Config.getBoolean("send_to_server"));
        this.cbLogging = this.addCheckBoxRow(rightcolumnpanel0, "Enable Logging", "Log events to a log file for debugging", Config.getBoolean("logging"));
        this.cbLogKiss = this.addCheckBoxRow(rightcolumnpanel0, "Log KISS", "Log KISS Bytes to a log file", Config.getBoolean("kiss_logging"));
        this.cbShowDirTimes = this.addCheckBoxRow(rightcolumnpanel0, "Show Dir Times", "Show the old and new times in the directory file table", Config.getBoolean("SHOW_DIR_TIMES"));
        this.cbTxInhibit = this.addCheckBoxRow(rightcolumnpanel0, "Inhibit Transmitter", "Prevent the transmission of byte to the TNC", Config.getBoolean("tx_inhibit"));
        this.cbDebugLayer2 = this.addCheckBoxRow(rightcolumnpanel0, "Debug Layer 2", "Select to print out debug for AX25 Layer 2", Config.getBoolean("DEBUG_LAYER2"));
        this.cbDebugLayer3 = this.addCheckBoxRow(rightcolumnpanel0, "Debug Uplink", "Select to print out debug for Uplink State Machine", Config.getBoolean("DEBUG_LAYER3"));
        this.cbDebugDownlink = this.addCheckBoxRow(rightcolumnpanel0, "Debug Downlink", "Select to print out debug for Downlink State Machine", Config.getBoolean("DEBUG_DOWNLINK"));
        this.cbDebugTelem = this.addCheckBoxRow(rightcolumnpanel0, "Debug Telem", "Select to print out debug for telemetry", Config.getBoolean("DEBUG_TELEM"));
        this.cbDebugTx = this.addCheckBoxRow(rightcolumnpanel0, "Debug Tx", "Select to print out debug for TNC transmissions", Config.getBoolean("DEBUG_TX"));
        this.cbKeepCaretAtEndOfLog = this.addCheckBoxRow(rightcolumnpanel0, "Force Log window to scroll to end", "Each time text is added to the log window, scroll to the end and show it", Config.getBoolean("keep_caret_at_end_of_log"));
        int size = Config.getInt("font_size");
        this.txtFontSize = this.addSettingsRow(rightcolumnpanel0, 5, "Font Size", "Font size for the window", "" + size);
        if (size == 0) {
            Font f = this.cbKeepCaretAtEndOfLog.getFont();
            size = f.getSize();
        }
        rightcolumnpanel0.add(new Box.Filler(new Dimension(10, 10), new Dimension(150, 400), new Dimension(500, 500)));
        rightcolumnpanel.add(new Box.Filler(new Dimension(10, 10), new Dimension(100, 400), new Dimension(100, 500)));
        this.enableDependentParams();
        this.setBytesPanelEnabled(Config.getBoolean("send_user_defined_tnc_bytes"));
    }

    public void setBytesEditable(boolean b) {
        this.txtBytesAtStart.setEnabled(b);
        this.txtBytesAtEnd.setEnabled(b);
        this.txtTextAtStart.setEnabled(!b);
        this.txtTextAtEnd.setEnabled(!b);
        if (b) {
            this.txtBytesAtStart.getDocument().addDocumentListener(this);
            this.txtBytesAtEnd.getDocument().addDocumentListener(this);
            this.txtTextAtStart.getDocument().removeDocumentListener(this);
            this.txtTextAtEnd.getDocument().removeDocumentListener(this);
        } else {
            this.txtBytesAtStart.getDocument().removeDocumentListener(this);
            this.txtBytesAtEnd.getDocument().removeDocumentListener(this);
            this.txtTextAtStart.getDocument().addDocumentListener(this);
            this.txtTextAtEnd.getDocument().addDocumentListener(this);
        }
    }

    private void setBytesPanelEnabled(boolean b) {
        this.customByteButtons.setVisible(b);
        this.panelBytes.setVisible(b);
        this.panelBytes2.setVisible(b);
        this.txtBytesAtStart.setVisible(b);
        this.txtBytesAtEnd.setVisible(b);
        this.txtTextAtStart.setVisible(b);
        this.txtTextAtEnd.setVisible(b);
    }

    private void setKissBytesEnabled(boolean b) {
        this.txtBytesAtStart.setEnabled(b);
        this.txtBytesAtEnd.setEnabled(b);
        this.txtTextAtStart.setEnabled(b);
        this.txtTextAtEnd.setEnabled(b);
    }

    public static String byteToString(String bytes) {
        String[] by;
        String s = "";
        String[] stringArray = by = bytes.split("\\s+");
        int n = by.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            char ch = '\u03e7';
            try {
                ch = (char)Integer.parseUnsignedInt(c, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (ch != '\u03e7') {
                s = String.valueOf(s) + ch;
            }
            ++n2;
        }
        return s;
    }

    public static int[] stringToBytes(String str) {
        String[] byString = str.split("\\s+");
        int[] by = new int[byString.length];
        int i2 = 0;
        String[] stringArray = byString;
        int n = byString.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            int ch = 999;
            try {
                ch = (char)Integer.parseUnsignedInt(c, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (ch != 999) {
                by[i2] = ch;
            }
            ++i2;
            ++n2;
        }
        return by;
    }

    public static String stringToByteString(String str) {
        String s = "";
        int i2 = 0;
        while (i2 < str.length()) {
            char c = str.charAt(i2);
            String ch = "";
            try {
                ch = Integer.toHexString(c);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!ch.equalsIgnoreCase("")) {
                if ((ch = ch.toUpperCase()).length() == 1) {
                    ch = "0" + ch;
                }
                s = i2 == str.length() - 1 ? String.valueOf(s) + ch : String.valueOf(s) + ch + " ";
            }
            ++i2;
        }
        return s;
    }

    private void setSelection(JComboBox comboBox, String[] values, String value) {
        int i2 = 0;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String rate = stringArray[n2];
            if (rate.equalsIgnoreCase(value)) break;
            ++i2;
            ++n2;
        }
        if (i2 >= values.length) {
            i2 = 0;
        }
        comboBox.setSelectedIndex(i2);
    }

    public void saveProperties() {
        Config.set(SETTINGS_WINDOW_HEIGHT, this.getHeight());
        Config.set(SETTINGS_WINDOW_WIDTH, this.getWidth());
        Config.set(SETTINGS_WINDOW_X, this.getX());
        Config.set(SETTINGS_WINDOW_Y, this.getY());
        Config.save();
    }

    public void loadProperties() {
        if (Config.getInt(SETTINGS_WINDOW_X) == 0) {
            Config.set(SETTINGS_WINDOW_X, 100);
            Config.set(SETTINGS_WINDOW_Y, 100);
            Config.set(SETTINGS_WINDOW_WIDTH, 600);
            Config.set(SETTINGS_WINDOW_HEIGHT, 650);
        }
        this.setBounds(Config.getInt(SETTINGS_WINDOW_X), Config.getInt(SETTINGS_WINDOW_Y), Config.getInt(SETTINGS_WINDOW_WIDTH), Config.getInt(SETTINGS_WINDOW_HEIGHT));
    }

    private TitledBorder title(String s) {
        TitledBorder title = new TitledBorder(null, s, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        return title;
    }

    private boolean validLatLong() {
        float lon;
        float lat;
        block5: {
            lat = 0.0f;
            lon = 0.0f;
            try {
                lat = Float.parseFloat(this.txtLatitude.getText());
                lon = Float.parseFloat(this.txtLongitude.getText());
                if (lat != Float.parseFloat("0.0") && !this.txtLatitude.getText().equals("")) break block5;
                return false;
            }
            catch (NumberFormatException n) {
                JOptionPane.showMessageDialog(this, "Only numerical values are valid for the latitude and longitude.", "Format Error\n", 0);
                return false;
            }
        }
        if (lon == Float.parseFloat("0.0") || this.txtLongitude.getText().equals("")) {
            return false;
        }
        if (Float.isNaN(lon) || Math.abs(lon) > 180.0f || Float.isNaN(lat) || (double)Math.abs(lat) == 90.0 || Math.abs(lat) > 90.0f) {
            JOptionPane.showMessageDialog(this, "Invalid latitude or longitude.", "Error\n", 0);
            return false;
        }
        return true;
    }

    private boolean validLocator() {
        if (this.txtMaidenhead.getText().equalsIgnoreCase("XX00xx") || this.txtMaidenhead.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Enter a latitude/longitude or set the locator to a valid value", "Format Error\n", 0);
            return false;
        }
        return true;
    }

    private boolean validAltitude() {
        int alt = 0;
        try {
            alt = Integer.parseInt(this.txtAltitude.getText());
        }
        catch (NumberFormatException n) {
            JOptionPane.showMessageDialog(this, "Only integer values are valid for the altitude. Specify it to the nearest meter, but with no units.", "Format Error\n", 0);
            return false;
        }
        if (alt < 0 || alt > 8484) {
            JOptionPane.showMessageDialog(this, "Invalid altitude.  Must be between 0 and 8484m.", "Format Error\n", 0);
            return false;
        }
        return true;
    }

    private void updateLocator() throws Exception {
        if (this.validLatLong()) {
            Location l = new Location(this.txtLatitude.getText(), this.txtLongitude.getText());
            this.txtMaidenhead.setText(l.maidenhead);
        }
    }

    private void updateLatLong() throws Exception {
        if (this.validLocator()) {
            Location l = new Location(this.txtMaidenhead.getText());
            this.txtLatitude.setText(Float.toString(l.latitude));
            this.txtLongitude.setText(Float.toString(l.longitude));
        }
    }

    private void enableDependentParams() {
        if (this.validLatLong() && this.validAltitude()) {
            if (this.validCallsign()) {
                this.cbUploadToServer.setEnabled(true);
            } else {
                this.cbUploadToServer.setEnabled(false);
            }
        } else {
            this.cbUploadToServer.setEnabled(false);
        }
    }

    private boolean validCallsign() {
        return !this.txtCallsign.getText().equalsIgnoreCase(NONE) && !this.txtCallsign.getText().equals("");
    }

    private boolean validServerParams() {
        if (!this.validCallsign()) {
            return false;
        }
        if (!this.validLocator()) {
            return false;
        }
        if (!this.validLatLong()) {
            return false;
        }
        return this.validAltitude();
    }

    private JPanel addColumn(JPanel parent, int rows) {
        JPanel columnpanel = new JPanel();
        parent.add(columnpanel);
        columnpanel.setLayout(new BoxLayout(columnpanel, 1));
        return columnpanel;
    }

    private JCheckBox addCheckBoxRow(JPanel parent, String name, String tip, boolean value) {
        JCheckBox checkBox = new JCheckBox(name);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        parent.add(checkBox);
        if (value) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
        return checkBox;
    }

    private JComboBox addComboBoxRow(JPanel parent, String name, String tip, String[] values) {
        JPanel row = new JPanel();
        row.setLayout(new GridLayout(1, 2, 5, 5));
        JLabel lbl = new JLabel(name);
        JComboBox<String> checkBox = new JComboBox<String>(values);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        lbl.setToolTipText(tip);
        row.add(lbl);
        row.add(checkBox);
        parent.add(row);
        parent.add(new Box.Filler(new Dimension(10, 5), new Dimension(10, 5), new Dimension(10, 5)));
        return checkBox;
    }

    private JTextArea addSettingsBytesText(JPanel column, JLabel lblTranslation, int length, String name, String tip, String value) {
        JPanel panel = new JPanel();
        column.add(panel);
        panel.setLayout(new BorderLayout(5, 5));
        JLabel lblDisplayModuleFont = new JLabel(name);
        lblDisplayModuleFont.setToolTipText(tip);
        panel.add((Component)lblDisplayModuleFont, "North");
        JTextArea textField = new JTextArea(value);
        panel.add((Component)lblTranslation, "West");
        panel.add((Component)textField, "Center");
        textField.setColumns(length);
        textField.addFocusListener(this);
        textField.getDocument().addDocumentListener(this);
        column.add(new Box.Filler(new Dimension(10, 5), new Dimension(10, 5), new Dimension(10, 5)));
        return textField;
    }

    private JTextField addSettingsRow(JPanel column, int length, String name, String tip, String value) {
        JPanel panel = new JPanel();
        column.add(panel);
        panel.setLayout(new GridLayout(1, 2, 5, 5));
        JLabel lblDisplayModuleFont = new JLabel(name);
        lblDisplayModuleFont.setToolTipText(tip);
        panel.add(lblDisplayModuleFont);
        JTextField textField = new JTextField(value);
        panel.add(textField);
        textField.setColumns(length);
        textField.addActionListener(this);
        textField.addFocusListener(this);
        column.add(new Box.Filler(new Dimension(10, 5), new Dimension(10, 5), new Dimension(10, 5)));
        return textField;
    }

    void showTncSettings() {
        this.rbTcpTncInterface.setSelected(this.tcp);
        this.leftcolumnpanelTCP.setVisible(this.tcp);
        this.leftcolumnpanelSerial.setVisible(!this.tcp);
        this.rbSerialTncInterface.setSelected(!this.tcp);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String path;
        int returnVal;
        if (e.getSource() == this.btnCancel) {
            this.dispose();
        }
        if (e.getSource() == this.txtLatitude || e.getSource() == this.txtLongitude) {
            try {
                this.updateLocator();
            }
            catch (Exception e1) {
                Log.errorDialog("ERROR", e1.getMessage());
            }
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtMaidenhead) {
            try {
                this.updateLatLong();
            }
            catch (Exception e1) {
                Log.errorDialog("ERROR", e1.getMessage());
            }
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtAltitude) {
            this.validAltitude();
            this.enableDependentParams();
        }
        if (e.getSource() == this.btnSave) {
            boolean dispose = true;
            Config.set("callsign", this.txtCallsign.getText().toUpperCase());
            Log.println("Setting callsign: " + Config.get("callsign"));
            if (this.validLatLong()) {
                Config.set("latitude", this.txtLatitude.getText());
                Config.set("longitude", this.txtLongitude.getText());
            } else {
                dispose = this.txtLatitude.getText().equalsIgnoreCase("0.0") && this.txtLongitude.getText().equalsIgnoreCase("0.0");
            }
            if (this.validLocator()) {
                Config.set("maidenhead_loc", this.txtMaidenhead.getText());
            } else {
                dispose = false;
            }
            if (this.validAltitude()) {
                Config.set("altitude", this.txtAltitude.getText());
            } else {
                dispose = false;
            }
            Config.set("station_details", this.txtStation.getText());
            int rate = Integer.parseInt(SerialTncDecoder.getAvailableBaudRates()[this.cbTncBaudRate.getSelectedIndex()]);
            int port_idx = this.cbTncComPort.getSelectedIndex();
            String port_name = (String)this.cbTncComPort.getSelectedItem();
            String port = NONE;
            if (!port_name.equalsIgnoreCase(NONE)) {
                port = SerialTncDecoder.getSerialPorts()[port_idx];
            }
            int delay = Integer.parseInt(this.txtTxDelay.getText());
            if (this.rbSerialTncInterface.isSelected() && (!Config.get("COM_PORT").equalsIgnoreCase(port) || Config.getInt("TNC_BAUD_RATE") != rate || Config.getInt("TNC_TX_DELAY") != delay)) {
                Log.infoDialog("RESTART REQUIRED", "New COM port params.  Restart the Ground Station to configure and to correctly initialize the TNC");
            }
            int p = Config.getInt("tnc_tcp_port");
            try {
                p = Integer.parseInt(this.txtTcpPort.getText());
            }
            catch (NumberFormatException n) {
                Log.errorDialog("ERROR", "TCP Port needs to be numeric.  Setting it to: " + p);
            }
            if (this.tcp != Config.getBoolean("kiss_tcp_interface")) {
                Log.infoDialog("TNC Interface Changed", "You will need to restart the program for the TNC interface to be changed");
            }
            Config.set("kiss_tcp_interface", this.tcp);
            if (this.tcp) {
                Config.set("tnc_tcp_hostname", this.txtHostname.getText());
                Config.set("tnc_tcp_port", p);
            } else {
                Config.set("COM_PORT", port);
                Config.set("TNC_BAUD_RATE", rate);
            }
            Config.set("TNC_TX_DELAY", delay);
            Config.set("kiss_bytes_at_start", this.txtBytesAtStart.getText());
            Config.set("kiss_bytes_at_end", this.txtBytesAtEnd.getText());
            Config.set("send_to_server", this.cbUploadToServer.isSelected());
            Config.set("logging", this.cbLogging.isSelected());
            if (Config.getBoolean("SHOW_DIR_TIMES") != this.cbShowDirTimes.isSelected()) {
                Log.infoDialog("RESTART REQUIRED", "DIR times Enabled.  Restart the Ground Station to update the directory file table columns for old and new times.");
            }
            Config.set("SHOW_DIR_TIMES", this.cbShowDirTimes.isSelected());
            if (Config.getBoolean("kiss_logging") != this.cbLogKiss.isSelected()) {
                Log.infoDialog("RESTART REQUIRED", "KISS Logging Enabled.  Restart the Ground Station to configure and to correctly initialize the decoder for KISS logging");
            }
            Config.set("kiss_logging", this.cbLogKiss.isSelected());
            Config.set("tx_inhibit", this.cbTxInhibit.isSelected());
            Config.set("DEBUG_LAYER2", this.cbDebugLayer2.isSelected());
            Config.set("DEBUG_LAYER3", this.cbDebugLayer3.isSelected());
            Config.set("DEBUG_DOWNLINK", this.cbDebugDownlink.isSelected());
            Config.set("DEBUG_TELEM", this.cbDebugTelem.isSelected());
            Config.set("DEBUG_TX", this.cbDebugTx.isSelected());
            Config.set("toggle_kiss", this.cbToggleKiss.isSelected());
            Config.set("send_user_defined_tnc_bytes", this.cbSendCustomBytes.isSelected());
            Config.set("keep_caret_at_end_of_log", this.cbKeepCaretAtEndOfLog.isSelected());
            int fontSize = Integer.parseInt(this.txtFontSize.getText());
            if (fontSize != Config.getInt("font_size")) {
                Log.infoDialog("RESTART REQUIRED", "Font Size changed.  Restart the Ground Station to see the changes.");
            }
            Config.set("font_size", fontSize);
            if (!Config.get("archive_dir").equalsIgnoreCase(this.txtArchiveDirectory.getText())) {
                String archiveDirFolder = this.txtArchiveDirectory.getText();
                File dir = new File(archiveDirFolder);
                if (!dir.exists() && !Directory.makeDir(archiveDirFolder)) {
                    dispose = false;
                    return;
                }
                if (this.txtArchiveDirectory.getText().equalsIgnoreCase(".")) {
                    this.txtArchiveDirectory.setText("");
                }
                File file = new File(this.txtArchiveDirectory.getText());
                if (this.txtArchiveDirectory.getText().equalsIgnoreCase("")) {
                    Log.errorDialog("Invalid archive directory", "Can not archive into the same folder as the current data: " + this.txtArchiveDirectory.getText());
                    dispose = false;
                } else if (!file.isDirectory() || file == null || !file.exists()) {
                    Log.errorDialog("Invalid archive directory", "Can not find the specified directory: " + this.txtArchiveDirectory.getText());
                    dispose = false;
                } else {
                    Config.set("archive_dir", this.txtArchiveDirectory.getText());
                    Log.println("Setting archive to: " + Config.get("archive_dir"));
                }
            }
            if (!Config.get("logfile_dir").equalsIgnoreCase(this.txtLogFileDirectory.getText())) {
                boolean currentDir = false;
                if (this.txtLogFileDirectory.getText().equalsIgnoreCase(".")) {
                    this.txtLogFileDirectory.setText("");
                }
                if (this.txtLogFileDirectory.getText().equalsIgnoreCase("")) {
                    currentDir = true;
                }
                File file = new File(this.txtLogFileDirectory.getText());
                if (!(currentDir || file.isDirectory() && file != null && file.exists())) {
                    Log.errorDialog("Invalid directory", "Can not find the specified directory: " + this.txtLogFileDirectory.getText());
                    dispose = false;
                } else {
                    Object[] options = new Object[]{"Yes", "No"};
                    int n = JOptionPane.showOptionDialog(MainWindow.frame, "Do you want to switch log file directories?", "Do you want to continue?", 0, 3, null, options, options[1]);
                    if (n == 0) {
                        try {
                            for (SpacecraftSettings sat : Config.spacecraftSettings) {
                                sat.directory.save();
                            }
                            String prev = Config.get("logfile_dir");
                            Config.set("logfile_dir", this.txtLogFileDirectory.getText());
                            Log.println("Setting log file directory to: " + Config.get("logfile_dir"));
                            Config.close();
                            try {
                                Config.start();
                            }
                            catch (LayoutLoadException e1) {
                                Log.errorDialog("ERROR", "Can re-load the layouts: " + e1.getMessage());
                            }
                            catch (IOException e1) {
                                Log.errorDialog("ERROR", "Re-initializing the config: " + e1.getMessage());
                            }
                            Config.mainWindow.updateLogfileDir();
                        }
                        catch (IOException e2) {
                            Log.errorDialog("ERROR", "Could not save the existing directory, abandoning switch\n" + e2.getMessage());
                        }
                    }
                }
            }
            if (dispose) {
                Config.save();
                for (SpacecraftSettings sat : Config.spacecraftSettings) {
                    MainWindow.setDirectoryData(sat.name, sat.directory.getTableData());
                }
                this.dispose();
            }
        }
        if (e.getSource() == this.rbTcpTncInterface) {
            this.tcp = true;
            this.showTncSettings();
        }
        if (e.getSource() == this.rbSerialTncInterface) {
            this.tcp = false;
            this.showTncSettings();
        }
        if (e.getSource() == this.rbBytesEdit) {
            Config.set("edit_kiss_bytes", true);
            this.setBytesEditable(Config.getBoolean("edit_kiss_bytes"));
        }
        if (e.getSource() == this.rbTextEdit) {
            Config.set("edit_kiss_bytes", false);
            this.setBytesEditable(Config.getBoolean("edit_kiss_bytes"));
        }
        if (e.getSource() == this.btnBrowse) {
            File dir = null;
            if (!Config.get("logfile_dir").equalsIgnoreCase("")) {
                dir = new File(Config.get("logfile_dir"));
            }
            JFileChooser fc = new JFileChooser();
            fc.setApproveButtonText("Choose");
            if (dir != null) {
                fc.setCurrentDirectory(dir);
            }
            fc.setDialogTitle("Choose Directory for Log Files");
            fc.setFileSelectionMode(1);
            if (Config.getInt("mainwindow_width") == 0) {
                Config.set("mainwindow_width", 600);
                Config.set("mainwindow_height", 600);
            }
            fc.setPreferredSize(new Dimension(Config.getInt("mainwindow_width"), Config.getInt("mainwindow_height")));
            returnVal = fc.showOpenDialog(this);
            Config.set("mainwindow_height", fc.getHeight());
            Config.set("mainwindow_width", fc.getWidth());
            if (returnVal == 0) {
                path = fc.getSelectedFile().getAbsolutePath();
                if (!path.equals("")) {
                    path = String.valueOf(path) + File.separator;
                }
                this.txtLogFileDirectory.setText(path);
            } else {
                Log.println("No Selection ");
            }
        }
        if (e.getSource() == this.btnBrowseArchive) {
            File dir = null;
            if (!Config.get("archive_dir").equalsIgnoreCase("")) {
                dir = new File(Config.get("archive_dir"));
            }
            JFileChooser fc = new JFileChooser();
            fc.setApproveButtonText("Choose");
            if (dir != null) {
                fc.setCurrentDirectory(dir);
            }
            fc.setDialogTitle("Choose Directory for Archive");
            fc.setFileSelectionMode(1);
            if (Config.getInt("mainwindow_width") == 0) {
                Config.set("mainwindow_width", 600);
                Config.set("mainwindow_height", 600);
            }
            fc.setPreferredSize(new Dimension(Config.getInt("mainwindow_width"), Config.getInt("mainwindow_height")));
            returnVal = fc.showOpenDialog(this);
            Config.set("mainwindow_height", fc.getHeight());
            Config.set("mainwindow_width", fc.getWidth());
            if (returnVal == 0) {
                path = fc.getSelectedFile().getAbsolutePath();
                if (!path.equals("")) {
                    path = String.valueOf(path) + File.separator;
                }
                this.txtArchiveDirectory.setText(path);
            } else {
                Log.println("No Selection ");
            }
        }
    }

    private int parseDelayTextField(JTextField text) {
        int value = 0;
        try {
            value = Integer.parseInt(text.getText());
            if (value > 2550) {
                value = 2550;
                text.setText(Integer.toString(2550));
            }
            if (value < 0) {
                value = 0;
                text.setText(Integer.toString(0));
            }
        }
        catch (NumberFormatException ex) {
            text.setText(Integer.toString(0));
        }
        return value;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbUploadToServer) {
            e.getStateChange();
        }
        if (source == this.cbSendCustomBytes) {
            if (e.getStateChange() == 2) {
                this.setBytesPanelEnabled(false);
            } else {
                this.setBytesPanelEnabled(true);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.txtCallsign) {
            if (this.txtCallsign.getText().length() > 6) {
                this.txtCallsign.setText(this.txtCallsign.getText().substring(0, 6));
            }
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtTxDelay) {
            this.parseDelayTextField(this.txtTxDelay);
        }
        if (e.getSource() == this.txtStation && this.txtStation.getText().length() > 50) {
            this.txtStation.setText(this.txtStation.getText().substring(0, 50));
        }
        if (e.getSource() == this.txtLatitude || e.getSource() == this.txtLongitude) {
            try {
                this.updateLocator();
            }
            catch (Exception e1) {
                Log.errorDialog("ERROR", e1.getMessage());
            }
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtMaidenhead) {
            try {
                this.updateLatLong();
            }
            catch (Exception e1) {
                Log.errorDialog("ERROR", e1.getMessage());
            }
            this.enableDependentParams();
        }
        if (e.getSource() == this.txtAltitude) {
            this.validAltitude();
            this.enableDependentParams();
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.saveProperties();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                SettingsFrame.this.textAreasUpdated();
            }
        };
        SwingUtilities.invokeLater(update);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                SettingsFrame.this.textAreasUpdated();
            }
        };
        SwingUtilities.invokeLater(update);
    }

    private void textAreasUpdated() {
        if (Config.getBoolean("edit_kiss_bytes")) {
            this.txtTextAtStart.setText(SettingsFrame.byteToString(this.txtBytesAtStart.getText()));
            this.txtTextAtEnd.setText(SettingsFrame.byteToString(this.txtBytesAtEnd.getText()));
        } else {
            this.txtBytesAtStart.setText(SettingsFrame.stringToByteString(this.txtTextAtStart.getText()));
            this.txtBytesAtEnd.setText(SettingsFrame.stringToByteString(this.txtTextAtEnd.getText()));
        }
    }
}

