/*
 * Decompiled with CFR 0.152.
 */
package gui;

import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.DirSelectionEquation;
import gui.CommandFrame;
import gui.DirEquationFrame;
import gui.DirEquationTableModel;
import gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SpacecraftFrame
extends JDialog
implements ItemListener,
ActionListener,
FocusListener,
WindowListener,
MouseListener {
    private final JPanel contentPanel = new JPanel();
    JTextField name;
    JTextField telemetryDownlinkFreqkHz;
    JTextField minFreqBoundkHz;
    JTextField maxFreqBoundkHz;
    JTextField dirAge;
    JTextField maxHeaders;
    JCheckBox reqDir;
    JCheckBox reqDirHoles;
    JCheckBox reqFiles;
    JCheckBox reqFileHoles;
    JCheckBox uploadFiles;
    JCheckBox cbPsfHeaderCheckSums;
    JCheckBox cbCommandStation;
    JButton btnCancel;
    JButton btnSave;
    JButton butDirSelection;
    JButton butDelEquations;
    JButton butDelEquation;
    JButton butEditEquation;
    JButton btnBrowse;
    JTable tableEquations;
    DirEquationTableModel dirEquationTableModel;
    private JTextField txtPrimaryServer;
    private JTextField txtNoradId;
    private JTextField txtServerUrl;
    private JTextField txtKey;
    SpacecraftSettings spacecraftSettings;
    int headerSize = 12;
    public static final String SPACECRAFT_WINDOW_X = "spacecraft_window_x";
    public static final String SPACECRAFT_WINDOW_Y = "spacecraft_window_y";
    public static final String SPACECRAFT_WINDOW_WIDTH = "spacecraft_window_width";
    public static final String SPACECRAFT_WINDOW_HEIGHT = "spacecraft_window_height";

    public SpacecraftFrame(SpacecraftSettings spacecraftSettings, JFrame owner, boolean modal) {
        super((Frame)owner, modal);
        this.setTitle("Spacecraft paramaters");
        this.addWindowListener(this);
        this.spacecraftSettings = spacecraftSettings;
        this.setDefaultCloseOperation(2);
        this.loadProperties();
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.addFields();
        this.addButtons();
    }

    private void addFields() {
        JPanel titlePanel = new JPanel();
        this.contentPanel.add((Component)titlePanel, "North");
        titlePanel.setLayout(new FlowLayout(0));
        TitledBorder heading0 = this.title("Identification");
        titlePanel.setBorder(heading0);
        this.name = this.addSettingsRow(titlePanel, 15, "Name", "The name must be the same as the name in your TLE/Keps file if you want to calculate positions or sync with SatPC32", this.spacecraftSettings.name);
        titlePanel.add(this.name);
        this.name.setEnabled(false);
        JPanel leftPanel = new JPanel();
        this.contentPanel.add((Component)leftPanel, "West");
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel leftFixedPanel = new JPanel();
        leftFixedPanel.setLayout(new BoxLayout(leftFixedPanel, 1));
        leftPanel.add(leftFixedPanel);
        TitledBorder heading = this.title("Fixed Paramaters");
        leftFixedPanel.setBorder(heading);
        JLabel bbsCall = new JLabel("BBS Callsign: " + this.spacecraftSettings.get("bbsCallsign"));
        leftFixedPanel.add(bbsCall);
        JLabel broadcastCall = new JLabel("Broadcast Callsign: " + this.spacecraftSettings.get("broadcastCallsign"));
        leftFixedPanel.add(broadcastCall);
        JLabel digiCall = new JLabel("Digi-peter Callsign: " + this.spacecraftSettings.get("digiCallsign"));
        leftFixedPanel.add(digiCall);
        leftFixedPanel.add(new Box.Filler(new Dimension(10, 10), new Dimension(250, 200), new Dimension(500, 500)));
        this.txtServerUrl = this.addSettingsRow(leftFixedPanel, 20, "Website", "This sets the URL we use to fetch and download server data. Should not need to be changed", this.spacecraftSettings.get("web_site_url"));
        this.txtPrimaryServer = this.addSettingsRow(leftFixedPanel, 20, "Telem Server", "The address of the Telemetry server. Should not need to be changed", this.spacecraftSettings.get("telem_server"));
        this.txtNoradId = this.addSettingsRow(leftFixedPanel, 15, "Norad Id", "The id issued by Norad for this spacecraft or a temporary number from SatNogs", this.spacecraftSettings.get("norad_id"));
        JPanel leftPanel2 = new JPanel();
        leftPanel2.setLayout(new BoxLayout(leftPanel2, 1));
        leftPanel.add(leftPanel2);
        TitledBorder leftheading2 = this.title("Commanding");
        leftPanel2.setBorder(leftheading2);
        this.cbCommandStation = this.addCheckBoxRow("Command Station", "This ground station is able to command the spacecraft", this.spacecraftSettings.getBoolean("is_command_station"), leftPanel2);
        this.txtKey = this.addSettingsRow(leftPanel2, 15, "Command Key File", "The secret key to claculate the hash code for commands", this.spacecraftSettings.get("secret_key"));
        this.btnBrowse = new JButton("Browse");
        this.btnBrowse.addActionListener(this);
        leftPanel2.add((Component)this.btnBrowse, "East");
        leftPanel.add(new Box.Filler(new Dimension(10, 10), new Dimension(250, 500), new Dimension(500, 500)));
        JPanel rightPanel = new JPanel();
        this.contentPanel.add((Component)rightPanel, "Center");
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        JPanel rightPanel1 = new JPanel();
        rightPanel.add(rightPanel1);
        rightPanel1.setLayout(new BoxLayout(rightPanel1, 1));
        TitledBorder heading2 = this.title("Pass Actions");
        rightPanel1.setBorder(heading2);
        this.reqDir = this.addCheckBoxRow("Request Directory", "Request the directoty at the start of each pass", this.spacecraftSettings.getBoolean("request_directory"), rightPanel1);
        this.reqDirHoles = this.addCheckBoxRow("Fill Directory Holes", "Request holes in the directory", this.spacecraftSettings.getBoolean("fill_directory_holes"), rightPanel1);
        this.reqFiles = this.addCheckBoxRow("Request Files", "Request files that are marked for download", this.spacecraftSettings.getBoolean("request_files"), rightPanel1);
        this.uploadFiles = this.addCheckBoxRow("Upload Files", "Upload files to the server", this.spacecraftSettings.getBoolean("upload_files"), rightPanel1);
        if (!this.spacecraftSettings.getBoolean("supports_file_upload")) {
            this.uploadFiles.setSelected(false);
            this.uploadFiles.setEnabled(false);
        }
        this.cbPsfHeaderCheckSums = this.addCheckBoxRow("Check PSF Header Checksums", "Warn about files where the header or body checksums do not match", this.spacecraftSettings.getBoolean("psf_header_check_sums"), rightPanel1);
        this.cbPsfHeaderCheckSums.setEnabled(true);
        JPanel rightPanel3 = new JPanel();
        rightPanel1.add(rightPanel3);
        rightPanel3.add(new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(4000, 500)));
        JPanel rightPanel2 = new JPanel();
        rightPanel.add(rightPanel2);
        rightPanel2.setLayout(new BoxLayout(rightPanel2, 1));
        TitledBorder heading3 = this.title("Directory Settings");
        rightPanel2.setBorder(heading3);
        this.dirAge = this.addSettingsRow(rightPanel2, 25, "Oldest Files (days)", "The number of days back in time to request file headers when building the directory or filling holes", this.spacecraftSettings.get("DIR_AGE"));
        this.maxHeaders = this.addSettingsRow(rightPanel2, 25, "Archive limit (headers)", "The maximum number of headers to keep when the archive is run", "" + this.spacecraftSettings.getInt("number_dir_table_entries"));
        this.dirEquationTableModel = new DirEquationTableModel();
        this.tableEquations = new JTable(this.dirEquationTableModel);
        JScrollPane scrollPane = new JScrollPane(this.tableEquations);
        rightPanel2.add(scrollPane);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.tableEquations.setFillsViewportHeight(true);
        this.tableEquations.setAutoResizeMode(3);
        this.tableEquations.removeColumn(this.tableEquations.getColumnModel().getColumn(0));
        JPanel eqButtonsPanel = new JPanel();
        rightPanel2.add(eqButtonsPanel);
        this.butDirSelection = new JButton("Add");
        this.butEditEquation = new JButton("Edit");
        this.butDelEquation = new JButton("Delete");
        this.butDelEquations = new JButton("Delete All");
        eqButtonsPanel.add(this.butDirSelection);
        this.butDirSelection.addActionListener(this);
        eqButtonsPanel.add(this.butEditEquation);
        this.butEditEquation.addActionListener(this);
        eqButtonsPanel.add(this.butDelEquation);
        this.butDelEquation.addActionListener(this);
        eqButtonsPanel.add(this.butDelEquations);
        this.butDelEquations.addActionListener(this);
        this.updateDirEquations();
        rightPanel2.add(new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(400, 500)));
        JPanel footerPanel = new JPanel();
        TitledBorder heading9 = this.title("Description");
        footerPanel.setBorder(heading9);
        footerPanel.setLayout(new BorderLayout());
        JTextArea taDesc = new JTextArea(2, 45);
        taDesc.setText(this.spacecraftSettings.get("description"));
        taDesc.setLineWrap(true);
        taDesc.setWrapStyleWord(true);
        taDesc.setEditable(false);
        taDesc.setFont(new Font("SansSerif", 0, 12));
        footerPanel.add((Component)taDesc, "Center");
        this.contentPanel.add((Component)footerPanel, "South");
    }

    public void updateDirEquations() {
        String[][] data = this.spacecraftSettings.directory.getEquationsData();
        this.dirEquationTableModel.setData(data);
    }

    private TitledBorder title(String s) {
        TitledBorder title = new TitledBorder(null, s, 4, 2, null, null);
        title.setTitleFont(new Font("SansSerif", 1, 14));
        return title;
    }

    private void addButtons() {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        this.btnSave = new JButton("Save");
        this.btnSave.setActionCommand("Save");
        buttonPane.add(this.btnSave);
        this.btnSave.addActionListener(this);
        this.getRootPane().setDefaultButton(this.btnSave);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setActionCommand("Cancel");
        buttonPane.add(this.btnCancel);
        this.btnCancel.addActionListener(this);
    }

    private JCheckBox addCheckBoxRow(String name, String tip, boolean value, JPanel parent) {
        JCheckBox checkBox = new JCheckBox(name);
        checkBox.setEnabled(true);
        checkBox.addItemListener(this);
        checkBox.setToolTipText(tip);
        parent.add(checkBox);
        if (value) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
        return checkBox;
    }

    private JTextField addSettingsRow(JPanel column, int length, String name, String tip, String value) {
        JPanel panel = new JPanel();
        column.add(panel);
        panel.setLayout(new GridLayout(1, 2, 0, 5));
        JLabel lblDisplayModuleFont = new JLabel(name);
        lblDisplayModuleFont.setToolTipText(tip);
        panel.add(lblDisplayModuleFont);
        JTextField textField = new JTextField(value);
        panel.add(textField);
        textField.setColumns(length);
        textField.addActionListener(this);
        textField.addFocusListener(this);
        column.add(new Box.Filler(new Dimension(10, 5), new Dimension(10, 5), new Dimension(10, 5)));
        return textField;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        if (e.getSource() == this.btnCancel) {
            this.dispose();
        }
        if (e.getSource() == this.butDirSelection) {
            DirEquationFrame f = new DirEquationFrame(this.spacecraftSettings, (JFrame)this.getParent(), true, this);
            f.setVisible(true);
        }
        if (e.getSource() == this.butEditEquation && (row = this.tableEquations.getSelectedRow()) >= 0 && row < this.tableEquations.getRowCount()) {
            String id = (String)this.tableEquations.getModel().getValueAt(this.tableEquations.getSelectedRow(), 0);
            DirSelectionEquation equation = this.spacecraftSettings.directory.getEquation(id);
            DirEquationFrame f = new DirEquationFrame(this.spacecraftSettings, (JFrame)this.getParent(), true, this, equation);
            f.setVisible(true);
        }
        if (e.getSource() == this.butDelEquation && (row = this.tableEquations.getSelectedRow()) >= 0 && row < this.tableEquations.getRowCount()) {
            this.deleteRow(this.tableEquations, row);
        }
        if (e.getSource() == this.butDelEquations) {
            try {
                this.spacecraftSettings.directory.deleteEquations();
                this.updateDirEquations();
            }
            catch (IOException e1) {
                Log.errorDialog("ERROR", "Could not remove the equation file: " + e1.getMessage());
            }
        }
        if (e.getSource() == this.btnBrowse) {
            File dir = null;
            if (!Config.get("logfile_dir").equalsIgnoreCase("")) {
                dir = new File(Config.get("logfile_dir"));
            }
            JFileChooser fc = new JFileChooser();
            fc.setApproveButtonText("Choose");
            if (dir != null) {
                fc.setCurrentDirectory(dir);
            }
            fc.setDialogTitle("Choose Command Key");
            fc.setFileSelectionMode(0);
            if (Config.getInt("mainwindow_width") == 0) {
                Config.set("mainwindow_width", 600);
                Config.set("mainwindow_height", 600);
            }
            fc.setPreferredSize(new Dimension(Config.getInt("mainwindow_width"), Config.getInt("mainwindow_height")));
            int returnVal = fc.showOpenDialog(this);
            Config.set("mainwindow_height", fc.getHeight());
            Config.set("mainwindow_width", fc.getWidth());
            if (returnVal == 0) {
                String path = fc.getSelectedFile().getPath();
                this.txtKey.setText(path);
            } else {
                Log.println("No Selection ");
            }
        }
        if (e.getSource() == this.btnSave) {
            boolean dispose = true;
            try {
                try {
                    int age = Integer.parseInt(this.dirAge.getText());
                    if (age < 0) {
                        this.dirAge.setText("1");
                        throw new NumberFormatException("The Directory Age must contain a valid number from 1-99");
                    }
                    if (age > 99) {
                        this.dirAge.setText("99");
                        throw new NumberFormatException("The Directory Age must contain a valid number from 1-99");
                    }
                    this.spacecraftSettings.set("DIR_AGE", age);
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("The Directory Age must contain a valid number from 1-99");
                }
                try {
                    int num = Integer.parseInt(this.maxHeaders.getText());
                    if (num < 0) {
                        this.maxHeaders.setText("1");
                        throw new NumberFormatException("The Number of headers must contain a valid number from 1-9999");
                    }
                    if (num > 9999) {
                        this.maxHeaders.setText("9999");
                        throw new NumberFormatException("The Number of headers must contain a valid number from 1-9999");
                    }
                    this.spacecraftSettings.set("number_dir_table_entries", num);
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("The Number of headers must contain a valid number from 1-9999");
                }
                if (dispose) {
                    this.spacecraftSettings.set("request_directory", this.reqDir.isSelected());
                    this.spacecraftSettings.set("fill_directory_holes", this.reqDirHoles.isSelected());
                    this.spacecraftSettings.set("request_files", this.reqFiles.isSelected());
                    this.spacecraftSettings.set("upload_files", this.uploadFiles.isSelected());
                    this.spacecraftSettings.set("psf_header_check_sums", this.cbPsfHeaderCheckSums.isSelected());
                    this.spacecraftSettings.set("telem_server", this.txtPrimaryServer.getText());
                    this.spacecraftSettings.set("norad_id", this.txtNoradId.getText());
                    this.spacecraftSettings.set("web_site_url", this.txtServerUrl.getText());
                    if (this.cbCommandStation.isSelected() != this.spacecraftSettings.getBoolean("is_command_station")) {
                        Log.infoDialog("RESTART REQUIRED", "Commanding toggled.  Restart the Ground Station to see the changes.");
                    }
                    this.spacecraftSettings.set("is_command_station", this.cbCommandStation.isSelected());
                    this.spacecraftSettings.set("secret_key", this.txtKey.getText());
                    this.spacecraftSettings.save();
                    if (CommandFrame.spacecraftSettings != null) {
                        CommandFrame.spacecraftSettings.load_key();
                    }
                    this.dispose();
                    if (this.spacecraftSettings.directory.getTableData().length > 0 && Config.mainWindow != null) {
                        MainWindow.setDirectoryData(this.spacecraftSettings.name, this.spacecraftSettings.directory.getTableData());
                    }
                }
            }
            catch (NumberFormatException Ex) {
                Log.errorDialog("Invalid Paramaters", Ex.getMessage());
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    public void saveProperties() {
        Config.set(SPACECRAFT_WINDOW_HEIGHT, this.getHeight());
        Config.set(SPACECRAFT_WINDOW_WIDTH, this.getWidth());
        Config.set(SPACECRAFT_WINDOW_X, this.getX());
        Config.set(SPACECRAFT_WINDOW_Y, this.getY());
        Config.save();
    }

    public void loadProperties() {
        if (Config.getInt(SPACECRAFT_WINDOW_X) == 0) {
            Config.set(SPACECRAFT_WINDOW_X, 100);
            Config.set(SPACECRAFT_WINDOW_Y, 100);
            Config.set(SPACECRAFT_WINDOW_HEIGHT, 700);
            Config.set(SPACECRAFT_WINDOW_WIDTH, 625);
        }
        this.setBounds(Config.getInt(SPACECRAFT_WINDOW_X), Config.getInt(SPACECRAFT_WINDOW_Y), Config.getInt(SPACECRAFT_WINDOW_WIDTH), Config.getInt(SPACECRAFT_WINDOW_HEIGHT));
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.saveProperties();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    protected void deleteRow(JTable table, int row) {
        String id = (String)table.getValueAt(row, 0);
        Log.println("Delete for: " + id);
        id = (String)table.getModel().getValueAt(table.getSelectedRow(), 0);
        Log.println("Delete Key: " + id);
        this.spacecraftSettings.directory.deleteEquation(id);
        this.updateDirEquations();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

