/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.File;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jssc.SerialNativeInterface;

public class SerialPortList {
    private static SerialNativeInterface serialInterface = new SerialNativeInterface();
    private static final Pattern PORTNAMES_REGEXP;
    private static final String PORTNAMES_PATH;
    private static final Comparator<String> PORTNAMES_COMPARATOR;

    public static String[] getPortNames() {
        return SerialPortList.getPortNames(PORTNAMES_PATH, PORTNAMES_REGEXP, PORTNAMES_COMPARATOR);
    }

    public static String[] getPortNames(String searchPath) {
        return SerialPortList.getPortNames(searchPath, PORTNAMES_REGEXP, PORTNAMES_COMPARATOR);
    }

    public static String[] getPortNames(Pattern pattern) {
        return SerialPortList.getPortNames(PORTNAMES_PATH, pattern, PORTNAMES_COMPARATOR);
    }

    public static String[] getPortNames(Comparator<String> comparator) {
        return SerialPortList.getPortNames(PORTNAMES_PATH, PORTNAMES_REGEXP, comparator);
    }

    public static String[] getPortNames(String searchPath, Pattern pattern) {
        return SerialPortList.getPortNames(searchPath, pattern, PORTNAMES_COMPARATOR);
    }

    public static String[] getPortNames(String searchPath, Comparator<String> comparator) {
        return SerialPortList.getPortNames(searchPath, PORTNAMES_REGEXP, comparator);
    }

    public static String[] getPortNames(Pattern pattern, Comparator<String> comparator) {
        return SerialPortList.getPortNames(PORTNAMES_PATH, pattern, comparator);
    }

    public static String[] getPortNames(String searchPath, Pattern pattern, Comparator<String> comparator) {
        if (searchPath == null || pattern == null || comparator == null) {
            return new String[0];
        }
        if (SerialNativeInterface.getOsType() == 1) {
            return SerialPortList.getWindowsPortNames(pattern, comparator);
        }
        return SerialPortList.getUnixBasedPortNames(searchPath, pattern, comparator);
    }

    private static String[] getWindowsPortNames(Pattern pattern, Comparator<String> comparator) {
        String[] portNames = serialInterface.getSerialPortNames();
        if (portNames == null) {
            return new String[0];
        }
        TreeSet<String> ports = new TreeSet<String>(comparator);
        for (String portName : portNames) {
            if (!pattern.matcher(portName).find()) continue;
            ports.add(portName);
        }
        return ports.toArray(new String[ports.size()]);
    }

    private static String[] getUnixBasedPortNames(String searchPath, Pattern pattern, Comparator<String> comparator) {
        File[] files;
        searchPath = searchPath.equals("") ? searchPath : (searchPath.endsWith("/") ? searchPath : searchPath + "/");
        String[] returnArray = new String[]{};
        File dir = new File(searchPath);
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()).length > 0) {
            TreeSet<String> portsTree = new TreeSet<String>(comparator);
            for (File file : files) {
                String portName;
                long portHandle;
                String fileName = file.getName();
                if (file.isDirectory() || file.isFile() || !pattern.matcher(fileName).find() || (portHandle = serialInterface.openPort(portName = searchPath + fileName, false)) < 0L && portHandle != -1L) continue;
                if (portHandle != -1L) {
                    serialInterface.closePort(portHandle);
                }
                portsTree.add(portName);
            }
            returnArray = portsTree.toArray(returnArray);
        }
        return returnArray;
    }

    static {
        switch (SerialNativeInterface.getOsType()) {
            case 0: {
                PORTNAMES_REGEXP = Pattern.compile("(ttyS|ttyUSB|ttyACM|ttyAMA|rfcomm|ttyO)[0-9]{1,3}");
                PORTNAMES_PATH = "/dev/";
                break;
            }
            case 2: {
                PORTNAMES_REGEXP = Pattern.compile("[0-9]*|[a-z]*");
                PORTNAMES_PATH = "/dev/term/";
                break;
            }
            case 3: {
                PORTNAMES_REGEXP = Pattern.compile("tty.(serial|usbserial|usbmodem).*");
                PORTNAMES_PATH = "/dev/";
                break;
            }
            case 1: {
                PORTNAMES_REGEXP = Pattern.compile("");
                PORTNAMES_PATH = "";
                break;
            }
            default: {
                PORTNAMES_REGEXP = null;
                PORTNAMES_PATH = null;
            }
        }
        PORTNAMES_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String valueA, String valueB) {
                if (valueA.equalsIgnoreCase(valueB)) {
                    return valueA.compareTo(valueB);
                }
                int minLength = Math.min(valueA.length(), valueB.length());
                int shiftA = 0;
                int shiftB = 0;
                for (int i2 = 0; i2 < minLength; ++i2) {
                    char charB;
                    char charA = valueA.charAt(i2 - shiftA);
                    if (charA == (charB = valueB.charAt(i2 - shiftB))) continue;
                    if (Character.isDigit(charA) && Character.isDigit(charB)) {
                        int[] resultsB;
                        int[] resultsA = this.getNumberAndLastIndex(valueA, i2 - shiftA);
                        if (resultsA[0] != (resultsB = this.getNumberAndLastIndex(valueB, i2 - shiftB))[0]) {
                            return resultsA[0] - resultsB[0];
                        }
                        if (valueA.length() < valueB.length()) {
                            i2 = resultsA[1];
                            shiftB = resultsA[1] - resultsB[1];
                            continue;
                        }
                        i2 = resultsB[1];
                        shiftA = resultsB[1] - resultsA[1];
                        continue;
                    }
                    if (Character.toLowerCase(charA) - Character.toLowerCase(charB) == 0) continue;
                    return Character.toLowerCase(charA) - Character.toLowerCase(charB);
                }
                return valueA.compareToIgnoreCase(valueB);
            }

            private int[] getNumberAndLastIndex(String str, int startIndex) {
                String numberValue = "";
                int[] returnValues = new int[]{-1, startIndex};
                for (int i2 = startIndex; i2 < str.length(); ++i2) {
                    returnValues[1] = i2;
                    char c = str.charAt(i2);
                    if (!Character.isDigit(c)) break;
                    numberValue = numberValue + c;
                }
                try {
                    returnValues[0] = Integer.valueOf(numberValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return returnValues;
            }
        };
    }
}

