/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;

public class DateTimeParserBucket {
    private final Chronology iChrono;
    private final long iMillis;
    private DateTimeZone iZone;
    private int iOffset;
    private Locale iLocale;
    private Integer iPivotYear;
    private SavedField[] iSavedFields = new SavedField[8];
    private int iSavedFieldsCount;
    private boolean iSavedFieldsShared;
    private Object iSavedState;

    public DateTimeParserBucket(long l, Chronology chronology, Locale locale) {
        this(l, chronology, locale, null);
    }

    public DateTimeParserBucket(long l, Chronology chronology, Locale locale, Integer n) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iMillis = l;
        this.iChrono = chronology.withUTC();
        this.iLocale = locale == null ? Locale.getDefault() : locale;
        this.setZone(chronology.getZone());
        this.iPivotYear = n;
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public void setZone(DateTimeZone dateTimeZone) {
        this.iSavedState = null;
        this.iZone = dateTimeZone == DateTimeZone.UTC ? null : dateTimeZone;
        this.iOffset = 0;
    }

    public int getOffset() {
        return this.iOffset;
    }

    public void setOffset(int n) {
        this.iSavedState = null;
        this.iOffset = n;
        this.iZone = null;
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public void setPivotYear(Integer n) {
        this.iPivotYear = n;
    }

    public void saveField(DateTimeField dateTimeField, int n) {
        this.saveField(new SavedField(dateTimeField, n));
    }

    public void saveField(DateTimeFieldType dateTimeFieldType, int n) {
        this.saveField(new SavedField(dateTimeFieldType.getField(this.iChrono), n));
    }

    public void saveField(DateTimeFieldType dateTimeFieldType, String string, Locale locale) {
        this.saveField(new SavedField(dateTimeFieldType.getField(this.iChrono), string, locale));
    }

    private void saveField(SavedField savedField) {
        int n = this.iSavedFieldsCount;
        SavedField[] savedFieldArray = this.iSavedFields;
        if (n == savedFieldArray.length || this.iSavedFieldsShared) {
            SavedField[] savedFieldArray2 = new SavedField[n == savedFieldArray.length ? n * 2 : savedFieldArray.length];
            System.arraycopy(savedFieldArray, 0, savedFieldArray2, 0, n);
            savedFieldArray = savedFieldArray2;
            this.iSavedFields = savedFieldArray2;
            this.iSavedFieldsShared = false;
        }
        this.iSavedState = null;
        savedFieldArray[n] = savedField;
        this.iSavedFieldsCount = n + 1;
    }

    public Object saveState() {
        if (this.iSavedState == null) {
            this.iSavedState = new SavedState();
        }
        return this.iSavedState;
    }

    public boolean restoreState(Object object) {
        if (object instanceof SavedState && ((SavedState)object).restoreState(this)) {
            this.iSavedState = object;
            return true;
        }
        return false;
    }

    public long computeMillis() {
        return this.computeMillis(false, null);
    }

    public long computeMillis(boolean bl) {
        return this.computeMillis(bl, null);
    }

    public long computeMillis(boolean bl, String string) {
        int n;
        Comparable[] comparableArray = this.iSavedFields;
        int n2 = this.iSavedFieldsCount;
        if (this.iSavedFieldsShared) {
            comparableArray = (SavedField[])this.iSavedFields.clone();
            this.iSavedFields = comparableArray;
            this.iSavedFieldsShared = false;
        }
        DateTimeParserBucket.sort(comparableArray, n2);
        long l = this.iMillis;
        try {
            for (n = 0; n < n2; ++n) {
                l = ((SavedField)comparableArray[n]).set(l, bl);
            }
        }
        catch (IllegalFieldValueException illegalFieldValueException) {
            if (string != null) {
                illegalFieldValueException.prependMessage("Cannot parse \"" + string + '\"');
            }
            throw illegalFieldValueException;
        }
        if (this.iZone == null) {
            l -= (long)this.iOffset;
        } else {
            n = this.iZone.getOffsetFromLocal(l);
            if (n != this.iZone.getOffset(l -= (long)n)) {
                String string2 = "Illegal instant due to time zone offset transition (" + this.iZone + ')';
                if (string != null) {
                    string2 = "Cannot parse \"" + string + "\": " + string2;
                }
                throw new IllegalArgumentException(string2);
            }
        }
        return l;
    }

    private static void sort(Comparable[] comparableArray, int n) {
        if (n > 10) {
            Arrays.sort(comparableArray, 0, n);
        } else {
            for (int j = 0; j < n; ++j) {
                for (int k = j; k > 0 && comparableArray[k - 1].compareTo(comparableArray[k]) > 0; --k) {
                    Comparable comparable = comparableArray[k];
                    comparableArray[k] = comparableArray[k - 1];
                    comparableArray[k - 1] = comparable;
                }
            }
        }
    }

    static /* synthetic */ SavedField[] access$202(DateTimeParserBucket dateTimeParserBucket, SavedField[] savedFieldArray) {
        dateTimeParserBucket.iSavedFields = savedFieldArray;
        return savedFieldArray;
    }

    static class SavedField
    implements Comparable {
        final DateTimeField iField;
        final int iValue;
        final String iText;
        final Locale iLocale;

        SavedField(DateTimeField dateTimeField, int n) {
            this.iField = dateTimeField;
            this.iValue = n;
            this.iText = null;
            this.iLocale = null;
        }

        SavedField(DateTimeField dateTimeField, String string, Locale locale) {
            this.iField = dateTimeField;
            this.iValue = 0;
            this.iText = string;
            this.iLocale = locale;
        }

        long set(long l, boolean bl) {
            l = this.iText == null ? this.iField.set(l, this.iValue) : this.iField.set(l, this.iText, this.iLocale);
            if (bl) {
                l = this.iField.roundFloor(l);
            }
            return l;
        }

        public int compareTo(Object object) {
            DateTimeField dateTimeField = ((SavedField)object).iField;
            int n = this.compareReverse(this.iField.getRangeDurationField(), dateTimeField.getRangeDurationField());
            if (n != 0) {
                return n;
            }
            return this.compareReverse(this.iField.getDurationField(), dateTimeField.getDurationField());
        }

        private int compareReverse(DurationField durationField, DurationField durationField2) {
            if (durationField == null || !durationField.isSupported()) {
                if (durationField2 == null || !durationField2.isSupported()) {
                    return 0;
                }
                return -1;
            }
            if (durationField2 == null || !durationField2.isSupported()) {
                return 1;
            }
            return -durationField.compareTo(durationField2);
        }
    }

    class SavedState {
        final DateTimeZone iZone;
        final int iOffset;
        final SavedField[] iSavedFields;
        final int iSavedFieldsCount;

        SavedState() {
            this.iZone = DateTimeParserBucket.this.iZone;
            this.iOffset = DateTimeParserBucket.this.iOffset;
            this.iSavedFields = DateTimeParserBucket.this.iSavedFields;
            this.iSavedFieldsCount = DateTimeParserBucket.this.iSavedFieldsCount;
        }

        boolean restoreState(DateTimeParserBucket dateTimeParserBucket) {
            if (dateTimeParserBucket != DateTimeParserBucket.this) {
                return false;
            }
            dateTimeParserBucket.iZone = this.iZone;
            dateTimeParserBucket.iOffset = this.iOffset;
            DateTimeParserBucket.access$202(dateTimeParserBucket, this.iSavedFields);
            if (this.iSavedFieldsCount < dateTimeParserBucket.iSavedFieldsCount) {
                dateTimeParserBucket.iSavedFieldsShared = true;
            }
            dateTimeParserBucket.iSavedFieldsCount = this.iSavedFieldsCount;
            return true;
        }
    }
}

