/*
 * Decompiled with CFR 0.152.
 */
package pacSat;

import ax25.KissFrame;
import common.Log;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class SubmitTelem {
    public static final String SATNOGS_URL = "https://db.satnogs.org/api/telemetry/";
    String url;
    int noradId;
    String source;
    Date timestamp;
    String frame;
    String locator = "longLat";
    double longitude;
    double latitude;
    float azimuth;
    float elevation;
    long fDown;

    SubmitTelem(String url, int noradId, String source, Date timestamp, double longitude, double latitude) {
        this.url = url;
        this.noradId = noradId;
        this.source = source;
        this.timestamp = timestamp;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public void setFrame(KissFrame kissFrame) {
        this.frame = kissFrame.toByteString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean send() throws Exception {
        HttpPost post = new HttpPost(this.url);
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("noradID", "" + this.noradId));
        urlParameters.add(new BasicNameValuePair("source", this.source));
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        String timestampAsISO = df.format(this.timestamp);
        System.err.println(timestampAsISO);
        urlParameters.add(new BasicNameValuePair("timestamp", timestampAsISO));
        urlParameters.add(new BasicNameValuePair("frame", this.frame));
        urlParameters.add(new BasicNameValuePair("locator", this.locator));
        DecimalFormat decimalFormat5 = new DecimalFormat();
        decimalFormat5.setMaximumFractionDigits(5);
        String longDir = "E";
        if (this.longitude < 0.0) {
            longDir = "W";
            this.longitude *= -1.0;
        }
        String latDir = "N";
        if (this.latitude < 0.0) {
            latDir = "S";
            this.latitude *= -1.0;
        }
        urlParameters.add(new BasicNameValuePair("longitude", String.valueOf(decimalFormat5.format(this.longitude)) + longDir));
        urlParameters.add(new BasicNameValuePair("latitude", String.valueOf(decimalFormat5.format(this.latitude)) + latDir));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(urlParameters, "UTF-8");
        post.setEntity(entity);
        String postStr = EntityUtils.toString(entity);
        Log.println("SUBMITTING TELEMETRY:" + this.url + "?" + postStr);
        Throwable throwable = null;
        Object var12_13 = null;
        try {
            CloseableHttpResponse response;
            CloseableHttpClient httpClient;
            block15: {
                block16: {
                    httpClient = HttpClients.createDefault();
                    response = httpClient.execute(post);
                    int statusCode = response.getStatusLine().getStatusCode();
                    String responseBody = EntityUtils.toString(response.getEntity());
                    Log.println("RETURN CODE:" + statusCode);
                    if (statusCode >= 200 && statusCode < 300) break block15;
                    Log.println("ERROR :" + statusCode + "\n" + responseBody);
                    if (response == null) break block16;
                    response.close();
                }
                if (httpClient == null) return false;
                httpClient.close();
                return false;
            }
            if (response != null) {
                response.close();
            }
            if (httpClient == null) return true;
            {
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (httpClient == null) throw throwable;
                    httpClient.close();
                    throw throwable;
                }
            }
            {
                httpClient.close();
                return true;
                catch (Throwable throwable3) {
                    if (response == null) throw throwable3;
                    response.close();
                    throw throwable3;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }
}

