/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import ax25.KissFrame;
import fileStore.MalformedPfhException;
import fileStore.PacSatField;
import fileStore.PacSatFileHeader;
import java.util.Arrays;
import java.util.Date;
import pacSat.Crc16;
import pacSat.frames.BroadCastFrame;

public class BroadcastDirFrame
extends BroadCastFrame {
    Ax25Frame uiFrame;
    int flags;
    public static final int TYPE_BITS = 3;
    public static final int E_BIT = 32;
    public static final int VV_BIT = 12;
    public static final int NEWEST_FILE_BIT = 64;
    public static final int ZERO_BIT = 114;
    public long fileId;
    int fileType;
    long offset;
    int offsetMsb;
    int length;
    long timeOld;
    Date oldDate;
    long timeNew;
    Date newDate;
    int[] bytes;
    int[] data;
    int crc;
    public PacSatFileHeader pfh;
    boolean newestFile = false;

    public BroadcastDirFrame(Ax25Frame ui) throws MalformedPfhException {
        this.frameType = 20;
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        this.flags = this.bytes[0];
        if ((this.flags & 0x40) == 64) {
            this.newestFile = true;
        }
        int type_bits = this.flags & 3;
        int[] by = new int[]{this.bytes[1], this.bytes[2], this.bytes[3], this.bytes[4]};
        this.fileId = KissFrame.getLongFromBytes(by);
        int[] by2 = new int[]{this.bytes[5], this.bytes[6], this.bytes[7], this.bytes[8]};
        this.offset = KissFrame.getLongFromBytes(by2);
        int[] by3 = new int[]{this.bytes[9], this.bytes[10], this.bytes[11], this.bytes[12]};
        this.timeOld = KissFrame.getLongFromBytes(by3);
        this.oldDate = new Date(this.timeOld * 1000L);
        int[] by4 = new int[]{this.bytes[13], this.bytes[14], this.bytes[15], this.bytes[16]};
        this.timeNew = KissFrame.getLongFromBytes(by4);
        this.newDate = new Date(this.timeNew * 1000L);
        this.data = Arrays.copyOfRange(this.bytes, 17, this.bytes.length - 2);
        if (this.offset == 0L && this.hasEndOfFile()) {
            this.pfh = new PacSatFileHeader(this.fileId, this.timeOld, this.timeNew, this.data);
        }
        int[] by5 = new int[]{this.bytes[this.bytes.length - 2], this.bytes[this.bytes.length - 1]};
        this.crc = KissFrame.getIntFromBytes(by5);
        if (!Crc16.goodCrc(this.bytes)) {
            throw new MalformedPfhException("Bad CRC for PFH Dir File ID: " + Long.toHexString(this.fileId));
        }
    }

    @Override
    public int[] getBytes() {
        return this.bytes;
    }

    public int[] getDataBytes() {
        return this.data;
    }

    @Override
    public long getFirst() {
        return this.timeOld;
    }

    @Override
    public long getLast() {
        return this.timeNew;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean hasEndOfFile() {
        return (this.flags & 0x20) == 32;
    }

    public String toLongString() {
        String s = this.toString();
        s = String.valueOf(s) + " PFH> " + this.pfh.toString();
        return s;
    }

    @Override
    public String toString() {
        String s = "DIR> ";
        s = String.valueOf(s) + this.uiFrame.headerString();
        s = String.valueOf(s) + "FLG: " + Integer.toHexString(this.flags & 0xFF);
        s = String.valueOf(s) + " FILE: " + Long.toHexString(this.fileId & 0xFFFFFFFFFFFFFFFFL);
        s = String.valueOf(s) + " TYPE: " + Integer.toHexString(this.fileType & 0xFF);
        s = String.valueOf(s) + " OFF: " + Long.toHexString(this.offset & 0xFFFFFFL);
        if ((this.flags & 0x40) == 64) {
            s = String.valueOf(s) + " N";
        }
        if (this.hasEndOfFile()) {
            s = String.valueOf(s) + " E";
        }
        s = String.valueOf(s) + " OLD: " + PacSatField.getDateString(this.oldDate);
        s = String.valueOf(s) + " NEW: " + PacSatField.getDateString(this.newDate);
        s = String.valueOf(s) + " CRC: " + Integer.toHexString(this.crc & 0xFFFF);
        return s;
    }
}

