/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import ax25.KissFrame;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import pacSat.frames.PacSatFrame;

public class CmdFrame
extends PacSatFrame {
    public static final int CMD_TYPE_RAW_SOFTWARE = 1;
    public static final int SW_CMD_NS_SPACECRAFT_OPS = 1;
    public static final int SW_CMD_OPS_CLEAR_MINMAX = 6;
    public static final int SW_CMD_OPS_ENABLE_PB = 8;
    public static final int SW_CMD_OPS_FORMAT_FS = 9;
    public static final int SW_CMD_OPS_ENABLE_UPLINK = 12;
    public static final int SW_CMD_OPS_SET_TIME = 14;
    public static final int SW_CMD_OPS_RESET = 21;
    public static final int SW_CMD_ADDRESS = 26;
    public static final int SW_CMD_STOP_SENDING = 99999;
    Ax25Frame uiFrame;
    int reset;
    long uptime;
    int[] data;
    byte[] hashVector;
    int msgType;
    int nameSpace;
    int cmd;
    int address;
    int special;
    int[] args;
    boolean useResetUptime = false;

    public CmdFrame(String fromCall, String toCall, long dateTime, int nameSpace, int cmd, int[] args, byte[] key) {
        this.uptime = dateTime;
        this.useResetUptime = false;
        this.frameType = 32;
        this.msgType = 1;
        this.nameSpace = nameSpace;
        this.cmd = cmd;
        this.address = 26;
        this.args = new int[4];
        int i2 = 0;
        while (i2 < 4) {
            this.args[i2] = args[i2];
            ++i2;
        }
        this.makeFrame(fromCall, toCall, key);
    }

    public CmdFrame(String fromCall, String toCall, int reset, long uptime, int nameSpace, int cmd, int[] args, byte[] key) {
        this.reset = reset;
        this.uptime = uptime;
        this.useResetUptime = true;
        this.frameType = 32;
        this.msgType = 1;
        this.nameSpace = nameSpace;
        this.cmd = cmd;
        this.address = 26;
        this.args = new int[4];
        int i2 = 0;
        while (i2 < 4) {
            this.args[i2] = args[i2];
            ++i2;
        }
        this.makeFrame(fromCall, toCall, key);
    }

    public CmdFrame() {
        this.frameType = 33;
        this.msgType = 1;
        this.cmd = 99999;
    }

    private void makeFrame(String fromCall, String toCall, byte[] key) {
        this.data = new int[50];
        if (this.useResetUptime) {
            int[] r = KissFrame.littleEndian2(this.reset);
            this.data[0] = r[0];
            this.data[1] = r[1];
            int[] u = KissFrame.littleEndian4(this.uptime);
            this.data[2] = u[0];
            this.data[3] = u[1];
            this.data[4] = u[2];
        } else {
            int[] u = KissFrame.littleEndian4(this.uptime);
            this.data[0] = u[0];
            this.data[1] = u[1];
            this.data[2] = u[2];
            this.data[3] = u[3];
        }
        this.data[5] = this.address;
        this.data[6] = this.special;
        this.data[7] = this.nameSpace;
        int[] c = KissFrame.littleEndian2(this.cmd);
        this.data[8] = c[0];
        this.data[9] = c[1];
        int i2 = 0;
        while (i2 < this.args.length) {
            int[] arg = KissFrame.littleEndian2(this.args[i2]);
            this.data[10 + 2 * i2] = arg[0];
            this.data[10 + 2 * i2 + 1] = arg[1];
            ++i2;
        }
        try {
            this.calcHashVector(key);
            i2 = 0;
            while (i2 < 32) {
                this.data[18 + i2] = this.hashVector[i2] & 0xFF;
                ++i2;
            }
            this.uiFrame = new Ax25Frame(fromCall, toCall, 3, 1, 188, this.data);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private void calcHashVector(byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] by = new byte[18];
        int i2 = 0;
        while (i2 < 18) {
            by[i2] = (byte)this.data[i2];
            ++i2;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(secretKeySpec);
        this.hashVector = mac.doFinal(by);
    }

    @Override
    public int[] getBytes() {
        return this.uiFrame.getBytes();
    }

    @Override
    public String toString() {
        if (this.uiFrame == null) {
            return "CmdStop";
        }
        String s = "";
        int i2 = 0;
        while (i2 < this.uiFrame.getBytes().length) {
            s = String.valueOf(s) + Integer.toHexString(this.uiFrame.getBytes()[i2]) + " ";
            ++i2;
        }
        return s;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        System.out.println("CMD");
        int[] nArray = new int[4];
        nArray[0] = 1;
        int[] arg1 = nArray;
        String encodedKey = "ABCDEFG";
        System.out.println("KEY: " + encodedKey);
        byte[] decodedKey = Base64.getDecoder().decode(encodedKey);
        int j = 0;
        while (j < decodedKey.length) {
            System.out.print(" " + Integer.toHexString(decodedKey[j] & 0xFF));
            ++j;
        }
        System.out.println();
        CmdFrame cmdFrame = new CmdFrame("VE2TCP", "VE2TCP-11", 43981, 14593470L, 1, 8, arg1, decodedKey);
        byte[] by = new byte[18];
        int i2 = 0;
        while (i2 < 18) {
            by[i2] = (byte)cmdFrame.data[i2];
            ++i2;
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(decodedKey, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        try {
            mac.init(secretKeySpec);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        byte[] d = mac.doFinal(by);
        System.out.println("HASH:" + mac.getMacLength());
        int j2 = 0;
        while (j2 < mac.getMacLength()) {
            System.out.print(" " + Integer.toHexString(d[j2] & 0xFF));
            ++j2;
        }
    }
}

