/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import ax25.Iframe;
import ax25.KissFrame;
import common.Config;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import pacSat.frames.FrameException;
import pacSat.frames.PacSatFrame;

public class FTL0Frame
extends PacSatFrame {
    public static final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss dd MMM yy ", Locale.ENGLISH);
    Ax25Frame iFrame;
    int[] bytes;
    int length;
    int ftl0Type;
    int[] data;
    static String[] ftl0Types = new String[]{"DATA", "DATA_END", "LOGIN", "UPLOAD_CMD", "UL_GO_RESP", "UP_ERROR_RESP", "UL_ACK_RESP", "UL_NAK_RESP", "DOWNLOAD_CMD", "DL_ERROR_RESP", "DL_ABORTED_RESP", "DL_COMPLETED_RESP", "DL_ACK_CMD", "DL_NAK_CMD", "DIR_SHORT_CMD", "DIR_LONG_CMD", "SELECT_CMD", "SELECRT_RESP", "NOP", "NOP", "AUTH_UPLOAD_CMD", "AUTH_DATA_END"};
    public static final int ER_BAD_CONTINUE = 2;
    public static final int ER_NO_SUCH_FILE_NUMBER = 4;
    public static final int ER_FILE_COMPLETE = 12;
    public static final int ER_NO_ROOM = 13;
    String[] ftl0Errors = new String[]{"UNDEFINED", "ER_ILL_FORMED_CMD", "ER_BAD_CONTINUE", "ER_SERVER_FSYS", "ER_NO_SUCH_FILE_NUMBER", "ER_SELECTION_EMPTY", "ER_MANDATORY_FIELD_MISSING", "ER_NO_PFH", "ER_POORLY_FORMED_SEL", "ER_ALREADY_LOCKED", "ER_NO_SUCH_DESTINATION", "ER_SELECTION_EMPTY", "ER_FILE_COMPLETE", "ER_NO_ROOM", "ER_BAD_HEADER", "ER_HEADER_CHECK", "ER_BODY_CHECK"};
    public static final int DATA = 0;
    public static final int DATA_END = 1;
    public static final int LOGIN = 2;
    public static final int UPLOAD_CMD = 3;
    public static final int UL_GO_RESP = 4;
    public static final int UL_ERROR_RESP = 5;
    public static final int UL_ACK_RESP = 6;
    public static final int UL_NAK_RESP = 7;
    public static final int AUTH_UPLOAD_CMD = 20;
    public static final int AUTH_DATA_END = 21;
    long loginDate;
    Date dateLogin;
    int loginFlags;
    long fileId;
    long offset;

    public FTL0Frame(Ax25Frame i2) throws FrameException {
        this.iFrame = i2;
        this.bytes = i2.getDataBytes();
        if (this.bytes.length < 2) {
            throw new FrameException("FTL Frame too short.  Length:" + this.bytes.length);
        }
        this.length = (this.bytes[1] >> 5) * 256 + this.bytes[0];
        this.ftl0Type = this.bytes[1] & 0x1F;
        if (this.length > 0 && this.length < this.bytes.length - 1) {
            this.data = Arrays.copyOfRange(this.bytes, 2, 2 + this.length);
        }
        switch (this.ftl0Type) {
            case 2: {
                this.frameType = 102;
                if (this.data == null || this.data.length < 5) {
                    throw new FrameException("FTL0 Login has no data");
                }
                int[] by = new int[]{this.data[0], this.data[1], this.data[2], this.data[3]};
                this.loginDate = KissFrame.getLongFromBytes(by);
                this.dateLogin = new Date(this.loginDate * 1000L);
                this.loginFlags = this.data[4];
                break;
            }
            case 4: {
                this.frameType = 104;
                if (this.data == null || this.data.length < 8) {
                    throw new FrameException("FTL0 UL GO RESP has no data");
                }
                int[] by2 = new int[]{this.data[0], this.data[1], this.data[2], this.data[3]};
                this.fileId = KissFrame.getLongFromBytes(by2);
                int[] by3 = new int[]{this.data[4], this.data[5], this.data[6], this.data[7]};
                this.offset = KissFrame.getLongFromBytes(by3);
                break;
            }
            case 5: {
                this.frameType = 105;
                if (this.data != null && this.data.length >= 1) break;
                throw new FrameException("FTL0 UL ERR has no data");
            }
            case 6: {
                this.frameType = 106;
                break;
            }
            case 7: {
                this.frameType = 107;
                if (this.data != null && this.data.length >= 1) break;
                throw new FrameException("FTL0 UL NAK has no data");
            }
        }
    }

    public int getErrorCode() {
        return this.data[0];
    }

    public String getErrorString() {
        return this.ftl0Errors[this.getErrorCode()];
    }

    public boolean sentToCallsign(String callsign) {
        return this.iFrame.toCallsign.startsWith(callsign);
    }

    @Override
    public int[] getBytes() {
        return this.bytes;
    }

    public long getFileId() {
        return this.fileId;
    }

    public long getContinuationOffset() {
        return this.offset;
    }

    @Override
    public String toString() {
        String s = "";
        if (Config.getBoolean("DEBUG_LAYER3")) {
            s = String.valueOf(s) + this.iFrame.headerString() + "> ";
        }
        switch (this.ftl0Type) {
            case 2: {
                String dt = "";
                try {
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    dt = dateFormat.format(this.dateLogin);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String d = this.dateLogin.toString();
                s = String.valueOf(s) + "LOGIN to " + this.iFrame.fromCallsign + " by " + this.iFrame.toCallsign + " at " + dt;
                break;
            }
            case 4: {
                s = String.valueOf(s) + "Ready to receive file: " + Long.toHexString(this.fileId) + " from " + this.iFrame.toCallsign + " at off 0x: " + Long.toHexString(this.offset);
                break;
            }
            case 7: {
                int errorCode = 0;
                if (this.data != null) {
                    errorCode = this.data[0];
                }
                s = String.valueOf(s) + "UL NAK " + errorCode + ": " + this.ftl0Errors[errorCode];
                break;
            }
            case 5: {
                int errorCode = 0;
                if (this.data != null) {
                    errorCode = this.data[0];
                }
                s = String.valueOf(s) + "UL ERROR " + errorCode + ": " + this.ftl0Errors[errorCode];
                break;
            }
            default: {
                if (Config.getBoolean("DEBUG_DOWNLINK")) {
                    s = String.valueOf(s) + this.iFrame.headerString() + " ";
                }
                if (this.iFrame.isIFrame()) {
                    s = String.valueOf(s) + "PID:" + Integer.toHexString(this.iFrame.pid) + " ";
                }
                s = this.ftl0Type > 0 && this.ftl0Type < ftl0Types.length ? String.valueOf(s) + ftl0Types[this.ftl0Type] + " " : String.valueOf(s) + this.ftl0Type + " ";
            }
        }
        return s;
    }

    public static final void main(String[] args) throws FrameException {
        Config.init("PacSatGround.properties");
        int[] by2 = new int[]{5, 2, 37, 255, 28, 92, 4};
        int[] nArray = new int[10];
        nArray[0] = 8;
        nArray[1] = 4;
        nArray[2] = 189;
        nArray[3] = 20;
        nArray[6] = 239;
        nArray[7] = 6;
        int[] by = nArray;
        int[] bytes = new int[]{1, 5, 15};
        int pid = 240;
        Iframe ifrm = new Iframe("From", "To", pid, bytes);
        FTL0Frame ftl = new FTL0Frame(ifrm);
        System.out.println(ftl);
    }
}

