/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import pacSat.frames.PacSatFrame;

public class IorsStatusFrame
extends PacSatFrame {
    Ax25Frame uiFrame;
    int[] bytes;
    int iors_mode;
    int pm_mode;
    int channel_a;
    int channel_b;
    int x_band_rpt;
    int T4;
    String[] iors_mode_strs = new String[]{"SAFE", "CREW", "TELEM", "X_BAND", "APRS", "SSTV", "FS"};

    public IorsStatusFrame(Ax25Frame ui) {
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        if (this.bytes.length < 10) {
            return;
        }
        this.iors_mode = this.bytes[0];
        this.pm_mode = this.bytes[1];
        this.channel_a = this.bytes[2] + (this.bytes[3] << 8);
        this.channel_b = this.bytes[4] + (this.bytes[5] << 8);
        this.x_band_rpt = this.bytes[6];
        this.T4 = this.bytes[7] + (this.bytes[8] << 8);
    }

    @Override
    public int[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        String s = "";
        s = String.valueOf(s) + "STATUS: Mode:" + this.iors_mode_strs[this.iors_mode];
        s = String.valueOf(s) + " PM:" + this.pm_mode;
        s = String.valueOf(s) + " CH-A:" + this.channel_a;
        s = String.valueOf(s) + " CH-B:" + this.channel_b;
        s = String.valueOf(s) + " RPT:" + this.x_band_rpt;
        s = String.valueOf(s) + " T:" + this.T4;
        return s;
    }
}

