/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import fileStore.PacSatFile;
import pacSat.frames.PacSatPrimative;

public class PacSatEvent
extends PacSatPrimative {
    public static final int UL_CONNECTED = 0;
    public static final int UL_DISCONNECTED = 1;
    public static final int UL_REQUEST_UPLOAD = 2;
    public static final int UL_DATA = 3;
    public static final int UL_DATA_END = 4;
    public static final int UL_DATALINK_TERMINATED = 5;
    public static final int UL_GO_RESP = 6;
    public static final int UL_ERROR_RESP = 7;
    public static final int UL_ACK_RESP = 8;
    public static final int UL_NAK_RESP = 9;
    public static final int UL_TIMER_T3_EXPIRY = 10;
    public static final int UL_REQUEST_AUTH_UPLOAD = 11;
    public static final int UL_AUTH_DATA_END = 12;
    public static final boolean AUTHENTICATE = true;
    public static final boolean NO_AUTHENTICATION = false;
    public static final String[] types = new String[]{"UL_CONNECT", "UL_DISCONNECTED", "UL_REQUEST_UPLOAD", "UL_DATA", "UL_DATA_END", "UL_DATALINK_TERMINATED", "UL_GO_RESP", "UL_ERROR_RESP", "UL_ACK_RESP", "UL_NAK_RESP"};
    public int type;
    public PacSatFile psf;
    public long continueFileNumber;
    public long fileLength;
    short header_check;
    short body_check;
    public int[] bytes;

    public PacSatEvent(int type) {
        this.type = type;
    }

    public PacSatEvent(PacSatFile pacSatFile, boolean authenticate) {
        this.psf = pacSatFile;
        this.type = authenticate ? 11 : 2;
    }

    public PacSatEvent(PacSatFile pacSatFile) {
        this.psf = pacSatFile;
        this.type = 2;
    }

    public PacSatEvent(int type, short header, short body) {
        this.type = 12;
        this.header_check = header;
        this.body_check = body;
    }

    public PacSatEvent(int[] bytes, long offset, long fileSize) {
        this.bytes = bytes;
        this.continueFileNumber = offset;
        this.fileLength = fileSize;
        this.type = 3;
    }

    public String toString() {
        String s = "";
        s = this.type == 3 ? String.valueOf(s) + "Data Offset: " + this.continueFileNumber + " " + String.format("%.1f", Float.valueOf((float)(100L * this.continueFileNumber) / (float)this.fileLength)) + "%" : String.valueOf(s) + types[this.type];
        return s;
    }
}

