/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import ax25.KissFrame;
import common.Config;
import common.LayoutLoadException;
import fileStore.DirHole;
import fileStore.PacSatField;
import fileStore.SortedArrayList;
import java.io.IOException;
import java.util.Date;
import pacSat.frames.FrameException;
import pacSat.frames.PacSatFrame;

public class RequestDirFrame
extends PacSatFrame {
    Ax25Frame uiFrame;
    int flags;
    public static final int DIR_FILL_REQUEST = 16;
    public static final int MAX_DIR_HOLES = 29;
    long fileId;
    int blockSize = 244;
    Date frmDate;
    Date toDate;
    int[] data;

    public RequestDirFrame(String fromCall, String toCall, boolean startSending, SortedArrayList<DirHole> holes) {
        this.frameType = 30;
        int[] holedata = null;
        this.flags = 0;
        if (holes != null) {
            int h = 0;
            int holesAdded = 0;
            this.flags = 16;
            holedata = holes.size() > 29 ? new int[232] : new int[8 * holes.size()];
            for (DirHole hole : holes) {
                int[] hole_by;
                if (++holesAdded > 29) break;
                int[] nArray = hole_by = hole.getBytes();
                int n = hole_by.length;
                int n2 = 0;
                while (n2 < n) {
                    int b = nArray[n2];
                    holedata[h++] = b;
                    ++n2;
                }
            }
        }
        this.makeFrame(fromCall, toCall, startSending, holedata);
    }

    private void makeFrame(String fromCall, String toCall, boolean startSending, int[] holedata) {
        int i2;
        this.fileId = 0L;
        int[] header = new int[3];
        header[0] = this.flags;
        int[] byblock = KissFrame.littleEndian2(this.blockSize);
        header[1] = byblock[0];
        header[2] = byblock[1];
        int j1 = 0;
        this.data = holedata != null ? new int[header.length + holedata.length] : new int[header.length];
        int[] nArray = header;
        int n = header.length;
        int n2 = 0;
        while (n2 < n) {
            i2 = nArray[n2];
            this.data[j1++] = i2;
            ++n2;
        }
        if (holedata != null) {
            nArray = holedata;
            n = holedata.length;
            n2 = 0;
            while (n2 < n) {
                i2 = nArray[n2];
                this.data[j1++] = i2;
                ++n2;
            }
        }
        this.uiFrame = new Ax25Frame(fromCall, toCall, 3, 1, 189, this.data);
    }

    public RequestDirFrame(Ax25Frame ui) {
        this.frameType = 30;
        this.uiFrame = ui;
        this.data = ui.getDataBytes();
        this.flags = this.data[0];
        int[] by = new int[]{this.data[1], this.data[2]};
        this.blockSize = KissFrame.getIntFromBytes(by);
        int[] by2 = new int[]{this.data[3], this.data[4], this.data[5], this.data[6]};
        int[] by3 = new int[]{this.data[7], this.data[8], this.data[9], this.data[10]};
        long frm = KissFrame.getLongFromBytes(by2);
        long to = KissFrame.getLongFromBytes(by3);
        this.frmDate = new Date(frm * 1000L);
        this.toDate = new Date(to * 1000L);
    }

    @Override
    public int[] getBytes() {
        return this.uiFrame.getBytes();
    }

    @Override
    public String toString() {
        String s = this.toShortString();
        int h = 3;
        int j = 1;
        while (this.data.length > h) {
            int[] by2 = new int[]{this.data[h + 0], this.data[h + 1], this.data[h + 2], this.data[h + 3]};
            long frm = KissFrame.getLongFromBytes(by2);
            int[] by3 = new int[]{this.data[h + 4], this.data[h + 5], this.data[h + 6], this.data[h + 7]};
            long to = KissFrame.getLongFromBytes(by3);
            Date fDate = new Date(frm * 1000L);
            Date tDate = new Date(to * 1000L);
            s = String.valueOf(s) + "\n Hole " + j + ": " + PacSatField.getDateString(fDate) + " " + PacSatField.getDateString(tDate);
            h += 8;
            ++j;
        }
        return s;
    }

    public String toShortString() {
        String s = "";
        if (Config.getBoolean("DEBUG_DOWNLINK")) {
            this.uiFrame.headerString();
        }
        s = String.valueOf(s) + "DIR REQ: ";
        if (this.data.length > 3) {
            s = String.valueOf(s) + "HOLES: " + (this.data.length - 3) / 8 + " ";
        }
        s = String.valueOf(s) + "FLG: " + Integer.toHexString(this.flags & 0xFF);
        s = String.valueOf(s) + " BLK_SIZE: " + Long.toHexString(this.blockSize & 0xFFFFFF);
        return s;
    }

    public static final void main(String[] argc) throws FrameException, LayoutLoadException, IOException {
        Config.load();
        SortedArrayList<DirHole> holes = new SortedArrayList<DirHole>();
        int[] toBy = new int[]{255, 255, 255, 127};
        long to = KissFrame.getLongFromBytes(toBy);
        Date toDate = new Date(to * 1000L);
        Date frmDate = new Date(0L);
        DirHole hole = new DirHole(frmDate, toDate);
        holes.add(hole);
        RequestDirFrame req = new RequestDirFrame("G0KLA", "UOSAT-11", true, holes);
        System.out.println(req);
        KissFrame kss = new KissFrame(0, 0, req.getBytes());
        KissFrame decode = new KissFrame();
        int[] nArray = kss.getDataBytes();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            decode.add(b);
            System.out.print(String.valueOf(Integer.toHexString(b)) + " ");
            ++n2;
        }
        System.out.println("");
        Ax25Frame ui = new Ax25Frame(decode);
        System.out.println(ui);
        RequestDirFrame req2 = new RequestDirFrame(ui);
        System.out.println(req2);
    }
}

