/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import common.Config;
import pacSat.frames.PacSatFrame;

public class ResponseFrame
extends PacSatFrame {
    Ax25Frame uiFrame;
    int[] bytes;
    int errorCode = 0;
    public static final int FREQUENCY_SWITCHING_ON_UPLOAD = -1;
    public static final int FILE_MISSING = -2;
    public static final int FILE_MARKED_NOT_TO_DOWNLOAD = -3;
    public static final int PACKET_FORMAT_ERROR = -5;

    public ResponseFrame(Ax25Frame ui) {
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        this.frameType = 15;
        String myCall = Config.get("callsign");
        if (ui.toCallsign.startsWith(myCall)) {
            String response = Ax25Frame.makeString(this.bytes);
            if (response.startsWith("OK")) {
                this.frameType = 10;
            } else {
                this.frameType = 11;
                String[] reply = response.split(" ");
                try {
                    this.errorCode = Integer.parseInt(reply[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public int[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        String s = "";
        if (this.bytes != null) {
            int[] nArray = this.bytes;
            int n = this.bytes.length;
            int n2 = 0;
            while (n2 < n) {
                int b = nArray[n2];
                char ch = (char)b;
                s = Ax25Frame.isPrintableChar(ch) ? String.valueOf(s) + ch : String.valueOf(s) + ".";
                ++n2;
            }
        }
        return s;
    }
}

