/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import common.Config;
import pacSat.frames.PacSatFrame;

public class StatusFrame
extends PacSatFrame {
    public static final String BSTAT = "BSTAT";
    public static final String BBSTAT = "BBSTAT";
    public static final String BBCOM = "BBCOM";
    public static final String PBLIST = "PBLIST";
    public static final String PBFULL = "PBFULL";
    public static final String PBSHUT = "PBSHUT";
    public static final String STATUS = "STATUS";
    public static final String ARISS_IORS = "ARISS";
    public Ax25Frame uiFrame;
    int[] bytes;
    public int bytesReceivedOnGround;

    public StatusFrame(Ax25Frame ui) {
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        if (ui.toCallsign.startsWith(PBLIST)) {
            this.frameType = 0;
        } else if (ui.toCallsign.startsWith(PBFULL)) {
            this.frameType = 1;
        } else if (ui.toCallsign.startsWith(PBSHUT)) {
            this.frameType = 2;
        } else if (ui.toCallsign.startsWith(BBSTAT)) {
            this.frameType = 3;
        } else if (ui.toCallsign.startsWith(BBCOM)) {
            this.frameType = 3;
        } else if (ui.toCallsign.startsWith(STATUS)) {
            this.frameType = 4;
        }
    }

    public String getCall() {
        String list = Ax25Frame.makeString(this.bytes);
        String[] fields = (list = list.trim()).split("\\s+");
        if (fields.length == 4) {
            return fields[3];
        }
        return null;
    }

    public int getStatusBytesCount() {
        String list = Ax25Frame.makeString(this.bytes);
        String[] fields = (list = list.trim()).split("\\s+");
        if (fields.length == 2) {
            try {
                String[] fields2 = fields[1].split("\\.");
                int i2 = Integer.parseInt(fields2[0]);
                return i2;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public boolean containsCall() {
        String list = Ax25Frame.makeString(this.bytes);
        return list.contains(Config.get("callsign"));
    }

    @Override
    public int[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        String s = "";
        if (Config.getBoolean("DEBUG_DOWNLINK")) {
            s = String.valueOf(s) + this.uiFrame.headerString() + " ";
        }
        if (this.bytes != null) {
            int[] nArray = this.bytes;
            int n = this.bytes.length;
            int n2 = 0;
            while (n2 < n) {
                int b = nArray[n2];
                char ch = (char)b;
                s = Ax25Frame.isPrintableChar(ch) ? String.valueOf(s) + ch : String.valueOf(s) + ".";
                ++n2;
            }
        }
        return s;
    }
}

