/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import com.g0kla.telem.data.BitArrayLayout;
import com.g0kla.telem.data.BitDataRecord;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.Config;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import pacSat.frames.PacSatFrame;

public class TlmMirSatFrame
extends PacSatFrame {
    Ax25Frame uiFrame;
    Date startDate;
    long timeStamp;
    int[] bytes;
    int[] data;
    public DataRecord record;
    public DataRecord record1;
    public DataRecord record2;
    SpacecraftSettings spacecraftSettings;
    BitArrayLayout layout;
    public static final int MAX_BYTES_FRAME1 = 225;
    public static final int MAX_BYTES_FRAME2 = 137;
    int headerLength = 6;
    int preAmble = 9;
    int packetType;
    int APID;
    int sequenceCount;
    int length;
    int serviceType;
    int serviceSubType;
    int type;
    boolean hasSecondFrame = false;

    public TlmMirSatFrame(SpacecraftSettings spacecraftSettings, Ax25Frame ui) throws MalformedPfhException, LayoutLoadException, IOException {
        this.spacecraftSettings = spacecraftSettings;
        Date dt = new Date();
        this.timeStamp = dt.getTime() / 1000L;
        this.frameType = 41;
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        this.sequenceCount = this.bytes[2] & 0xFF;
        this.packetType = this.bytes[6] & 0xFF;
        this.APID = this.bytes[7] & 0xFF;
        this.serviceType = this.bytes[13] & 0xFF;
        this.serviceSubType = this.bytes[14] & 0xFF;
        this.type = this.bytes[15] & 0xFF;
        String name = "TLMI_LAYOUT";
        if (this.type == 16) {
            name = "TLM16_LAYOUT";
        }
        this.layout = (BitArrayLayout)spacecraftSettings.db.getLayoutByName(name);
        int headerLength = 6;
        int preAmble = 9;
        this.data = new int[this.layout.getMaxNumberOfBytes()];
        int p = headerLength += preAmble;
        while (p < this.bytes.length) {
            this.data[p - headerLength] = this.bytes[p];
            ++p;
        }
        this.record = null;
        if (this.type == 0) {
            BitArrayLayout layout1 = (BitArrayLayout)spacecraftSettings.db.getLayoutByName("TLM1_LAYOUT");
            int[] data1 = Arrays.copyOfRange(this.data, 0, layout1.getMaxNumberOfBytes());
            this.record1 = new BitDataRecord(layout1, 0, 0, this.timeStamp, 0, data1, false);
        }
    }

    public TlmMirSatFrame(SpacecraftSettings spacecraftSettings, int type) {
        this.spacecraftSettings = spacecraftSettings;
        Date dt = new Date();
        this.timeStamp = dt.getTime() / 1000L;
        String name = "TLMI_LAYOUT";
        if (type == 16) {
            name = "TLM16_LAYOUT";
        }
        this.layout = (BitArrayLayout)spacecraftSettings.db.getLayoutByName(name);
        this.frameType = 41;
    }

    public void parse2ndFrame(Ax25Frame ui) throws LayoutLoadException, IOException {
        int headerLength;
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        int[] data = new int[137];
        int p = headerLength = 6;
        while (p < headerLength + 137) {
            data[p - headerLength] = this.bytes[p];
            ++p;
        }
        if (this.type == 0) {
            BitArrayLayout layout2 = (BitArrayLayout)this.spacecraftSettings.db.getLayoutByName("TLM2_LAYOUT");
            this.record2 = new BitDataRecord(layout2, 0, 0, this.timeStamp, 0, data, false);
        }
    }

    public void add2ndFrame(Ax25Frame ui) {
        int headerLength;
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        int secondSequenceCount = this.bytes[2] & 0xFF;
        if (secondSequenceCount - this.sequenceCount != 1) {
            this.hasSecondFrame = false;
            return;
        }
        int p = headerLength = 6;
        while (p < headerLength + 137) {
            this.data[225 + p - headerLength] = this.bytes[p];
            ++p;
        }
        this.hasSecondFrame = true;
    }

    public DataRecord getTlm() throws LayoutLoadException, IOException {
        if (this.hasSecondFrame) {
            this.record = new BitDataRecord(this.layout, 0, 0, this.timeStamp, 0, this.data, false);
        }
        return this.record;
    }

    @Override
    public int[] getBytes() {
        return null;
    }

    @Override
    public String toString() {
        String s = "";
        if (Config.getBoolean("DEBUG_DOWNLINK")) {
            s = String.valueOf(s) + this.uiFrame.headerString();
        }
        s = String.valueOf(s) + this.uiFrame.toCallsign + " Type:" + this.packetType + " APID:" + this.APID + " Service:" + this.serviceType + ":" + this.serviceSubType + " ";
        try {
            this.record = this.getTlm();
            s = this.record != null ? String.valueOf(s) + "\n" + this.record.toString() : String.valueOf(s) + " - Corrupted CRC .. ignored ";
        }
        catch (LayoutLoadException | IOException e) {
            e.printStackTrace();
        }
        return s;
    }
}

