/*
 * Decompiled with CFR 0.152.
 */
package pacSat.frames;

import ax25.Ax25Frame;
import ax25.KissFrame;
import com.g0kla.telem.data.BitArrayLayout;
import com.g0kla.telem.data.BitDataRecord;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.Config;
import common.SpacecraftSettings;
import fileStore.MalformedPfhException;
import java.io.IOException;
import java.util.Date;
import pacSat.frames.PacSatFrame;

public class TlmPacsatFrame
extends PacSatFrame {
    Ax25Frame uiFrame;
    Date startDate;
    int reset;
    long uptime;
    int type;
    int[] bytes;
    int[] data;
    public DataRecord record;
    SpacecraftSettings spacecraftSettings;
    BitArrayLayout layout;

    public TlmPacsatFrame(SpacecraftSettings spacecraftSettings, Ax25Frame ui) throws MalformedPfhException, LayoutLoadException, IOException {
        this.spacecraftSettings = spacecraftSettings;
        this.frameType = 42;
        this.uiFrame = ui;
        this.bytes = ui.getDataBytes();
        int[] by = new int[]{this.bytes[5], this.bytes[4]};
        int[] by2 = new int[]{this.bytes[0], this.bytes[1], this.bytes[2], this.bytes[3]};
        this.uptime = KissFrame.getLongFromBytes(by2);
        if (spacecraftSettings.spacecraft.useResetUptime) {
            int[] by3 = new int[]{this.bytes[4], this.bytes[5]};
            this.reset = KissFrame.getIntFromBytes(by3);
        }
        this.layout = (BitArrayLayout)spacecraftSettings.db.getLayoutByName(ui.toCallsign.trim());
        if (this.layout == null) {
            throw new LayoutLoadException("Invalid telemetry frame destination type: " + ui.toCallsign + ".  Ignored.");
        }
        this.type = spacecraftSettings.db.getLayoutIdxByName(ui.toCallsign.trim());
        if (this.bytes.length > this.layout.getMaxNumberOfBytes()) {
            throw new LayoutLoadException("Too many bytes in Pacsat telemetry frame.  Ignored.");
        }
        this.record = new BitDataRecord(this.layout, spacecraftSettings.spacecraft.satId, this.reset, this.uptime, this.type, this.bytes, true);
    }

    public DataRecord getTlm() throws LayoutLoadException, IOException {
        this.record = new BitDataRecord(this.layout, this.spacecraftSettings.spacecraft.satId, this.reset, this.uptime, this.type, this.bytes, true);
        return this.record;
    }

    @Override
    public int[] getBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        String s = "";
        if (Config.getBoolean("DEBUG_DOWNLINK")) {
            s = String.valueOf(s) + this.uiFrame.headerString();
        }
        s = String.valueOf(s) + "PACSAT: " + this.uiFrame.toCallsign + " Type:" + this.frameType + " ";
        int i2 = 0;
        while (i2 < this.bytes.length) {
            s = String.valueOf(s) + Integer.toHexString(this.bytes[i2]) + " ";
            ++i2;
        }
        if (Config.getBoolean("DEBUG_TELEM")) {
            try {
                this.record = this.getTlm();
                s = this.record != null ? String.valueOf(s) + "\n" + this.record.toString() : String.valueOf(s) + " - Corrupted CRC .. ignored ";
            }
            catch (LayoutLoadException | IOException e) {
                e.printStackTrace();
            }
        }
        return s;
    }
}

