/*
 * Decompiled with CFR 0.152.
 */
package pacSatServer;

import com.g0kla.telem.server.STPQueue;
import common.Config;
import common.Log;
import java.io.IOException;
import java.net.UnknownHostException;

public class KissStpQueue
extends STPQueue {
    public static String KISS_STP_FILE = "kissStp.log";
    static final int serverTxPeriod = 5;
    static final int serverRetryWaitPeriod = 60;

    public KissStpQueue(String file, String server, int port) throws IOException {
        super(file, server, port);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("KISS STP QUEUE");
        this.running = true;
        boolean success = true;
        int retryStep = 0;
        while (this.running) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace(Log.getWriter());
            }
            if (!Config.getBoolean("send_to_server")) continue;
            if (!success && retryStep++ > 60) {
                success = true;
                retryStep = 0;
            }
            while (this.getSize() > 0 && success) {
                this.server.setHostName(Config.get("telem_server"));
                this.server.setPort(Config.getInt("telem_server_port"));
                Log.println("Trying Primary Server: " + this.server.getHostname() + ":" + this.server.getPort());
                try {
                    success = this.sendFrame();
                }
                catch (UnknownHostException e) {
                    Log.println("Could not connect to primary server: " + e.getMessage());
                    success = false;
                }
                catch (IOException e) {
                    Log.println(e.getMessage());
                    success = false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.println("ERROR: server DUV frame queue thread interrupted");
                e.printStackTrace(Log.getWriter());
            }
        }
        Log.println("Server Queue thread ended");
    }
}

