/*
 * Decompiled with CFR 0.152.
 */
package pacSatServer;

import com.g0kla.telem.segDb.SatDbStore;
import com.g0kla.telem.server.STP;
import common.Config;
import common.Log;
import gui.MainWindow;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pacSat.FrameDecoder;
import pacSat.TncDecoder;

public class TcpTncServer
extends TncDecoder {
    int portNumber;
    int poolSize = 1;
    ServerSocket socket = null;
    String user;
    String password;
    String database;

    public TcpTncServer(int port, FrameDecoder frameDecoder, MainWindow ta, String user, String password, String database) {
        super(frameDecoder, ta);
        this.portNumber = port;
        this.user = user;
        this.password = password;
        this.database = database;
    }

    @Override
    protected void process() {
        ServerSocket serverSocket = null;
        boolean listening = true;
        ExecutorService pool = null;
        try {
            serverSocket = new ServerSocket(this.portNumber);
            pool = Executors.newFixedThreadPool(this.poolSize);
        }
        catch (IOException e) {
            Log.println("Could not listen on port: " + this.portNumber);
            Log.alert("FATAL: Could not listen on port: " + this.portNumber);
        }
        while (listening) {
            try {
                Log.println("Waiting for connection ...");
                pool.execute(new ServerProcess(serverSocket.accept()));
            }
            catch (SocketTimeoutException s) {
                Log.println("Socket timed out! - trying to continue\t");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException e) {
                e.printStackTrace(Log.getWriter());
                Log.println("Socket Error: waiting to see if we recover: " + e.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            serverSocket.close();
            pool.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace(Log.getWriter());
        }
    }

    @Override
    public void close() {
        this.running = false;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    @Override
    protected void kissOn() throws IOException {
    }

    @Override
    protected void kissOff() throws IOException {
    }

    @Override
    protected void txFrame(int[] bytes) throws UnknownHostException, IOException {
    }

    class ServerProcess
    implements Runnable {
        private Socket socket = null;

        ServerProcess(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            block26: {
                InputStream in;
                block25: {
                    Thread.currentThread().setName("TcpTncServer");
                    Log.println("Started Thread to handle connection from: " + this.socket.getInetAddress());
                    SatDbStore db = null;
                    try {
                        db = new SatDbStore(TcpTncServer.this.user, TcpTncServer.this.password, TcpTncServer.this.database);
                    }
                    catch (SQLException e3) {
                        Log.println("" + e3);
                    }
                    in = null;
                    byte[] receivedData = new byte[4096];
                    try {
                        try {
                            in = this.socket.getInputStream();
                            int len = in.read(receivedData);
                            if (receivedData == null || len <= 0) break block25;
                            int[] stpData = new int[len];
                            int j = 0;
                            while (j < len) {
                                int i2 = receivedData[j] & 0xFF;
                                TcpTncServer.this.decoder.decodeByte(i2);
                                stpData[j] = i2;
                                ++j;
                            }
                            STP stp = new STP(stpData);
                            if (db != null) {
                                try {
                                    db.addStpHeader(stp);
                                }
                                catch (SQLException e1) {
                                    Log.println("ERROR: FAILED TO WRITE STP RECORD\n" + e1);
                                }
                            }
                            if (Config.getBoolean("kiss_logging")) {
                                try {
                                    TcpTncServer.this.byteFile.write(receivedData);
                                }
                                catch (IOException e) {
                                    Log.errorDialog("ERROR", "Could not write the KISS logfile:\n" + e.getMessage());
                                }
                            }
                        }
                        catch (IOException e1) {
                            Log.println("Error in receiving bytes from TCP-port: " + e1.getMessage());
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                this.socket.close();
                            }
                            catch (Exception exception) {}
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            this.socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Log.println("Stopping Server Process thread");
        }
    }
}

