/*
 * Decompiled with CFR 0.152.
 */
package passControl;

import ax25.Ax25Frame;
import ax25.KissFrame;
import com.g0kla.telem.data.DataLoadException;
import com.g0kla.telem.data.DataRecord;
import com.g0kla.telem.data.LayoutLoadException;
import common.Config;
import common.Log;
import common.SpacecraftSettings;
import fileStore.DirHole;
import fileStore.FileHole;
import fileStore.MalformedPfhException;
import fileStore.PacSatFile;
import fileStore.SortedArrayList;
import gui.MainWindow;
import java.io.IOException;
import java.util.Date;
import pacSat.frames.BroadcastDirFrame;
import pacSat.frames.BroadcastFileFrame;
import pacSat.frames.CmdFrame;
import pacSat.frames.PacSatFrame;
import pacSat.frames.PacSatPrimative;
import pacSat.frames.RequestDirFrame;
import pacSat.frames.RequestFileFrame;
import pacSat.frames.ResponseFrame;
import pacSat.frames.StatusFrame;
import pacSat.frames.TlmFrame;
import pacSat.frames.TlmMirSatFrame;
import pacSat.frames.TlmPacsatFrame;
import passControl.PacsatStateMachine;

public class DownlinkStateMachine
extends PacsatStateMachine
implements Runnable {
    public static final int DL_LISTEN = 0;
    public static final int DL_PB_OPEN = 1;
    public static final int DL_ON_PB = 2;
    public static final int DL_WAIT = 3;
    public static final int DL_PB_FULL = 4;
    public static final int DL_PB_SHUT = 5;
    public static final int LOOP_TIME = 1;
    boolean needDir = true;
    Date lastChecked = null;
    public static final int DIR_CHECK_INTERVAL = 60;
    public static final int TIMER_T4 = 60000;
    int t4_timer;
    int bytesAtLastStatus = 0;
    public static final String[] states = new String[]{"Listening", "PB Avail", "ON PB", "Waiting", "PB Full", "PB Shut"};
    String pbList = "";

    public DownlinkStateMachine(SpacecraftSettings sat) {
        super(sat);
        this.state = 0;
    }

    public void setSpacecraft(SpacecraftSettings spacecraftSettings) {
        this.spacecraft = spacecraftSettings;
    }

    @Override
    public void processEvent(PacSatPrimative frame) {
        if (frame == null) {
            return;
        }
        this.DEBUG("Adding DOWN LINK Event: " + frame.toString());
        this.frameEventQueue.add(frame);
    }

    @Override
    protected void nextState(PacSatPrimative prim) {
        if (!Config.getBoolean("downlink_enabled")) {
            this.state = 0;
            return;
        }
        if (prim instanceof PacSatFrame) {
            PacSatFrame frame = (PacSatFrame)prim;
            switch (frame.frameType) {
                case 4: {
                    String bytes = Ax25Frame.makeString(frame.getBytes());
                    int by = ((StatusFrame)frame).getStatusBytesCount();
                    if (this.bytesAtLastStatus != 0) {
                        int bytesSentBySpacecraft = by - this.bytesAtLastStatus;
                        Config.mainWindow.setEfficiency(this.spacecraft.name, bytesSentBySpacecraft, ((StatusFrame)frame).bytesReceivedOnGround);
                    }
                    this.bytesAtLastStatus = by;
                    this.startT4();
                    break;
                }
                case 1: {
                    this.state = 4;
                    this.startT4();
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                    if (MainWindow.frame == null) break;
                    MainWindow.setPBStatus(this.spacecraft.name, this.pbList);
                    break;
                }
                case 2: {
                    this.state = 5;
                    this.startT4();
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                    if (MainWindow.frame == null) break;
                    MainWindow.setPBStatus(this.spacecraft.name, this.pbList);
                    break;
                }
                case 20: {
                    BroadcastDirFrame bd = (BroadcastDirFrame)frame;
                    this.processBroadcastDir(bd);
                    break;
                }
                case 21: {
                    BroadcastFileFrame bf = (BroadcastFileFrame)frame;
                    this.processBroadcastFile(bf);
                    break;
                }
                case 41: {
                    TlmMirSatFrame tlmmir = (TlmMirSatFrame)frame;
                    if (tlmmir.record != null) {
                        this.processTelem(tlmmir.record);
                    }
                    if (tlmmir.record1 != null) {
                        this.processTelem(tlmmir.record1);
                    }
                    if (tlmmir.record2 == null) break;
                    this.processTelem(tlmmir.record2);
                    break;
                }
                case 42: {
                    TlmPacsatFrame tlmp = (TlmPacsatFrame)frame;
                    this.processTelem(tlmp.record);
                    break;
                }
                case 40: {
                    TlmFrame tlm = (TlmFrame)frame;
                    this.processTelem(tlm.record);
                    break;
                }
            }
            switch (this.state) {
                case 0: {
                    this.stateInit(frame);
                    break;
                }
                case 1: {
                    this.statePbOpen(frame);
                    break;
                }
                case 2: {
                    this.stateOnPb(frame);
                    break;
                }
                case 3: {
                    this.stateWait(frame);
                    break;
                }
                case 4: {
                    this.stateInit(frame);
                    break;
                }
                case 5: {
                    this.stateInit(frame);
                    break;
                }
            }
        }
    }

    private void stateInit(PacSatFrame frame) {
        switch (frame.frameType) {
            case 0: {
                this.startT4();
                if (((StatusFrame)frame).containsCall()) {
                    this.state = 2;
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                } else {
                    this.state = 1;
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                }
                if (MainWindow.frame == null) break;
                MainWindow.setPBStatus(this.spacecraft.name, this.pbList);
                break;
            }
            case 33: {
                this.retries = 0;
                this.lastCommand = null;
                this.state = 0;
                break;
            }
            case 10: {
                this.startT4();
                this.waitTimer = 0;
                this.retries = 0;
                this.lastCommand = null;
                break;
            }
            case 11: {
                this.startT4();
                this.waitTimer = 0;
                this.retries = 0;
                this.lastCommand = null;
                break;
            }
            case 30: {
                this.startT4();
                RequestDirFrame dirFrame = (RequestDirFrame)frame;
                KissFrame kss = new KissFrame(0, 0, dirFrame.getBytes());
                this.PRINT("TX: " + dirFrame.toShortString() + " ... ");
                if (this.tncDecoder != null) {
                    this.state = 3;
                    this.waitTimer = 0;
                    this.lastCommand = dirFrame;
                    this.tncDecoder.sendFrame(kss.getDataBytes(), false);
                    break;
                }
                this.PRINT("Nothing was transmitted as no TNC is connected\n ");
                break;
            }
            case 31: {
                this.startT4();
                RequestFileFrame fileFrame = (RequestFileFrame)frame;
                KissFrame kssFile = new KissFrame(0, 0, fileFrame.getBytes());
                this.PRINT("DL SENDING: " + fileFrame.toString() + " ... ");
                if (this.tncDecoder != null) {
                    this.state = 3;
                    this.waitTimer = 0;
                    this.lastCommand = fileFrame;
                    this.tncDecoder.sendFrame(kssFile.getDataBytes(), false);
                    break;
                }
                this.PRINT("Nothing was transmitted as no TNC is connected\n ");
                break;
            }
            case 32: {
                this.startT4();
                CmdFrame cmdFrame = (CmdFrame)frame;
                KissFrame kssCmd = new KissFrame(0, 0, cmdFrame.getBytes());
                this.PRINT("TX: " + cmdFrame.toString() + " ... ");
                if (this.tncDecoder != null) {
                    this.state = 3;
                    this.waitTimer = 0;
                    this.lastCommand = cmdFrame;
                    this.tncDecoder.sendFrame(kssCmd.getDataBytes(), false);
                    break;
                }
                this.PRINT("Nothing was transmitted as no TNC is connected\n ");
            }
        }
    }

    private void statePbOpen(PacSatFrame frame) {
        switch (frame.frameType) {
            case 30: {
                this.startT4();
                RequestDirFrame dirFrame = (RequestDirFrame)frame;
                KissFrame kss = new KissFrame(0, 0, dirFrame.getBytes());
                this.PRINT("TX: " + dirFrame.toShortString() + " ... ");
                if (this.tncDecoder != null) {
                    this.state = 3;
                    this.waitTimer = 0;
                    this.lastCommand = dirFrame;
                    this.tncDecoder.sendFrame(kss.getDataBytes(), false);
                    break;
                }
                this.PRINT("Nothing was transmitted as no TNC is connected\n ");
                break;
            }
            case 31: {
                this.startT4();
                RequestFileFrame fileFrame = (RequestFileFrame)frame;
                KissFrame kssFile = new KissFrame(0, 0, fileFrame.getBytes());
                this.PRINT("DL SENDING: " + fileFrame.toString() + " ... ");
                if (this.tncDecoder != null) {
                    this.state = 3;
                    this.waitTimer = 0;
                    this.lastCommand = fileFrame;
                    this.tncDecoder.sendFrame(kssFile.getDataBytes(), false);
                    break;
                }
                this.PRINT("Nothing was transmitted as no TNC is connected\n ");
                break;
            }
            case 32: {
                this.startT4();
                CmdFrame cmdFrame = (CmdFrame)frame;
                KissFrame kssCmd = new KissFrame(0, 0, cmdFrame.getBytes());
                this.PRINT("TX: " + cmdFrame.toString() + " ... ");
                if (this.tncDecoder != null) {
                    this.state = 3;
                    this.waitTimer = 0;
                    this.lastCommand = cmdFrame;
                    this.tncDecoder.sendFrame(kssCmd.getDataBytes(), false);
                    break;
                }
                this.PRINT("Nothing was transmitted as no TNC is connected\n ");
                break;
            }
            case 0: {
                this.startT4();
                if (((StatusFrame)frame).containsCall()) {
                    this.state = 2;
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                } else {
                    this.state = 1;
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                }
                if (MainWindow.frame == null) break;
                MainWindow.setPBStatus(this.spacecraft.name, this.pbList);
                break;
            }
            case 10: {
                this.startT4();
                this.state = 2;
                this.lastCommand = null;
                this.retries = 0;
                break;
            }
            case 33: {
                this.state = 0;
                this.lastCommand = null;
                this.retries = 0;
                break;
            }
        }
    }

    private void stateOnPb(PacSatFrame frame) {
        switch (frame.frameType) {
            case 30: {
                this.PRINT("Ignored DIR REQ: Wait until your current PB ssession has completed before requesting another directory");
                break;
            }
            case 31: {
                this.PRINT("Ignored FILE REQ: Wait until your current PB ssession has completed before requesting a file");
                break;
            }
            case 0: {
                this.startT4();
                if (((StatusFrame)frame).containsCall()) {
                    this.state = 2;
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                } else {
                    this.state = 1;
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                }
                if (MainWindow.frame == null) break;
                MainWindow.setPBStatus(this.spacecraft.name, this.pbList);
            }
        }
        switch (frame.frameType) {
            case 32: {
                this.startT4();
                CmdFrame cmdFrame = (CmdFrame)frame;
                KissFrame kssCmd = new KissFrame(0, 0, cmdFrame.getBytes());
                this.PRINT("TX: " + cmdFrame.toString() + " ... ");
                if (this.tncDecoder != null) {
                    this.state = 3;
                    this.waitTimer = 0;
                    this.lastCommand = cmdFrame;
                    this.tncDecoder.sendFrame(kssCmd.getDataBytes(), false);
                    break;
                }
                this.PRINT("Nothing was transmitted as no TNC is connected\n ");
            }
        }
    }

    private void stateWait(PacSatFrame frame) {
        switch (frame.frameType) {
            case 33: {
                this.state = 0;
                this.lastCommand = null;
                this.retries = 0;
                break;
            }
            case 10: {
                this.startT4();
                this.state = 2;
                this.waitTimer = 0;
                this.lastCommand = null;
                this.retries = 0;
                break;
            }
            case 11: {
                this.startT4();
                ResponseFrame sf = (ResponseFrame)frame;
                if (sf.getErrorCode() == -2 || sf.getErrorCode() == -3) {
                    if (this.lastCommand.frameType == 31) {
                        RequestFileFrame rf = (RequestFileFrame)this.lastCommand;
                        this.spacecraft.directory.setPriority(rf.fileId, sf.getErrorCode());
                        String[][] data = this.spacecraft.directory.getTableData();
                        if (data.length > 0 && Config.mainWindow != null) {
                            MainWindow.setDirectoryData(this.spacecraft.name, data);
                        }
                    }
                } else {
                    sf.getErrorCode();
                }
                this.state = 0;
                this.waitTimer = 0;
                this.lastCommand = null;
                this.retries = 0;
                break;
            }
            case 0: {
                this.startT4();
                if (((StatusFrame)frame).containsCall()) {
                    this.state = 2;
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                } else {
                    this.pbList = Ax25Frame.makeString(frame.getBytes());
                }
                MainWindow.setPBStatus(this.spacecraft.name, this.pbList);
                break;
            }
        }
    }

    public boolean needDir() {
        long minsLatest;
        if (this.lastChecked == null) {
            this.lastChecked = new Date();
            this.PRINT("First pass since starting. Requesting dir ..");
            return true;
        }
        Date timeNow = new Date();
        long minsNow = timeNow.getTime() / 60000L;
        long diff = minsNow - (minsLatest = this.lastChecked.getTime() / 60000L);
        if (diff > 60L) {
            this.PRINT("Have not checked for an hour or more. Requesting dir ..");
            this.lastChecked = new Date();
            return true;
        }
        return false;
    }

    private void processBroadcastFile(BroadcastFileFrame bf) {
        String[][] data;
        boolean updated;
        block9: {
            if (this.spacecraft == null) {
                Log.errorDialog("ERROR", " No Spacecraft for file chunk for: " + bf + "\n");
            }
            String s = "";
            updated = false;
            try {
                updated = this.spacecraft.directory.add(bf);
            }
            catch (NumberFormatException e) {
                s = "ERROR: Number Format issue with telemetry " + e.getMessage();
            }
            catch (LayoutLoadException e) {
                s = "ERROR: Opening Layout " + e.getMessage();
            }
            catch (DataLoadException e) {
                s = "ERROR: Loading Data " + e.getMessage();
            }
            catch (IOException e) {
                if (bf != null) {
                    s = "ERROR: Writing received file chunk for: " + bf + "\n" + e.getMessage();
                    this.PRINT(s);
                }
            }
            catch (MalformedPfhException e) {
                if (bf == null) break block9;
                s = "ERROR: Bad PFH - " + e.getMessage() + ": " + bf.toString();
                this.DEBUG(s);
            }
        }
        if (updated && (data = this.spacecraft.directory.getTableData()).length > 0 && Config.mainWindow != null) {
            MainWindow.setDirectoryData(this.spacecraft.name, data);
        }
    }

    private void processBroadcastDir(BroadcastDirFrame bd) {
        String[][] data;
        boolean updated;
        block4: {
            if (this.spacecraft == null) {
                Log.errorDialog("ERROR", " No Spacecraft for file chunk for: " + bd + "\n");
            }
            String s = bd.toString();
            updated = false;
            try {
                updated = this.spacecraft.directory.add(bd);
            }
            catch (IOException e) {
                if (bd == null) break block4;
                s = "ERROR: Writing received file chunk for: " + bd + "\n" + e.getMessage();
                this.PRINT(s);
            }
        }
        if (updated && (data = this.spacecraft.directory.getTableData()).length > 0 && Config.mainWindow != null && this.spacecraft != null) {
            MainWindow.setDirectoryData(this.spacecraft.name, data);
        }
    }

    private void processTelem(DataRecord tlm) {
        try {
            this.spacecraft.db.add(tlm);
            this.PRINT("TELEM FRAME: " + tlm.resets + ":" + tlm.uptime + " Type: " + tlm.layout.name + " - " + tlm.type);
            if (Config.getBoolean("DEBUG_TELEM")) {
                String s = tlm.toString();
                this.PRINT(s);
            }
        }
        catch (NumberFormatException e) {
            this.PRINT("ERROR: Number parse for: " + tlm + " " + e.getMessage());
        }
        catch (DataLoadException e) {
            this.PRINT("ERROR: Loading data for: " + tlm + " " + e.getMessage());
        }
        catch (IOException e) {
            this.PRINT("ERROR: Writing received file chunk for: " + tlm + "\n" + e.getMessage());
        }
    }

    public void stopRunning() {
        this.running = false;
    }

    private void DEBUG(String s) {
        s = "DEBUG DL: " + states[this.state] + ": " + s;
        if (Config.getBoolean("DEBUG_DOWNLINK")) {
            if (this.ta != null) {
                this.ta.append(String.valueOf(s) + "\n");
            }
            Log.println(s);
        }
    }

    private void PRINT(String s) {
        if (this.ta != null) {
            this.ta.append(String.valueOf(s) + "\n");
        }
        Log.println(s);
    }

    private void startT4() {
        this.t4_timer = 1;
    }

    private void stopT4() {
        this.t4_timer = 0;
    }

    @Override
    public void run() {
        this.DEBUG("STARTING DL Thread");
        Thread.currentThread().setName("DownlinkStateMachine: " + this.spacecraft.name);
        while (this.running) {
            if (this.t4_timer > 0) {
                ++this.t4_timer;
                if (this.t4_timer > 60000) {
                    this.t4_timer = 0;
                    this.DEBUG("Downlink T4 expired - back to listening");
                    this.state = 0;
                    this.retries = 0;
                    this.lastCommand = null;
                }
            }
            if (this.frameEventQueue.size() > 0) {
                this.nextState((PacSatPrimative)this.frameEventQueue.poll());
            } else if (this.state == 3) {
                ++this.waitTimer;
                if (this.waitTimer * 1 >= 5000) {
                    this.waitTimer = 0;
                    ++this.retries;
                    if (this.retries > 10) {
                        this.state = 0;
                        if (this.lastCommand instanceof RequestDirFrame) {
                            this.lastChecked = null;
                        }
                        this.retries = 0;
                    } else {
                        this.state = 1;
                        this.processEvent(this.lastCommand);
                    }
                }
            } else if (this.state == 1 && !Config.getBoolean("tx_inhibit")) {
                RequestDirFrame dirFrame;
                SortedArrayList<DirHole> holes;
                if (this.spacecraft.getBoolean("request_directory") && this.needDir()) {
                    holes = this.spacecraft.directory.getHolesList();
                    if (holes != null) {
                        this.DEBUG("Requesting " + holes.size() + " holes for directory");
                        dirFrame = new RequestDirFrame(Config.get("callsign"), this.spacecraft.get("broadcastCallsign"), true, holes);
                        this.processEvent(dirFrame);
                    } else {
                        Log.errorDialog("ERROR", "Something has gone wrong and the directory holes file is missing or corrupt\nCan't request the directory\n");
                    }
                } else if (this.spacecraft.getBoolean("request_files") && this.spacecraft.directory.needFile()) {
                    long fileId = this.spacecraft.directory.getMostUrgentFile();
                    if (fileId != 0L) {
                        PacSatFile pf = new PacSatFile(this.spacecraft, this.spacecraft.directory.dirFolder, fileId);
                        SortedArrayList<FileHole> holes2 = pf.getHolesList();
                        this.PRINT("Requesting file " + Long.toHexString(fileId));
                        RequestFileFrame fileFrame = new RequestFileFrame(Config.get("callsign"), this.spacecraft.get("broadcastCallsign"), true, fileId, holes2);
                        this.spacecraft.downlink.processEvent(fileFrame);
                    }
                } else if (this.spacecraft.getBoolean("fill_directory_holes") && this.spacecraft.directory.hasHoles()) {
                    holes = this.spacecraft.directory.getHolesList();
                    if (holes != null) {
                        this.DEBUG("We have dir holes. Requesting dir ..");
                        this.DEBUG("Requesting " + holes.size() + " holes for directory");
                        dirFrame = new RequestDirFrame(Config.get("callsign"), this.spacecraft.get("broadcastCallsign"), true, holes);
                        this.processEvent(dirFrame);
                    } else {
                        Log.errorDialog("ERROR", "Something has gone wrong and the directory holes file is missing or corrupt\nCan't request the directory\n");
                    }
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (Config.mainWindow == null) continue;
            MainWindow.setDownlinkStatus(this.spacecraft.name, states[this.state]);
        }
        this.DEBUG("EXIT DL Thread");
    }
}

