/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.me.g4dpz.satellite.GroundStationPosition;
import uk.me.g4dpz.satellite.InvalidTleException;
import uk.me.g4dpz.satellite.SatNotFoundException;
import uk.me.g4dpz.satellite.SatPassTime;
import uk.me.g4dpz.satellite.SatPos;
import uk.me.g4dpz.satellite.Satellite;
import uk.me.g4dpz.satellite.SatelliteFactory;
import uk.me.g4dpz.satellite.TLE;

public class PassPredictor {
    private static final String UTC = "UTC";
    private static final String SOUTH = "south";
    private static final String NORTH = "north";
    private static final double SPEED_OF_LIGHT = 2.99792458E8;
    private static final double TWOPI = Math.PI * 2;
    private static final String DEADSPOT_NONE = "none";
    static final TimeZone TZ = TimeZone.getTimeZone("UTC");
    private static Log log = LogFactory.getLog(PassPredictor.class);
    private boolean newTLE = true;
    private final TLE tle;
    private final GroundStationPosition qth;
    private Satellite sat;
    private boolean windBackTime;
    private final double meanMotion;
    private int iterationCount;
    private Date tca;

    public PassPredictor(TLE theTLE, GroundStationPosition theQTH) throws IllegalArgumentException, InvalidTleException, SatNotFoundException {
        if (theTLE == null) {
            throw new IllegalArgumentException("TLE has not been set");
        }
        if (theQTH == null) {
            throw new IllegalArgumentException("QTH has not been set");
        }
        this.tle = theTLE;
        this.qth = theQTH;
        this.newTLE = true;
        this.validateData();
        this.meanMotion = theTLE.getMeanmo();
    }

    public Long getDownlinkFreq(Long freq, Date date) throws InvalidTleException, SatNotFoundException {
        this.validateData();
        Calendar cal = Calendar.getInstance(TZ);
        cal.clear();
        cal.setTimeInMillis(date.getTime());
        SatPos satPos = this.getSatPos(cal.getTime());
        double rangeRate = satPos.getRangeRate();
        return (long)((double)freq.longValue() * (2.99792458E8 - rangeRate * 1000.0) / 2.99792458E8);
    }

    private SatPos getSatPos(Date time) throws InvalidTleException, SatNotFoundException {
        ++this.iterationCount;
        return this.sat.getPosition(this.qth, time);
    }

    public Long getUplinkFreq(Long freq, Date date) throws InvalidTleException, SatNotFoundException {
        this.validateData();
        Calendar cal = Calendar.getInstance(TZ);
        cal.clear();
        cal.setTimeInMillis(date.getTime());
        SatPos satPos = this.getSatPos(cal.getTime());
        double rangeRate = satPos.getRangeRate();
        return (long)((double)freq.longValue() * (2.99792458E8 + rangeRate * 1000.0) / 2.99792458E8);
    }

    public SatPassTime nextSatPass(Date date) throws InvalidTleException, SatNotFoundException {
        return this.nextSatPass(date, false);
    }

    public SatPassTime nextSatPass(Date date, boolean windBack) throws InvalidTleException, SatNotFoundException {
        Date now;
        double elevation;
        Date now2;
        SatPos satPos;
        double maxElevation = 0.0;
        this.validateData();
        String polePassed = DEADSPOT_NONE;
        Calendar cal = Calendar.getInstance(TZ);
        cal.clear();
        cal.setTimeInMillis(date.getTime());
        if (windBack) {
            cal.add(12, (int)(-1440.0 / this.meanMotion / 4.0));
        }
        SatPos prevPos = satPos = this.getSatPos(cal.getTime());
        if (satPos.getElevation() > 0.0) {
            while ((satPos = this.getPosition(cal, 60)).getElevation() > 0.0) {
            }
            cal.add(12, this.threeQuarterOrbitMinutes());
        }
        do {
            satPos = this.getPosition(cal, 60);
            now2 = cal.getTime();
            elevation = satPos.getElevation();
            if (!(elevation > maxElevation)) continue;
            maxElevation = elevation;
            this.tca = now2;
        } while (satPos.getElevation() < 0.0);
        cal.add(13, -60);
        do {
            satPos = this.getPosition(cal, 5);
            now2 = cal.getTime();
            elevation = satPos.getElevation();
            if (elevation > maxElevation) {
                maxElevation = elevation;
                this.tca = now2;
            }
            prevPos = satPos;
        } while (satPos.getElevation() < 0.0);
        Date startDate = satPos.getTime();
        int aosAzimuth = (int)(satPos.getAzimuth() / (Math.PI * 2) * 360.0);
        do {
            satPos = this.getPosition(cal, 30);
            now = cal.getTime();
            String currPolePassed = this.getPolePassed(prevPos, satPos);
            if (!currPolePassed.equals(DEADSPOT_NONE)) {
                polePassed = currPolePassed;
            }
            log.debug("Current pole passed: " + polePassed);
            elevation = satPos.getElevation();
            if (elevation > maxElevation) {
                maxElevation = elevation;
                this.tca = now;
            }
            prevPos = satPos;
        } while (satPos.getElevation() > 0.0);
        this.newTLE = true;
        this.validateData();
        cal.add(13, -30);
        do {
            satPos = this.getPosition(cal, 5);
            now = cal.getTime();
            elevation = satPos.getElevation();
            if (!(elevation > maxElevation)) continue;
            maxElevation = elevation;
            this.tca = now;
        } while (satPos.getElevation() > 0.0);
        Date endDate = satPos.getTime();
        int losAzimuth = (int)(satPos.getAzimuth() / (Math.PI * 2) * 360.0);
        return new SatPassTime(startDate, endDate, this.tca, polePassed, aosAzimuth, losAzimuth, maxElevation / (Math.PI * 2) * 360.0);
    }

    private SatPos getPosition(Calendar cal, int offSet) throws InvalidTleException, SatNotFoundException {
        cal.add(13, offSet);
        SatPos satPos = this.getSatPos(cal.getTime());
        return satPos;
    }

    public List<SatPassTime> getPasses(Date start, int hoursAhead, boolean windBack) throws InvalidTleException, SatNotFoundException {
        Date lastAOS;
        this.iterationCount = 0;
        this.windBackTime = windBack;
        ArrayList<SatPassTime> passes = new ArrayList<SatPassTime>();
        Date trackStartDate = start;
        Date trackEndDate = new Date(start.getTime() + (long)hoursAhead * 60L * 60L * 1000L);
        int count = 0;
        do {
            if (count > 0) {
                this.windBackTime = false;
            }
            SatPassTime pass = this.nextSatPass(trackStartDate, this.windBackTime);
            lastAOS = pass.getStartTime();
            passes.add(pass);
            trackStartDate = new Date(pass.getEndTime().getTime() + (long)this.threeQuarterOrbitMinutes() * 60L * 1000L);
            ++count;
        } while (lastAOS.compareTo(trackEndDate) < 0);
        return passes;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    private void validateData() throws InvalidTleException, SatNotFoundException {
        if (this.newTLE) {
            this.sat = SatelliteFactory.createSatellite(this.tle);
            if (this.sat == null) {
                throw new SatNotFoundException("Satellite has not been created");
            }
            if (!this.sat.willBeSeen(this.qth)) {
                throw new SatNotFoundException("Satellite will never appear above the horizon");
            }
            this.newTLE = false;
        }
    }

    private int threeQuarterOrbitMinutes() {
        return (int)(1440.0 / this.tle.getMeanmo() * 0.75);
    }

    private String getPolePassed(SatPos prevPos, SatPos satPos) {
        double az2;
        String polePassed = DEADSPOT_NONE;
        double az1 = prevPos.getAzimuth() / (Math.PI * 2) * 360.0;
        if (az1 > (az2 = satPos.getAzimuth() / (Math.PI * 2) * 360.0)) {
            if (az1 > 350.0 && az2 < 10.0) {
                polePassed = NORTH;
            } else if (az1 > 180.0 && az2 < 180.0) {
                polePassed = SOUTH;
            }
        } else if (az1 < 10.0 && az2 > 350.0) {
            polePassed = NORTH;
        } else if (az1 < 180.0 && az2 > 180.0) {
            polePassed = SOUTH;
        }
        return polePassed;
    }

    public List<SatPos> getPositions(Date referenceDate, int incrementSeconds, int minutesBefore, int minutesAfter) throws InvalidTleException, SatNotFoundException {
        Date trackDate = new Date(referenceDate.getTime() - (long)minutesBefore * 60L * 1000L);
        Date endDateDate = new Date(referenceDate.getTime() + (long)minutesAfter * 60L * 1000L);
        ArrayList<SatPos> positions = new ArrayList<SatPos>();
        while (trackDate.before(endDateDate)) {
            positions.add(this.getSatPos(trackDate));
            trackDate = new Date(trackDate.getTime() + (long)(incrementSeconds * 1000));
        }
        return positions;
    }
}

