/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import java.util.List;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.me.g4dpz.satellite.AbstractSatelliteTestBase;
import uk.me.g4dpz.satellite.InvalidTleException;
import uk.me.g4dpz.satellite.PassPredictor;
import uk.me.g4dpz.satellite.SatNotFoundException;
import uk.me.g4dpz.satellite.SatPassTime;
import uk.me.g4dpz.satellite.SatPos;
import uk.me.g4dpz.satellite.TLE;

public class PassPredictorTest
extends AbstractSatelliteTestBase {
    private static final String DATE_2009_01_05T04_30_00Z = "2009-01-05T04:30:00Z";
    private static final String DATE_2009_01_05T04_32_15_0000 = "2009-01-05T04:32:15+0000";
    private static final String DATE_2009_01_05T04_28_10_0000 = "2009-01-05T04:28:10+0000";
    private static final String DATE_2009_01_05T07_00_00Z = "2009-01-05T07:00:00Z";
    private static final String NORTH = "north";
    private static final String STRING_PAIR = "%s, %s";
    private static final String NONE = "none";
    private static final String INVALID_TLE_EXCEPTION_WAS_THROWN = "InvalidTleException was thrown";
    private static final String SAT_NOT_FOUND_EXCEPTION_WAS_THROWN = "SatNotFoundException was thrown";
    private static final String INVALID_TLE_EXCEPTION_WAS_NOT_THROWN = "InvalidTleException was not thrown";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIllegalArgumentsInConstructor() {
        try {
            new PassPredictor(null, null);
            Assert.fail(INVALID_TLE_EXCEPTION_WAS_NOT_THROWN);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvalidTleException e) {
            Assert.fail(e.getMessage());
        }
        catch (SatNotFoundException e) {
            Assert.fail(e.getMessage());
        }
        try {
            new PassPredictor(new TLE(LEO_TLE), null);
            Assert.fail(INVALID_TLE_EXCEPTION_WAS_NOT_THROWN);
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvalidTleException e) {
            Assert.fail(e.getMessage());
        }
        catch (SatNotFoundException e) {
            Assert.fail(e.getMessage());
        }
    }

    @Test
    public final void testNextSatPass() {
        TLE tle = new TLE(LEO_TLE);
        Assert.assertTrue(!tle.isDeepspace());
        try {
            PassPredictor passPredictor = new PassPredictor(tle, GROUND_STATION);
            DateTime cal = new DateTime("2009-01-05T00:00:00Z");
            SatPassTime passTime = passPredictor.nextSatPass(cal.toDate());
            Assert.assertEquals(DATE_2009_01_05T04_28_10_0000, TZ_FORMAT.format(passTime.getStartTime()));
            Assert.assertEquals(DATE_2009_01_05T04_32_15_0000, TZ_FORMAT.format(passTime.getEndTime()));
            Assert.assertEquals("2009-01-05T04:30:10+0000", TZ_FORMAT.format(passTime.getTCA()));
            Assert.assertEquals(NONE, passTime.getPolePassed());
            Assert.assertEquals(52L, passTime.getAosAzimuth());
            Assert.assertEquals(84L, passTime.getLosAzimuth());
            Assert.assertEquals("0.9", String.format("%3.1f", passTime.getMaxEl()));
            Assert.assertEquals((Object)436802379L, passPredictor.getDownlinkFreq(436800000L, passTime.getStartTime()));
            Assert.assertEquals((Object)145800719L, passPredictor.getUplinkFreq(145800000L, passTime.getEndTime()));
            passTime = passPredictor.nextSatPass(passTime.getStartTime());
            Assert.assertEquals("2009-01-05T06:04:00+0000", TZ_FORMAT.format(passTime.getStartTime()));
            Assert.assertEquals("2009-01-05T06:18:00+0000", TZ_FORMAT.format(passTime.getEndTime()));
            Assert.assertEquals(NONE, passTime.getPolePassed());
            Assert.assertEquals(22L, passTime.getAosAzimuth());
            Assert.assertEquals(158L, passTime.getLosAzimuth());
            Assert.assertEquals(24.42, passTime.getMaxEl(), 0.02);
            passTime = passPredictor.nextSatPass(passTime.getStartTime());
            Assert.assertEquals("2009-01-05T07:42:45+0000", TZ_FORMAT.format(passTime.getStartTime()));
            Assert.assertEquals("2009-01-05T07:57:50+0000", TZ_FORMAT.format(passTime.getEndTime()));
            Assert.assertEquals(NORTH, passTime.getPolePassed());
            Assert.assertEquals(11L, passTime.getAosAzimuth());
            Assert.assertEquals(207L, passTime.getLosAzimuth());
            Assert.assertEquals("62.19", String.format("%5.2f", passTime.getMaxEl()));
            passTime = passPredictor.nextSatPass(passTime.getStartTime());
            Assert.assertEquals("2009-01-05T09:22:05+0000", TZ_FORMAT.format(passTime.getStartTime()));
            Assert.assertEquals("2009-01-05T09:34:20+0000", TZ_FORMAT.format(passTime.getEndTime()));
            Assert.assertEquals(NORTH, passTime.getPolePassed());
            Assert.assertEquals(4L, passTime.getAosAzimuth());
            Assert.assertEquals(256L, passTime.getLosAzimuth());
            Assert.assertEquals(14.3, passTime.getMaxEl(), 0.02);
            passTime = passPredictor.nextSatPass(passTime.getStartTime());
            Assert.assertEquals("2009-01-05T11:02:05+0000", TZ_FORMAT.format(passTime.getStartTime()));
            Assert.assertEquals("2009-01-05T11:07:35+0000", TZ_FORMAT.format(passTime.getEndTime()));
            Assert.assertEquals(NONE, passTime.getPolePassed());
            Assert.assertEquals(355L, passTime.getAosAzimuth());
            Assert.assertEquals(312L, passTime.getLosAzimuth());
            Assert.assertEquals(1.8, passTime.getMaxEl(), 0.05);
        }
        catch (InvalidTleException e) {
            Assert.fail(INVALID_TLE_EXCEPTION_WAS_THROWN);
        }
        catch (SatNotFoundException snfe) {
            Assert.fail(SAT_NOT_FOUND_EXCEPTION_WAS_THROWN);
        }
    }

    @Test
    public final void testNextSatPassWithWindBack() {
        TLE tle = new TLE(LEO_TLE);
        Assert.assertTrue(!tle.isDeepspace());
        try {
            PassPredictor passPredictor = new PassPredictor(tle, GROUND_STATION);
            DateTime cal = new DateTime(DATE_2009_01_05T04_30_00Z);
            SatPassTime passTime = passPredictor.nextSatPass(cal.toDate(), true);
            Assert.assertEquals(DATE_2009_01_05T04_28_10_0000, TZ_FORMAT.format(passTime.getStartTime()));
            Assert.assertEquals(DATE_2009_01_05T04_32_15_0000, TZ_FORMAT.format(passTime.getEndTime()));
            Assert.assertEquals(NONE, passTime.getPolePassed());
            Assert.assertEquals(52L, passTime.getAosAzimuth());
            Assert.assertEquals(84L, passTime.getLosAzimuth());
            Assert.assertEquals(0.9, passTime.getMaxEl(), 0.05);
            Assert.assertEquals((Object)436802379L, passPredictor.getDownlinkFreq(436800000L, passTime.getStartTime()));
            Assert.assertEquals((Object)145800719L, passPredictor.getUplinkFreq(145800000L, passTime.getEndTime()));
        }
        catch (InvalidTleException e) {
            Assert.fail(INVALID_TLE_EXCEPTION_WAS_THROWN);
        }
        catch (SatNotFoundException snfe) {
            Assert.fail(SAT_NOT_FOUND_EXCEPTION_WAS_THROWN);
        }
    }

    @Test
    public void correctToStringResult() {
        TLE tle = new TLE(LEO_TLE);
        Assert.assertTrue(!tle.isDeepspace());
        try {
            PassPredictor passPredictor = new PassPredictor(tle, GROUND_STATION);
            DateTime cal = new DateTime(DATE_2009_01_05T04_30_00Z);
            SatPassTime passTime = passPredictor.nextSatPass(cal.toDate(), true);
            Assert.assertEquals("Date: January 5, 2009\nStart Time: 4:28 AM\nDuration:  4.1 min.\nAOS Azimuth: 52 deg.\nMax Elevation:  0.9 deg.\nLOS Azimuth: 84 deg.", passTime.toString());
        }
        catch (InvalidTleException e) {
            Assert.fail(INVALID_TLE_EXCEPTION_WAS_THROWN);
        }
        catch (SatNotFoundException snfe) {
            Assert.fail(SAT_NOT_FOUND_EXCEPTION_WAS_THROWN);
        }
    }

    @Test
    public final void poleIsPassed() {
        TLE tle = new TLE(LEO_TLE);
        Assert.assertTrue(!tle.isDeepspace());
        try {
            PassPredictor passPredictor = new PassPredictor(tle, GROUND_STATION);
            DateTime cal = new DateTime(DATE_2009_01_05T07_00_00Z);
            boolean northFound = false;
            boolean southFound = false;
            int minute = 0;
            while (minute < 10080) {
                long startTime = cal.toDate().getTime();
                if (!northFound || !southFound) {
                    SatPassTime passTime = passPredictor.nextSatPass(cal.toDate());
                    long endTime = passTime.getEndTime().getTime();
                    String polePassed = passTime.getPolePassed();
                    if (!polePassed.equals(NONE)) {
                        if (!northFound && polePassed.equals(NORTH)) {
                            Assert.assertEquals("2009-01-05T07:42:45+0000, north", String.format(STRING_PAIR, TZ_FORMAT.format(passTime.getStartTime()), polePassed));
                            northFound = true;
                            minute += (int)((endTime - startTime) / 60000L);
                        } else if (!southFound && polePassed.equals("south")) {
                            Assert.assertEquals("2009-01-06T07:03:20+0000, south", String.format(STRING_PAIR, TZ_FORMAT.format(passTime.getStartTime()), polePassed));
                            southFound = true;
                            minute += (int)((endTime - startTime) / 60000L);
                        }
                    }
                    cal = cal.plusMinutes(minute);
                    ++minute;
                    continue;
                }
                break;
            }
        }
        catch (InvalidTleException e) {
            Assert.fail(INVALID_TLE_EXCEPTION_WAS_THROWN);
        }
        catch (SatNotFoundException snfe) {
            Assert.fail(SAT_NOT_FOUND_EXCEPTION_WAS_THROWN);
        }
    }

    @Test
    public void testGetPassList() throws InvalidTleException, SatNotFoundException {
        TLE tle = new TLE(LEO_TLE);
        Assert.assertTrue(!tle.isDeepspace());
        PassPredictor passPredictor = new PassPredictor(tle, GROUND_STATION);
        DateTime start = new DateTime(DATE_2009_01_05T07_00_00Z);
        List<SatPassTime> passed = passPredictor.getPasses(start.toDate(), 24, false);
        Assert.assertEquals(10L, passed.size());
    }

    @Test
    public void testGetPassListWithWindBack() throws InvalidTleException, SatNotFoundException {
        TLE tle = new TLE(LEO_TLE);
        Assert.assertTrue(!tle.isDeepspace());
        PassPredictor passPredictor = new PassPredictor(tle, GROUND_STATION);
        DateTime start = new DateTime(DATE_2009_01_05T07_00_00Z);
        List<SatPassTime> passes = passPredictor.getPasses(start.toDate(), 24, true);
        Assert.assertEquals(10L, passes.size());
        Assert.assertEquals(1039L, passPredictor.getIterationCount());
    }

    @Test
    public void testGetSatelliteTrack() throws Exception {
        TLE tle = new TLE(LEO_TLE);
        Assert.assertTrue(!tle.isDeepspace());
        PassPredictor passPredictor = new PassPredictor(tle, GROUND_STATION);
        DateTime referenceDate = new DateTime(DATE_2009_01_05T07_00_00Z);
        int incrementSeconds = 30;
        int minutesBefore = 50;
        int minutesAfter = 50;
        List<SatPos> positions = passPredictor.getPositions(referenceDate.toDate(), 30, 50, 50);
        Assert.assertEquals(200L, positions.size());
    }
}

