/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import java.text.NumberFormat;
import java.util.Date;

public class SatPos {
    private static final String NL = "\n";
    private static final String DEG_CR = " deg.\n";
    private static final double EARTH_RADIUS = 6378.137;
    private static final double R0 = 6378.16;
    private static final double SPEED_OF_LIGHT_IN_VACUUM = 2.99792458E8;
    private double azimuth;
    private double elevation;
    private double latitude;
    private double longitude;
    private Date time;
    private double range;
    private double rangeRate;
    private double phase;
    private double altitude;
    private double theta;
    private double eclipseDepth;
    private boolean eclipsed;
    private boolean aboveHorizon;

    public SatPos() {
    }

    public SatPos(double azimuth, double elevation, Date theTime) {
        this.azimuth = azimuth;
        this.elevation = elevation;
        this.time = new Date();
        this.time.setTime(theTime.getTime());
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public Date getTime() {
        return new Date(this.time.getTime());
    }

    public final double getRange() {
        return this.range;
    }

    public final void setRange(double range) {
        this.range = range;
    }

    public final double getRangeRate() {
        return this.rangeRate;
    }

    public final void setRangeRate(double rangeRate) {
        this.rangeRate = rangeRate;
    }

    public final double getPhase() {
        return this.phase;
    }

    public final void setPhase(double phase) {
        this.phase = phase;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public final double getAltitude() {
        return this.altitude;
    }

    public final void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public final double getTheta() {
        return this.theta;
    }

    public final void setTheta(double theta) {
        this.theta = theta;
    }

    public final void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    public final void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public final void setTime(Date time) {
        this.time = new Date(time.getTime());
    }

    public final boolean isAboveHorizon() {
        return this.aboveHorizon;
    }

    public final void setAboveHorizon(boolean aboveHorizon) {
        this.aboveHorizon = aboveHorizon;
    }

    public final double getEclipseDepth() {
        return this.eclipseDepth;
    }

    protected final void setEclipseDepth(double eclipseDepth) {
        this.eclipseDepth = eclipseDepth;
    }

    public final boolean isEclipsed() {
        return this.eclipsed;
    }

    protected final void setEclipsed(boolean eclipsed) {
        this.eclipsed = eclipsed;
    }

    public String toString() {
        return "Azimuth:    " + this.azimuth / (Math.PI * 2) * 360.0 + DEG_CR + "Elevation:  " + this.elevation / (Math.PI * 2) * 360.0 + DEG_CR + "Latitude:   " + this.latitude / (Math.PI * 2) * 360.0 + DEG_CR + "Longitude:  " + this.longitude / (Math.PI * 2) * 360.0 + DEG_CR + "Date:       " + this.time + NL + "Range:        " + this.range + " km.\n" + "Range rate:   " + this.rangeRate + " m/S.\n" + "Phase:        " + this.phase + " /(256)\n" + "Altitude:     " + this.altitude + " km\n" + "Theta:        " + this.theta + " rad/sec\n" + "Eclipsed:     " + this.eclipsed + NL + "Eclipse depth:" + this.eclipseDepth + " radians\n";
    }

    public String toShortString() {
        String returnString = "";
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(0);
        returnString = String.valueOf(returnString) + "Elevation: " + numberFormat.format(this.elevation / (Math.PI * 2) * 360.0) + DEG_CR + "Azimuth: " + numberFormat.format(this.azimuth / (Math.PI * 2) * 360.0) + DEG_CR;
        numberFormat.setMaximumFractionDigits(2);
        returnString = String.valueOf(returnString) + "Latitude: " + numberFormat.format(this.latitude / (Math.PI * 2) * 360.0) + DEG_CR + "Longitude: " + numberFormat.format(this.longitude / (Math.PI * 2) * 360.0) + DEG_CR;
        numberFormat.setMaximumFractionDigits(0);
        returnString = String.valueOf(returnString) + "Range: " + numberFormat.format(this.range) + " Km";
        return returnString;
    }

    public void copy(SatPos other) {
        this.aboveHorizon = other.aboveHorizon;
        this.altitude = other.altitude;
        this.azimuth = other.azimuth;
        this.elevation = other.elevation;
        this.latitude = other.latitude;
        this.longitude = other.longitude;
        this.phase = other.phase;
        this.range = other.range;
        this.rangeRate = other.rangeRate;
        this.theta = other.theta;
        this.time = other.time;
        this.eclipseDepth = other.eclipseDepth;
        this.eclipsed = other.eclipsed;
    }

    public double getDopplerFrequency(double freq) {
        return this.calculateDopplerFrequency(freq);
    }

    private double calculateDopplerFrequency(double downlink) {
        double dopp = -1.0 * downlink * (this.getRangeRate() * 1000.0 / 2.99792458E8);
        return dopp;
    }

    public final double[][] getRangeCircle() {
        return SatPos.calculateRangeCirclePoints(this);
    }

    private static double[][] calculateRangeCirclePoints(SatPos pos) {
        int dia = (int)(12756.33 * Math.acos(6378.137 / (6378.137 + pos.altitude)));
        double latitude = pos.latitude;
        double longitude = pos.longitude;
        double beta = 0.5 * (double)dia / 6378.16;
        double[][] result = new double[360][2];
        int azi = 0;
        while (azi < 360) {
            double azimuth = (double)azi / 360.0 * 2.0 * Math.PI;
            double rangelat = Math.asin(Math.sin(latitude) * Math.cos(beta) + Math.cos(azimuth) * Math.sin(beta) * Math.cos(latitude));
            double num = Math.cos(beta) - Math.sin(latitude) * Math.sin(rangelat);
            double den = Math.cos(latitude) * Math.cos(rangelat);
            double rangelong = azi == 0 && beta > 1.5707963267948966 - latitude ? longitude + Math.PI : (azi == 180 && beta > 1.5707963267948966 - latitude ? longitude + Math.PI : (Math.abs(num / den) > 1.0 ? longitude : (180 - azi >= 0 ? longitude - Math.acos(num / den) : longitude + Math.acos(num / den))));
            while (rangelong < 0.0) {
                rangelong += Math.PI * 2;
            }
            while (rangelong > Math.PI * 2) {
                rangelong -= Math.PI * 2;
            }
            rangelat = rangelat / (Math.PI * 2) * 360.0;
            rangelong = rangelong / (Math.PI * 2) * 360.0;
            result[azi][0] = rangelat;
            result[azi][1] = rangelong;
            ++azi;
        }
        return result;
    }
}

