/*
 * Decompiled with CFR 0.152.
 */
package uk.me.g4dpz.satellite;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import uk.me.g4dpz.satellite.GroundStationPosition;
import uk.me.g4dpz.satellite.SatPos;
import uk.me.g4dpz.satellite.Satellite;
import uk.me.g4dpz.satellite.SatelliteFactory;
import uk.me.g4dpz.satellite.TLE;

public final class SatPosTest {
    private static final String FORMAT_4F = "%4.0f %4.0f";
    protected static final String[] AO85_TLE = new String[]{"AO-85", "1 40967U 15058D   17333.47991085  .00000229  00000-0  44518-4 0 01659", "2 40967 064.7779 077.4197 0184716 018.3944 342.3672 14.75581611024180"};
    static final GroundStationPosition GROUND_STATION = new GroundStationPosition(45.510948, -73.506672, 10.0);
    private static final String FORMAT_9_7F = "%9.4f";

    @Test
    public void dopplerCalc() {
        DateTime timeNow = new DateTime("2017-12-07T18:16:00Z");
        TLE tle = new TLE(AO85_TLE);
        Satellite satellite = SatelliteFactory.createSatellite(tle);
        SatPos satellitePosition = satellite.getPosition(GROUND_STATION, timeNow.toDate());
        Assert.assertEquals("1724.2296", String.format(FORMAT_9_7F, satellitePosition.getDopplerFrequency(1.4598E8)));
    }

    @Test
    public void footprintCalculatedCorrectly() {
        SatPos pos = new SatPos();
        pos.setLatitude(0.0);
        pos.setLongitude(0.0);
        pos.setAltitude(1000.0);
        double[][] rangeCircle = pos.getRangeCircle();
        Assert.assertEquals("  30    0", String.format(FORMAT_4F, rangeCircle[0][0], rangeCircle[0][1]));
        Assert.assertEquals("   1  330", String.format(FORMAT_4F, rangeCircle[89][0], rangeCircle[89][1]));
        Assert.assertEquals(" -30  359", String.format(FORMAT_4F, rangeCircle[179][0], rangeCircle[179][1]));
        Assert.assertEquals("  -1   30", String.format(FORMAT_4F, rangeCircle[269][0], rangeCircle[269][1]));
        pos.setLatitude(0.17453292519943295);
        pos.setLongitude(0.17453292519943295);
        pos.setAltitude(1000.0);
        rangeCircle = pos.getRangeCircle();
        Assert.assertEquals("  40   10", String.format(FORMAT_4F, rangeCircle[0][0], rangeCircle[0][1]));
        Assert.assertEquals("   9  339", String.format(FORMAT_4F, rangeCircle[89][0], rangeCircle[89][1]));
        Assert.assertEquals(" -20    9", String.format(FORMAT_4F, rangeCircle[179][0], rangeCircle[179][1]));
        Assert.assertEquals("   8   41", String.format(FORMAT_4F, rangeCircle[269][0], rangeCircle[269][1]));
    }
}

